// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {UserRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment', 'hp/core/Banner', 'hp/core/Localizer', 'hp/model/Session'],
function (router, urlFragment, banner, localizer, session) { "use strict";

    var UserRoutes = ( function() {

        var ROOT_CONTAINER = '#hp-page-container';
        var CONTAINER = '#fs-users-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var AUTH_CATEGORY = 'users';
        var notPersistent = false;

        function UserRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('user',
                    '/user' + urlFragment.pagePatternTerminal, {
                    menu: {
                        footer: true,
                        label: localizer.getString('fs.users.menu'),
                        location: '/user',
                        resourceUriPattern: '^/rest/users/.+',
                        indexCategory: ['users', 'grouptorolemappings'],
                        authCategory: AUTH_CATEGORY,
                        associatedCategories: [
                            {category: 'roles', association: 'USER_TO_ROLE',
                            label: localizer.getString('fs.users.usersroles'),
                            redirect: true}]
                    },
                    container: ROOT_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/users/index.html',
                            'fs/presenter/users/UsersPresenter'],
                        function (page, presenter) {
                            presenter.checkIfActiveDirectoryConfigured({
                                success: function(directoryConfigured) {
                                    if (directoryConfigured) {
                                        // Loading either DirectoryUserView or UserView here - to avoid this scenario
                                        // When Both DirectoryUserView and UserView are loaded together in require(), OnClick of "Add" User link in LUM Page
                                        // Shows the Add User Page & in few seconds redirects to Show Page. May be due to BaseUsersView loaded twice.
                                        require(['fs/view/users/DirectoryUsersView'],
                                            function (dirView) {
                                                session.setProperty("directorytype","4",notPersistent);
                                                result.loadIfViewable(page, dirView, AUTH_CATEGORY);
                                        });
                                    }
                                    else
                                    {
                                        require(['fs/view/users/UsersView'],
                                            function (view) {
                                                session.setProperty("directorytype","2",notPersistent);
                                                result.loadIfViewable(page, view, AUTH_CATEGORY);
                                            }
                                        );
                                    }
                                },
                                error: function (errorInfo){
                                    require(['fs/view/users/UsersView'],
                                        function (view) {
                                            session.setProperty("directorytype","2",notPersistent);
                                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                                        }
                                    );
                                }
                            });
                        });
                    }
                });

                router.map('user show',
                    '/user/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/users/show.html',
                            'fs/view/users/UsersShowView'],
                        function (page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
               
                router.map('user add', '/user/add$', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/users/add.html',
                            'fs/view/users/UsersAddView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.map('user edit', '/user/edit'+ urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/users/edit.html',
                            'fs/view/users/UsersEditView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
                
                router.map('user remove', '/user/remove', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/users/show.html',
                            'fs/view/users/UsersShowView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.map('user add group mapping', '/user/group/add', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/users/addDirUserGroup.html',
                            'fs/view/users/DirUserGroupAddView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
                router.map('user edit group mapping', '/user/group/edit', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/authentication//editDirUserGroup.html',
                            'fs/view/settings/authentication/DirUserGroupEditView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
                // special case for editing current user via control in banner session
                banner.setEditUserHandler(function () {
                    require(['fs/view/users/UserSettingsEditView'],
                    function (view) {
                        view.initialize();
                    });
                });

                router.filter('user default redirector',
                    '/user' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('user no route', '/user/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            };
        }

        return new UserRoutes();
    }());

    return UserRoutes;
});
