// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['fs/model/activity/ActivityResource',
    'hp/services/IndexFilter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/EventDispatcher'], 
function(resource, IndexFilter, router, urlFragment, EventDispatcher) {"use strict";

    var ActivityPresenter = ( function() {

        /**
         * @constructor
         * @type {ActivityPresenter}
         */
        function ActivityPresenter() {

            var dispatcher = new EventDispatcher();
            
            function setFilter() {
                // We re-use the same ActivityResource with the per-resource pages.
                
 
                var filter = resource.getIndexFilter();
                if (!filter) {
                    filter = new IndexFilter();
                }     
                // Set the hidden filter properties explicitly here.           
                resource.initializeDefaultFilter(filter); 

                // turn off sub-tasks
                filter.setHiddenProperty('parentTaskUri', 'null');
                // remove any associated resource uri
                filter.unsetHiddenProperty('associatedResourceUri');
 
                resource.setIndexFilter(filter);
            }

            /**
             * @public
             */
            this.init = function () {
                setFilter();
            };
            
            this.pause = function () {
            };
            
            this.resume = function () {
                setFilter();
            };
            
            this.resource = function () {
                return resource;
            }
            
            /**
             * @public
             * Add a listener for a specified event.
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function (eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function (eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new ActivityPresenter();
    }());

    return ActivityPresenter;
});
