// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['fs/services/settings/ApplianceService',
        'fs/model/settings/TrapDestinations',
        'fs/services/settings/ApplianceUpdateService'],
function(applianceService, trapDestinations,
        updateService) { "use strict";

    var AppliancePresenter = (function() {

        /**
         * @constructor Presentation logic for the Appliance panel on the Settings Overview page.
         */
        function AppliancePresenter() {

            /**
             * Retrieve the version information for the appliance.
             *
             * @param {Object} handlers The success and error handler methods.
             */
            this.getVersion = function(handlers) {
                applianceService.getVersion({
                    success: handlers.success,
                    error: function(error) {
                        handlers.error(error);
                    }
                });
            };

            this.getTrapDestinations = function(handlers) {
                trapDestinations.getTrapDestinations({
                    success: handlers.success,
                    error: function(error) {
                        handlers.error(error);
                    }
                });
            };

            this.deleteTrapDestination = function(url, handlers) {
                trapDestinations.deleteTrapDestination(url, {
                    success: handlers.success,
                    error: function(error) {
                        handlers.error(error);
                    }
                });
            };

            this.addTrapDestination = function(uri, trapDestination, handlers) {
                trapDestinations.addTrapDestination(uri, trapDestination, {
                    success: handlers.success,
                    error: function(error) {
                        handlers.error(error);
                    }
                });
            };

            this.addDestination = function(destination){
                trapDestinations.addDestination(destination)
            };

            this.addDestinationHandler = function(handler){
                //trapDestinations.off("destinationAdded", handler);
                trapDestinations.on("destinationAdded", handler);
            };

            this.getGlobalCommunityString = function(handlers){
                updateService.getGlobalCommunityString(handlers);
            };

            this.validateHostname = function(destination, handler){
                updateService.validateHostname(destination, handler);
            }

        }

        return new AppliancePresenter();

    }());

    return AppliancePresenter;

});