// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['fs/services/backup/BackupService'],
function(backupService) { "use strict";

    /**
     * Presentation logic for the Backup panel on the Appliance Settings More page.
     * @constructor
     */
    var BackupStatusPresenter = (function() {
           
        /**
         * Retrieve the last backup status from the appliance.
         * 
         * @param {Object} handlers The success and error handler methods. 
         */
        function BackupStatusPresenter() {
  
            function checkBackupStatus(collection, handlers) {
                if (collection.count === 0) {
                    handlers.success();
                } else {
                    var backupResource = collection.members[0];
                    handlers.success(backupResource);
                }
            }
            
            this.getLastBackupStatus = function(handlers) {
                backupService.getLastBackup({
                    success: function(collection) {
                        checkBackupStatus(collection, handlers);
                    },
                    error : function(error) {
                        handlers.error(error);
                    }
                });    
            };
            
        }

        return new BackupStatusPresenter();
    }());

    return BackupStatusPresenter;
});
