// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['fs/services/settings/LicenseService',
        'fs/model/settings/LicenseModel',
        'hp/core/EventDispatcher',
        'hp/services/Log'],
function(licenseService,licenseModel, EventDispatcher, log) { "use strict";

    var LicensePresenter = (function() {

        /**
         * @constructor Presentation logic for the Licensing panel on the Settings page.
         */
        function LicensePresenter() {

            var dispatcher = new EventDispatcher();

            var initialized = false;

            function onLicenseSummarySuccess() {
                dispatcher.fire("licenseSummaryChange");
            }

            function onLicenseSummaryError(errorInfo) {
                dispatcher.fire("licenseSummaryError", errorInfo);
            }

            function onLicenseConfigSuccess() {
                dispatcher.fire("licenseConfigChange");
            }

            function onLicenseConfigError(errorInfo) {
                dispatcher.fire("licenseConfigError", errorInfo);
            }

            /**
             * @public
             * @param {String} license
             * @param {Object} handlers
             */
            this.addLicense = function(license,
                    handlers) {
                var desiredLicense = {
                    key : license,
                    type :"License"
                };
                licenseService.addLicense(desiredLicense, handlers);
            };

            this.updateLicensesummary = function() {
              licenseModel.updateLicenseSummary();
            };

            this.getLicensesummary = function() {
                return licenseModel.getLicenseSummary();
            };

            this.getConfigValue = function (key){
                 return licenseModel.getConfigValue(key);
            };
            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };

            this.init = function() {
                if (!initialized) {
                  licenseModel.on("licenseSummaryChange", onLicenseSummarySuccess);
                  licenseModel.on("licenseSummaryError", onLicenseSummaryError);
                  licenseModel.on("licenseConfigChange", onLicenseConfigSuccess);
                  licenseModel.on("licenseConfigError", onLicenseConfigError);
                  licenseModel.updateProductConfigValues();
                  initialized = true;
                }
            };

        }

        return new LicensePresenter();

    }());

    return LicensePresenter;

});
