// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define([ 'hp/core/EventDispatcher', 'hp/core/Localizer',
        'fs/services/settings/PublicKeyService' ],
function(EventDispatcher, localizer, service) {  "use strict";

    var PublicKeyPresenter = (function() {

        function PublicKeyPresenter() {

            var dispatcher = new EventDispatcher();

            function onUpdatePublicKeySuccess(data){
                dispatcher.fire("updatePublicKeySuccess", data);
            }

            function onUpdatePublicKeyError(errorInfo){
                dispatcher.fire("updatePublicKeyError", errorInfo);
            }
            function onGetPublicKeySuccess(data){
                var key=data.verificationKey;
                dispatcher.fire("getPublicKeySuccess", key);
            }

            function onGetPublicKeyError(errorInfo){
                dispatcher.fire("getPublicKeyError", errorInfo);
            }

            this.updatePublicKey = function(value) {
                var keyText = $.trim(value) + '\n',
                    key = {
                        verificationKey : keyText
                    };
                service.updatePublicKey(key, {
                    success: onUpdatePublicKeySuccess,
                    error: onUpdatePublicKeyError
                });
            };

            this.getPublicKey = function() {
                service.getPublicKey({
                    success: onGetPublicKeySuccess,
                    error: onGetPublicKeyError
                 });
            };

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new PublicKeyPresenter();

    }());

    return PublicKeyPresenter;
});