// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define([ 'hp/core/EventDispatcher', 'hp/core/Localizer',
        'fs/services/settings/SettingsService',
        'fs/services/users/UserService'],
function(EventDispatcher, localizer, service, userService) {  "use strict";

    var SettingsPresenter = (function() {

        function SettingsPresenter() {

          var dispatcher = new EventDispatcher();
          var configs = {};

          this.on = function(eventName, callback) {
              dispatcher.on(eventName, callback);
          };

          this.off = function(eventName, callback) {
              dispatcher.off(eventName, callback);
          };

          function onGetSettingSuccess(settingValue){
              dispatcher.fire("onGetSettingSuccess", settingValue);
          }

          function onGetSettingError(errorInfo){
              dispatcher.fire("onGetSettingError", errorInfo);
          }

          /*
           * Get value of a setting
           */
          this.getSetting = function(name){
              service.getSetting(name, {
                success : onGetSettingSuccess,
                error : onGetSettingError
              });
          };

          function onSetSettingSuccess(settingValue){
              dispatcher.fire("onSetSettingSuccess", settingValue);
          }

          function onSetSettingError(errorInfo){
              dispatcher.fire("onSetSettingError", errorInfo);
          }

          /*
           * Set the value for a new setting
           */
          this.setSettingWithNameAndValue = function(settingName, settingValue){
              service.setSettingWithNameAndValue(settingName, settingValue, {
                  success : onSetSettingSuccess,
                  error : onSetSettingError
              });
          };

          /*
           * Update value of existing setting
           */
          this.updateSettingWithNameAndValue = function(settingName, settingValue){
              service.updateSettingWithNameAndValue(settingName, settingValue, {
                  success : onSetSettingSuccess,
                  error : onSetSettingError
              });
          };

          function onGetProductConfigSuccess(productConfigs){
              productConfigs = (productConfigs) ? productConfigs : {};
              if (configs['settings.security.firmwarebundles.show'] === null ||
                  configs['settings.security.firmwarebundles.show'] === undefined||
                  configs['settings.security.ldap.credential.save'] === null ||
                  configs['settings.security.ldap.credential.save'] === undefined){
                  if(productConfigs.members!=null){
                     for(var i=0;i < productConfigs.members.length;i++){
                         if (productConfigs.members[i].name.match(/^settings.security.firmwarebundles.show$/)||
                            productConfigs.members[i].name.match(/^settings.security.ldap.credential.save$/)){
                             configs[productConfigs.members[i].name] = productConfigs.members[i].value;
                         }
                     }
                  }
              }
              dispatcher.fire("getProductConfigSuccess", configs);
          }

          function onGetProductConfigError(errorInfo){
              dispatcher.fire("getProductConfigError", errorInfo);
          }

          /**
           * To retrieve values in /ci/etc/product-config.json
           *
           */
          this.getProductConfig = function(){
              if (configs['settings.security.firmwarebundles.show'] === null ||
                  configs['settings.security.firmwarebundles.show'] === undefined||
                  configs['settings.security.ldap.credential.save'] === null ||
                  configs['settings.security.ldap.credential.save'] === undefined){
                  userService.getProductConfig({
                      success: onGetProductConfigSuccess,
                      error: onGetProductConfigError
                  });
              }else{
                  dispatcher.fire("getProductConfigSuccess", configs);
              }
           };
        }

        return new SettingsPresenter();

    }());

    return SettingsPresenter;
});