// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/services/REST'],
function(REST) {"use strict";

    var ApplianceService = (function() {

        /**
         * @constructor Service for retrieval of appliance version information.
         */
        function ApplianceService() {

            /**
             * Retrieve appliance version information from the server.
             *
             * @param {Object} handlers The success and error handler methods.
             */
            this.getVersion = function(handlers) {
                REST.getURI('/rest/appliance/version', handlers);
            };

            /**
             * Retrieve appliance uri .
             *
             * @param {Object} handlers The success and error handler methods.
             */
            this.getApplianceUri = function(handlers) {
                REST.getURI('/rest/global-settings/appliance-uri-name', handlers);
            };

            /**Get Product-Config Values
             *@param {Object} handlers handlers with error and success.
             */

            this.getConfigValues = function(handlers){
                REST.getURI('/rest/appliance/product-config', handlers);
            };

        }

        return new ApplianceService();

    }());

    return ApplianceService;

});

