// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/services/REST', 'jquery'], function(REST) {"use strict";

    return {

        removeFile : function(handlers){
            REST.deleteURI('/rest/appliance/firmware/pending', handlers);
        },

        releaseNotes : function(fileName, docType, handlers, options){
            var uri = '/rest/appliance/firmware/document-content/' + fileName + '/' + docType;
            REST.getURI(uri, handlers, options);
        },

        apply : function(fileName, handlers){
            var uri = '/rest/appliance/firmware/pending?file=' + fileName;
            REST.putObject(uri, null, null, handlers);
        },

        isPending : function(handlers) {
            REST.getURI('/rest/appliance/firmware/pending', handlers);
        },

        currentStatus : function(handlers){
            REST.getURI('/cgi-bin/status/update-status.cgi', handlers);
        },

        usersLoggedIn : function(handlers){
            REST.getURI('/rest/active-user-sessions', handlers);
        },

        applianceHealth : function(handlers) {
            REST.getURI('/rest/appliance/health-status', handlers);
        },

        addOrUpdateGlobalCommunityString : function(csObject, handlers){
            REST.postObject('/rest/appliance/device-read-community-string', csObject, handlers);
        },

        getUpgradeStatus : function(handlers) {
            REST.getURI('/rest/appliance/firmware/notification', handlers);
        },

        getGlobalCommunityString : function(handlers){
            REST.getURI("/rest/appliance/device-read-community-string", handlers);
        },

        validateHostname : function(destination, handlers){
            REST.postObject("/rest/appliance/trap-destinations/validation", destination, handlers);
        }
    };
});
