//(C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * This entire file deals with timeDto. The timeDto format is
 timeDto = {
     dateTime : "",
     timezone : "",
     ntpServers : [],
     pollingInterval : ""
 };
 */
define(['hp/services/REST'],
function (REST) {"use strict";

    var DateTimeSetupService = (function () {
        function DateTimeSetupService() {
            //Get the local system date and time
            this.getDateTime = function(handlers) {
                REST.getURI('/rest/appliance/configuration/timeconfig/time', handlers);
            };
            //Get the time of the system
            this.getTimezone = function(handlers) {
                REST.getURI('/rest/appliance/configuration/timeconfig/timezone', handlers);
            };
            //Get the list of NTP servers listed in /etc/ntp.conf file
            this.getNTPservers = function(handlers) {
                REST.getURI('/rest/appliance/configuration/timeconfig/ntp', handlers);
            };
            //Get the locale of the system
            this.getLocale	 = function(handlers) {
                REST.getURI('/rest/appliance/configuration/timeconfig/locale', handlers);
            };
            //Get the list of timezones available in the system
            this.getTimeZones = function(handlers)
            {
                REST.getURI('/rest/appliance/configuration/timeconfig/timezones', handlers);
            };
            //Get the list of locales available in the system
            this.getLocales = function(handlers)
            {
                REST.getURI('/rest/appliance/configuration/timeconfig/locales', handlers);
            };
            /**
             * Sets the user selected date and time on the appliance
             * @param dateAndTimeData contains the date and time
             */
            this.setDateTime = function(dateAndTimeData,handlers){
                var dateTime = dateAndTimeData.replace(" ","T");
                var timeDto = {
                    dateTime : dateTime,
                    timezone : null,
                    ntpServers : null,
                    pollingInterval : null
                };
                REST.postObject('/rest/appliance/configuration/timeconfig/ntp',timeDto,handlers);
            };
            /**
             * Sets the user entered ntp server on the appliance.
             * @param ntpServersData contains the ntp server list
             */
            this.setNTPservers = function(ntpServersData,handlers){
                var timeDto = {
                    dateTime : null,
                    timezone : null,
                    ntpServers : $.makeArray(ntpServersData),
                    pollingInterval : null
                };
                REST.postObject('/rest/appliance/configuration/timeconfig/ntp',timeDto,handlers);
            };
            /**
             * Sets the user selected timezone on the appliance.
             * @param timezoneData contains the timezone info.
             */
            this.setTimezone = function(timezoneData,handlers){
                var timeDto = {
                    dateTime : null,
                    timezone : timezoneData,
                    ntpServers : null,
                    pollingInterval : null
                };
                REST.postObject('/rest/appliance/configuration/timeconfig/timezone',timeDto,handlers);
            };
            /**
             * Sets the user selected locale on the appliance.
             * @param localeData contains the locale info.
             */
            this.setLocale = function(localeData,handlers){
                var localeDto = {
                    locale : localeData,
                    displayName : null
                };
                REST.putObject('/rest/appliance/configuration/timeconfig/locale',localeDto,"",handlers);
            };
        }
        return new DateTimeSetupService();

    }());

    return DateTimeSetupService;

});

