// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define([ 'hp/services/REST', 'jquery' ], function(REST) {
    "use strict";
    var version = '100';
    return {

        /**
         * Add a license
         *
         * @param {Object}
         *            license object
         * @params {Object} handlers with error and success.
         */
        addLicense : function(licenseObject, handlers) {
            REST.postObject('/rest/licenses', licenseObject, handlers);
        },

        /**
         * Get the license summary view
         * @param {Object} handlers handlers with error and success.
         */
        getLicenseSummary : function(handlers) {
            REST.getURI('/rest/licenses?view=summary', handlers);
        },

         /**
         * Get the license summary view new version
         * @param {Object} handlers handlers with error and success.
         */
        getLicenseSummaryVer : function(handlers) {
            REST.getURI('/rest/licenses?view=summary', handlers,{apiVersion: version});
        }
    };
});
