// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['fs/presenter/activity/ActivityResourcePresenter',
    'hp/view/IndexView',
    'fs/view/activity/ActivityRenderer',
    'fs/view/activity/ActivityAlertView',
    'fs/view/activity/ActivityTaskView',
    'hp/core/Localizer',
    'text!fsPages/activity/filters.html',
    'jquery',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpSelectDateRange',
    'hp/lib/jquery.hpTimestamp',
    'hp/lib/jquery.hpProgressBar'],
function(ActivityResourcePresenter, IndexView, activityRenderer, activityAlertView,
    activityTaskView, localizer, filtersHtml) { "use strict";

    var ActivityResourceView = (function() {
      
        var CONTAINER = '.hp-activity-resource';
        
        /**
         * Constructor
         */
        function ActivityResourceView() {
          
            // The route context we are running in. The caller sets this
            // before we are initialized so we can eventually tell our
            // presenter what to care about.
            var route;
            var presenter = new ActivityResourcePresenter();
            var indexView = new IndexView();
            
            function detailsRenderer(indexResult, userToggle, handler) {
                if (userToggle) {
                    presenter.activate(indexResult.uri);
                }
                return activityRenderer.renderDetails(indexResult, undefined, handler);
            }
            
            function detailsCollapsed(indexResult) {
                presenter.deactivate();
                return activityRenderer.detailsCollapsed(indexResult);
            }
            
            function onActiveUriChange(uri) {
                indexView.scrollToUriAndExpand(uri);
            }
            
            function unregisterListeners() {
                presenter.off('activeUriChange', onActiveUriChange);
            }
            
            function registerListeners() {
                presenter.on('activeUriChange', onActiveUriChange);
            }
            
            /**
             * @public
             */
            this.route = route;
            
            this.pause = function () {
                activityAlertView.pause();
                activityTaskView.pause();
                unregisterListeners();
                indexView.pause();
                presenter.pause();
            };
            
            this.resume = function () {
                activityAlertView.resume();
                activityTaskView.resume();
                registerListeners();
                indexView.resume();
                presenter.resume();
            };
            
            this.init = function () {
              
                var filters = $(filtersHtml);
                localizer.localizeDom(filters);
                $('#hp-activity-resource-view').prepend(filters);
                
                presenter.init(this.route);
                activityAlertView.init();
                activityTaskView.init();
                
                $('#hp-activity-date-filter').hpSelectDateRange();
                
                indexView.init({
                    container: $(CONTAINER),
                    resource: presenter.resource(),
                    detailsRenderer: detailsRenderer,
                    detailsCollapsed: detailsCollapsed,
                    dataTableOptions:  {
                        aoColumns : [
                            // expand/collapse
                            {fnRender: function (oObj) {
                                return '<div class="hp-collapser"></div>';
                              },
                              sWidth: '20px', sClass: "hp-icon", sDefaultContent: ''},
                            // status
                            {fnRender: activityRenderer.renderStatus,
                                sDefaultContent: '',
                                sWidth: '15px', sClass: "hp-icon"},
                            // name
                            {fnRender: activityRenderer.renderName,
                                sDefaultContent: '',
                                mDataProp: 'name', sClass: "hp-name"},
                            // date
                            {mDataProp: 'created', sWidth: '120px'},
                            // state
                            {fnRender: activityRenderer.renderState,
                                sDefaultContent: '', sWidth: '140px'},
                            // owner
                            {fnRender: activityRenderer.renderOwner,
                                sDefaultContent: '', sWidth: '120px'}
                        ],
                        aaSorting: [[ 3, "desc" ]],
                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            if (aData.category === 'alerts') {
                                $(nRow).addClass('hp-alert');
                            } else if (aData.category === 'tasks') {
                                $(nRow).addClass('hp-task');
                            }
                            $(nRow).attr('data-uri', aData.uri);
                            $('td:eq(1) > div', nRow).hpStatus();
                            $('td:eq(3)', nRow).hpTimestamp();
                            activityTaskView.annotateRow(nRow, aData);
                            return nRow;
                        }
                    }
                });
                
                registerListeners();
                
                presenter.resume();
            };
        }

        return ActivityResourceView;
    }());
    
    return ActivityResourceView;
});

/// TBD:
///   put scrolling in the right place in the table
