// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['fs/presenter/activity/ActivityPresenter',
    'hp/view/MasterPaneView',
    'fs/view/activity/ActivityRenderer',
    'fs/view/activity/ActivityAlertView',
    'fs/view/activity/ActivityTaskView',
    'hp/core/StatusState',
    'hp/core/LinkTargetBuilder',
    'hp/core/Localizer',
    'hp/model/Session',
    'text!fsPages/activity/filters.html',
    'jquery',
    'hp/lib/jquery.hpDropMenu',
    'hp/lib/jquery.hpSelectDateRange',
    'hp/lib/jquery.hpStatus',
    'hp/lib/jquery.hpTimestamp'],
function(presenter, MasterPaneView, activityRenderer, activityAlertView, activityTaskView,
    statusState, linkTargetBuilder, localizer, session, filtersHtml) { "use strict";

    var ActivityView = (function() {
      
        var TYPE = 'activity';
        var PAGE = '#hp-activity-page';
      
        /**
         * Constructor
         */
        function ActivityView() {
          
            var masterPaneView = new MasterPaneView();
            
            /**
             * @public
             */
            this.pause = function () {
                masterPaneView.pause();
                activityAlertView.pause();
                activityTaskView.pause();
                presenter.pause();
            };
            
            this.resume = function () {
                masterPaneView.resume();
                activityAlertView.resume();
                activityTaskView.resume();
                presenter.resume();
                $('#hp-owner-me').attr('data-id', session.getUser());
            };
            
            this.init = function () {
                
                var filters = $(filtersHtml);
                localizer.localizeDom(filters);
                $(PAGE + ' .hp-sub-nav .hp-filterbar-control').after(filters);
                
                presenter.init();
                activityAlertView.init();
                activityTaskView.init();
                
                $('#hp-activity-actions').hpDropMenu();
                $('#hp-activity-date-filter').hpSelectDateRange();
                
                $('#hp-owner-me').attr('data-id', session.getUser());
                
                masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: presenter.resource(),
                    page: $(PAGE),
                    multiSelect: true,
                    requireSelection: false,
                    detailsRenderer: activityRenderer.renderDetails,
                    detailsCollapsed: activityRenderer.collapsedDetails,
                    dataTableOptions:  {
                        aoColumns : [
                            // expand/collapse
                            {fnRender: function (oObj) {
                                return '<div class="hp-collapser"></div>';
                              },
                              sWidth: '20px', sClass: "hp-icon", sDefaultContent: ''},
                            // status
                            {fnRender: activityRenderer.renderStatus,
                                sDefaultContent: '',
                                mDataProp: 'status',
                                sWidth: '15px', sClass: "hp-icon"},
                            // name
                            {fnRender: activityRenderer.renderName,
                                sDefaultContent: '',
                                mDataProp: 'name', sClass: "hp-name"},
                            // source
                            {fnRender: activityRenderer.renderSource,
                                sDefaultContent: '', sWidth: '140px',
                                mDataProp: 'attributes.associatedResourceName',
                                sClass: "hp-source"},
                            // date
                            {mDataProp: 'created', sWidth: '120px'},
                            // state
                            {fnRender: activityRenderer.renderState,
                                sDefaultContent: '', sWidth: '140px',
                                mDataProp: 'state'},
                            // owner
                            {fnRender: activityRenderer.renderOwner,
                                sDefaultContent: '', sWidth: '120px',
                                mDataProp: 'attributes.owner'}
                        ],
                        aaSorting: [[ 4, "desc" ]],
                        fnRowCallback : function (row, data, iDisplayIndex, iDisplayIndexFull) {
                            if (data.category === 'alerts') {
                                $(row).addClass('hp-alert');
                            } else if (data.category === 'tasks') {
                                $(row).addClass('hp-task');
                            }
                            $(row).attr('data-uri', data.uri);
                            $('td:eq(1) > div', row).hpStatus();
                            $('td:eq(4)', row).hpTimestamp();
                            activityRenderer.annotateRow(row, data);
                            return row;
                        }
                    }
                });
            };
        }

        return new ActivityView();
    }());
    
    return ActivityView;
});
