// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['fs/presenter/activity/ActivityAlertPresenter',
    'hp/core/Localizer',
    'hp/view/DialogView',
    'text!fsPages/activity/clear.html',
    'jquery'],
function(presenter, localizer, DialogView, clearHtml) { "use strict";

    var AlertClearView = (function() {

        /**
         * Constructor
         */
        function AlertClearView() {

            var inProgress = false;
            var dialog = null;

            function showDialog(resultsForState) {
                var contents = $(clearHtml).filter('.hp-dialog');
                localizer.localizeDom(contents);

                dialog = new DialogView({contents: contents,
                    ok: function () {
                        inProgress = false;
                        dialog = null;
                        presenter.clearSelected();
                        return true;
                    },
                    cancel: function () {
                        inProgress = false;
                        dialog = null;
                    }
                });

                if (resultsForState.usable.length === 0) {
                    dialog.setMessage({summary: localizer.getString(
                        (resultsForState.ignore.length > 0) ? 
                            'fs.alerts.clear.none_clearable' : 'fs.alerts.show.selected_none')});
                    $('#hp-alert-clear-prompt').hide();
                    $('#hp-alert-clear-ok').hide();
                    $('#hp-alert-clear-cancel').
                        text(localizer.getString('core.details.ok')).
                        addClass('hp-primary');
                } else {
                    dialog.setMessage({summary:
                        localizer.getString('fs.alerts.clear.some_clearable')});
                }
            }

            this.clearSelected = function () {
                var resultsForState = presenter.getResultsForState('active', true);

                if (resultsForState.ignore.length > 0 || resultsForState.usable.length === 0) {
                    if (!inProgress) {
                        inProgress = true;
                        showDialog(resultsForState);
                    }
                } else {
                    presenter.clearSelected();
                }
            };
        }

        return new AlertClearView();
    }());

    return AlertClearView;
});
