// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['fs/presenter/activity/ActivityAlertPresenter',
    'hp/core/Localizer',
    'hp/view/DialogView',
    'text!fsPages/activity/restore.html',
    'jquery'],
function(presenter, localizer, DialogView, clearHtml) { "use strict";

    var AlertRestoreView = (function() {

        /**
         * Constructor
         */
        function AlertRestoreView() {

            var inProgress = false;
            var dialog = null;

            function showDialog(resultsForState) {
                var contents = $(clearHtml).filter('.hp-dialog');
                localizer.localizeDom(contents);

                dialog = new DialogView({contents: contents,
                    ok: function () {
                        inProgress = false;
                        dialog = null;
                        presenter.restoreSelected();
                        return true;
                    },
                    cancel: function () {
                        inProgress = false;
                        dialog = null;
                    }
                });

                if (resultsForState.usable.length === 0) {
                    dialog.setMessage({summary: localizer.getString(
                        (resultsForState.ignore.length > 0) ? 
                            'fs.alerts.restore.none_restoreable' : 'fs.alerts.show.selected_none')});
                    $('#hp-alert-restore-prompt').hide();
                    $('#hp-alert-restore-ok').hide();
                    $('#hp-alert-restore-cancel').
                        text(localizer.getString('core.details.ok')).
                        addClass('hp-primary');
                } else {
                    dialog.setMessage({summary:
                        localizer.getString('fs.alerts.restore.some_restoreable')});
                }
            }

            this.restoreSelected = function () {
                var resultsForState = presenter.getResultsForState('cleared', true);

                if (resultsForState.ignore.length > 0 || resultsForState.usable.length === 0) {
                    if (!inProgress) {
                        inProgress = true;
                        showDialog(resultsForState);
                    }
                } else {
                    presenter.restoreSelected();
                }
            };
        }

        return new AlertRestoreView();
    }());

    return AlertRestoreView;
});
