define(['hp/core/UrlFragment',
    'hp/services/Log',
    'hp/core/Localizer',
    'fs/view/alerts/AlertsBaseView'
    ],
function(urlFragment, log, Localizer, AlertsBaseView) { "use strict";
    var ContextSensitiveAlertsView = (function(){
        var ACTION_MENU = '.hp-details-actions .hp-options';
       
        var ALERT_OPTIONS_ID = 'alert-options';
        var ALERT_OPTIONS_SELECTOR = '#' + ALERT_OPTIONS_ID;


        function ContextSensitiveAlertsView(table, presenter){

            // pass in the id of the table, the function for calculating the height of the table,
            // and whether the source column should be shown (boolean value)
            var alertsBaseView = new AlertsBaseView(table, false);

            // private
            function updateAlertsList(selection) {
                alertsBaseView.setPhysicalResourceUri(selection.uris[0]);
            }

            // private
            // removes alert-specific options from the actions menu
            function removeAlertOptions(){
                $('.hp-details-actions').removeClass('cic-alerts-actions-button');
                $(ALERT_OPTIONS_SELECTOR).remove();
            }

            // private
            // appends a single alert-specific option
            function appendOneOption(alertOptions, id, localize, text)
            {
                alertOptions.append(
                        "<li><a id='" + id + "'>" + Localizer.getString(localize) + "</a></li>");
            }

            // private
            // appends alert-specific options to the Actions menu
            function appendAlertOptions(){
                $('.hp-details-actions').addClass('cic-alerts-actions-button');

                var $alertOptions = $('<ol></ol>').attr('id', ALERT_OPTIONS_ID)
                    .text(Localizer.getString('fs.alerts.show.alerts'))
                    .appendTo(ACTION_MENU);

                appendOneOption($alertOptions, 'cic-alert-assign', 'fs.alerts.show.assign');
                appendOneOption($alertOptions, 'cic-alert-clear', 'fs.alerts.show.clear');
                appendOneOption($alertOptions, 'cic-alert-restore', 'fs.alerts.show.restore');
                appendOneOption($alertOptions, 'cic-alert-delete', 'fs.alerts.show.delete');
            }

            // private
            // updates the alert list when the LHS changes
            function onSelectionChange(selection) {
                updateAlertsList(selection);
            }

            // public
            this.init = function() {
                // replace the id of the table with the id passed in
                $('#cic-alerts-table').attr('id', table.substring(1));
                presenter.on("selectionChange", onSelectionChange);
                appendAlertOptions();
                alertsBaseView.init();
                updateAlertsList(presenter.getSelection());
            };

            // public
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                alertsBaseView.pause();
                removeAlertOptions();
            };

            // public
            this.resume = function() {
                appendAlertOptions();
                alertsBaseView.resume();
                updateAlertsList(presenter.getSelection());
                presenter.on("selectionChange", onSelectionChange);
            };

        }
        return ContextSensitiveAlertsView;
    }());

    return ContextSensitiveAlertsView;
});
