// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @constructor
 * @type {CommonDisplayView}
 */
define([
'fs/presenter/settings/NetworkSetupPresenter',
'fs/presenter/settings/SettingsPresenter',
'jquery'],
function( networkPresenter, settingsPresenter) {"use strict";

    var CommonDisplayView = ( function() {

        var SECURITY_FIRMWAREBUNDLE_OVERVIEW_LINK = '#fs-settings-security-firmwarebundle-selector-listitem';
        var CLASS_SNMP_DISABLE = '.fs-settings-snmp-remove';

        function CommonDisplayView(){
            function getProductConfigSuccess(productConfigs){
                if (productConfigs["settings.security.firmwarebundles.show"] === "true"){
                    $(SECURITY_FIRMWAREBUNDLE_OVERVIEW_LINK).show();
                }else{
                    $(SECURITY_FIRMWAREBUNDLE_OVERVIEW_LINK).hide();
                }
                settingsPresenter.off('getProductConfigSuccess', getProductConfigSuccess);
            }

            this.manageDisplayInOverviewDropdown = function(){
                settingsPresenter.on('getProductConfigSuccess', getProductConfigSuccess);
                if(networkPresenter.trapForwardingDisabled())
                {
                    $(CLASS_SNMP_DISABLE).remove();
                }
                settingsPresenter.getProductConfig();
             };
        }
        return new CommonDisplayView();
    }());
    return CommonDisplayView;
});
