// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/view/settings/SettingsView',
        'hp/view/settings/SettingsOverviewView',
        'hp/core/Environment',
        'fs/view/settings/backup/BackupActionView',
        'hp/model/settings/DevelopmentRoutes',
        'fs/model/settings/AuthnRoutes',
        'fs/model/settings/ApplianceRoutes',
        'fs/model/settings/ApplianceUpdateRoutes',
        'text!fsPages/settings/appliance/view_selectors.html',
        'fs/presenter/settings/NetworkSetupPresenter',
        'hp/presenter/settings/FactoryResetPresenter',
        'fs/model/settings/SupportDumpRoutes',
        'fs/model/settings/CertificateRoutes',
        'fs/model/settings/FactoryResetRoutes',
        'fs/model/settings/ApplianceShutdownRoutes',
        'fs/model/settings/SecurityRoutes',
        'fs/model/settings/SupportRoutes',
        'fs/model/settings/LicenseRoutes',
        'fs/model/settings/RestoreRoutes',
        'fs/model/settings/BackupRoutes',
        'text!fsPages/settings/security/view_selectors.html',
        'text!fsPages/settings/support/view_selectors.html',
        'text!fsPages/settings/license/view_selectors.html',
        'hp/core/Localizer'],
function (settingsView,
          overviewView,
          environment,
          backupView,
          developmentRoutes,
          authnRoutes,
          applianceRoutes,
          applianceUpdateRoutes,
          applianceViewSelectors,
          networkSetupPresenter,
          factoryResetPresenter,
          supportDumpRoutes,
          certificateRoutes,
          factoryResetRoutes,
          applianceShutdownRoutes,
          securityRoutes,
          supportRoutes,
          licenseRoutes,
          restoreRoutes,
          backupRoutes,
          securityViewSelectors,
          supportViewSelectors,
          licenseViewSelectors,
          localizer) { "use strict";

    var FsSettingsViews = ( function() {

        var CLASS_IPV6_DISABLE = '.fs-settings-ipv6-remove';
        var CLASS_SNMP_DISABLE = '.fs-settings-snmp-remove';

        function FsSettingsViews() {

            this.getSettingsInfo = function () {

                var settings = [
                    {
                        registerRoutes: applianceRoutes.register,
                        authCategory: 'appliance',
                        registerOverview: function(result) {
                            require(['text!fsPages/settings/appliance/overview.html',
                                     'fs/view/settings/appliance/ApplianceShowView',
                                     'hp/view/settings/SettingsOverviewView'],
                            function (panel, view, overview) {
                                overview.register(panel, view, {priority : 10});
                            });
                        },
                        registerViewSelectors: function() {
                            if (networkSetupPresenter.iPv6Disabled()) {
                                $(CLASS_IPV6_DISABLE, $(applianceViewSelectors)).remove();
                            }
                            if (networkSetupPresenter.trapForwardingDisabled()) {
                                $(CLASS_SNMP_DISABLE, $(applianceViewSelectors)).remove();
                            }
                            settingsView.registerViewSelectors(applianceViewSelectors);
                        }
                    },
                    {
                        registerRoutes: applianceUpdateRoutes.register,
                        authCategory: 'appliance'
                    },
                    {
                        registerRoutes: authnRoutes.register,
                        authCategory: 'appliance',
                        registerOverview: function(result) {
                            require(['text!fsPages/settings/authentication/overview.html',
                                     'fs/view/settings/authentication/AuthenticationShowView',
                                     'hp/view/settings/SettingsOverviewView'],
                            function (panel, view, overview) {
                                //overview.register(panel, view, {priority : 30});
                            });
                        }
                    },
                    {
                        registerRoutes: developmentRoutes.register,
                        authCategory: 'appliance',
                        registerOverview: function(result) {
                            require(['text!hpPages/settings/development/overview.html',
                                     'hp/view/settings/DevelopmentShowView',
                                     'hp/view/settings/SettingsOverviewView'],
                            function (panel, view, overview) {
                                overview.register(panel, view, {priority : 40});
                            });
                        }
                    },

                    {
                        registerRoutes: securityRoutes.register,
                        authCategory: 'appliance',
                        registerOverview: function(result) {
                            require(['text!fsPages/settings/security/overview.html',
                                     'fs/view/settings/security/SecurityShowView',
                                     'hp/view/settings/SettingsOverviewView'],
                            function (panel, view, overview) {
                                overview.register(panel, view, {priority : 60});
                            });
                        },
                        registerViewSelectors: function() {
                            settingsView.registerViewSelectors(securityViewSelectors);
                        }
                    },
                    {
                        registerRoutes: supportRoutes.register,
                        authCategory: 'appliance',
                        registerViewSelectors: function() {
                            settingsView.registerViewSelectors(supportViewSelectors);
                        }
                    },
                    {
                        registerRoutes: licenseRoutes.register,
                        authCategory: 'appliance',
                        registerViewSelectors: function() {
                            settingsView.registerViewSelectors(licenseViewSelectors);
                        },
                        actions: [{ id: 'hp-add-license-link',
                            location: '#/settings/add/license',
                            authCategory: 'licenses',
                            label: localizer.getString('fs.settings.license.config.add_license')
                        }]
                    },
                    {
                        registerRoutes: certificateRoutes.register,
                        authCategory: 'appliance',
                        actions: [{ id: 'hp-create-cert-link',
                            location: '#/settings/add/appliance_certificate',
                            authCategory: 'appliance',
                            label: localizer.getString('fs.settings.certificate.selfsigned.create_action_title')
                        },
                        {id: 'hp-create-csr-link',
                            location: '#/settings/add/appliance_csr',
                            authCategory: 'appliance',
                            label: localizer.getString('fs.settings.certificate.csr.create_action_title')
                        },
                        {id: 'hp-import-cert-link',
                            location: '#/settings/add/appliance_import_certificate',
                            authCategory: 'appliance',
                            label: localizer.getString('fs.settings.certificate.signedimport.import_action_title')
                        }]
                    },
                    {
                        authCategory: 'appliance',
                        actions: [{ id: 'hp-update-appliance',
                            location: '#/settings/update/appliance',
                            authCategory: 'appliance',
                            label: localizer.getString('fs.settings.appliance.updateLink')
                        }]
                    },
                    {
                        authCategory: 'appliance',
                        actions: [{ id: 'hp-support-access',
                            location: '#/settings/edit/supportaccess',
                            authCategory: 'appliance',
                            label: localizer.getString('fs.settings.eula.config.edit_appliance_support_access')
                        }]


                    }

                ];
                 if (!environment.isKioskMode())  // Create support dump link is not available in the kiosk mode
                 {
                     /*inserted into settings at index 3 so that Create support dump action appears first in the Actions dropdown.
                     Any additional actions should be added after Create support dump action */
                     settings.splice(3,0,
                          {
                              registerRoutes: supportDumpRoutes.register,
                              actions: [{ id: 'hp-create-dump-link',
                                 location: '#/settings/support/createSupportDump',
                                 label: localizer.getString('fs.settings.supportdump.createtitle')
                              }]
                          });
                  }
                settings.push(
                     {
                        registerRoutes: backupRoutes.register,
                        authCategory: 'backups',
                        actions: [{ id: 'hp-backup-appliance',
                            authCategory: 'backups',
                            click: backupView.startBackup,
                            label: localizer.getString('fs.settings.backup.backupAction')
                        }]
                    } );

                 if (!environment.isKioskMode())  // download is not available in the kiosk mode
                 {
                     settings.push(
                          {
                              authCategory: 'backups',
                              actions: [{ id: 'hp-download-appliance-backup',
                                 authCategory: 'backups',
                                 click: backupView.downloadLastBackup,
                                 label: localizer.getString('fs.settings.backup.backupDownloadAction')
                              }]
                          });

                  }

                 if (!environment.isKioskMode())  // download audit logs is not available in the kiosk mode
                 {
                     settings.push(
                             {
                                 authCategory: 'appliance',
                                 actions: [{ id: 'hp-download-audit-logs-link',
                                     location: '/rest/audit-logs/download',
                                     authCategory: 'appliance',
                                     label: localizer.getString('fs.settings.auditlogs.download')
                                 }]
                             });
                  }


                 settings.push(  // file uploader will inform a user that this operation not available in the kiosk mode
                      {
                        registerRoutes: restoreRoutes.register,
                        authCategory: 'appliance',
                        actions: [{ id: 'hp-restore-appliance',
                            location: '#/settings/restore/appliance',
                            authCategory: 'appliance',
                            label: localizer.getString('fs.settings.restore.restoreAction')
                        }]
                    });

                if (!factoryResetPresenter.factoryResetDisabled()) {
                    settings.push(
                       {
                           registerRoutes: factoryResetRoutes.register,
                           authCategory: 'appliance',
                           actions: [{ id: 'hp-reset-factory-link',
                               location: '#/settings/reset/factoryReset',
                               authCategory: 'appliance',
                               label: localizer.getString('fs.settings.factoryReset.factoryResetAction')
                           }]


                    });
                }
                // the  following actions will appear "separated" at the bottom  of the action  menu
                settings.push(
                       {
                           registerRoutes: applianceShutdownRoutes.register,
                           authCategory: 'appliance',
                           actions: [{ id: 'hp-appliance-reset-link',
                               location: '#/settings/shutdown/applianceShutdown',
                               authCategory: 'appliance',
                               label: localizer.getString('fs.settings.shutdown.shutdownAction'),
                               group : 'os' // indicates that this action should be in the "separate" menu section
                           }]


                });
                settings.push(
                       {
                           registerRoutes: applianceShutdownRoutes.register,
                           authCategory: 'appliance',
                           actions: [{ id: 'hp-appliance-reset-link',
                               location: '#/settings/shutdown/applianceRestart',
                               authCategory: 'appliance',
                               label: localizer.getString('fs.settings.restart.shutdownAction'),
                               group : 'os'
                           }]


                });
                return settings;
            };
        }

        return new FsSettingsViews();
    }());

    return FsSettingsViews;
});
