// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define([ 'hp/core/Notifications' ],
function(notifications) { "use strict";

    var AuthenticationSettingsBaseView = (function() {

        function AuthenticationSettingsBaseView() {
            var NOTIFY_BOX = '#fs-settings-details-notify',
            NOTIFY_MSG = "#fs-settings-details-notify-message-id",
            NOTIFICATION_CLASS = "hp-details-notify ",
            NOTIFICATION_COLOR_PREFIX = "hp-details-notify-";

            function displaySettingsNotificationDetails(message, messageType) {
                $(NOTIFY_MSG).append('</br>' + message);
                $(NOTIFY_BOX).attr('class', NOTIFICATION_CLASS + NOTIFICATION_COLOR_PREFIX + messageType);
                $(NOTIFY_BOX).fadeIn();
            }

            this.displayNotifications = function(message, details, type) {
                notifications.show(message);
                var notificationDetailsMessage = message + details;
                displaySettingsNotificationDetails(notificationDetailsMessage, type);
            };

            this.resetNotifications = function() {
                // resets error messages
                $(NOTIFY_MSG).text("");
                $(NOTIFY_BOX).hide();
            };

        }

        return new AuthenticationSettingsBaseView();

    }());

    return AuthenticationSettingsBaseView;

});
