// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define([
    'hp/core/NotificationFormatter',
    'fs/common/AlertNotificationFormatter',
    'hp/model/Session',
    'hp/core/Localizer'],
function(notificationFormatter, alertFormatter, session, localizer) {"use strict";

    var LicenseAlertFormatter = ( function() {

        var AUTH_CATEGORY = "appliance",
            SUPPORT_LINK = "https://hp.com/software/licensing";

        /**
         * @constructor
         * @type {LicenseAlertFormatter}
         */
        function LicenseAlertFormatter() {

            var alertTypeIds = [
                {alertTypeId: 'licenses.overconsumed', authCategory: 'licenses', authAction: 'Create', link: makeAddLicenseLink},
                {alertTypeId: 'licenses.overconsumed', authCategory: 'licenses', authAction: 'Read', link: makeLicenseSupportLink}
            ];

            function makeAddLicenseLink() {
                 var name = localizer.getString('fs.settings.license.config.add_license');
                 return '<a href="#/settings/add/license">' + name + '</a>';
            }

            function makeLicenseSupportLink() {
                var name = localizer.getString('fs.settings.license.config.licensing_portal');
                return '<a href='+ SUPPORT_LINK + '>' + name + '</a>';
            }

            function getActions(alertTypeId) {
                var actions = [];
                // iterate through the list of alertTypeIds that have actions
                // associated with them and create the action links
                $.each(alertTypeIds, function(i, id) {
                    if(alertTypeId === id.alertTypeId &&
                        session.canPerformAction(id.authCategory, id.authAction)) {
                        var link = id.link();
                        if (link) {
                            actions.push(link);
                        }
                    }
                });
                return actions;
            }

            function formatItem(notification, item) {
            	//should check if item is an alert or an indexResult object.
                alertFormatter.format(notification, item);
                notification.actions = getActions(item.alertTypeID, item.resourceUri);
            }

            this.register = function () {
                notificationFormatter.register({
                    category: 'alerts',
                    associatedResourceCategory: AUTH_CATEGORY,
                    index: true,
                    format: formatItem});
            };
        }

        return new LicenseAlertFormatter();
    }());

    return LicenseAlertFormatter;
});
