// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Localizer', 'hp/core/Router','hp/core/Banner','hp/model/Session' ],

    function(localizer, router, banner, session) { "use strict";

        var LicenseEulaView = (function() {

        var CLOSE_BUTTON = "#hp-eula-close-button";
        var APPLIANCE_NAME = "#hp-header-eula-writtenoffer";
        var EULA_IFRAME = "#iframe-eula-license-content";

        function LicenseEulaView () {

            function onCloseButtonClick() {
                var currentURI = session.getProperty("currentURI");
                session.setProperty("currentURI", null);
                router.go(currentURI, 'on Eula Agreement close');
            }

            function loadEulaContent() {
                var eulaContentFileByLanguage = localizer.getString('fs.settings.eula.config.content_directory') + "/" +
                localizer.getString('fs.settings.eula.config.eula_content_file');
                $(EULA_IFRAME).attr('src', eulaContentFileByLanguage);
            }

            this.resume = function () {
                loadEulaContent();
            };

            this.init = function() {
                loadEulaContent();
                $(APPLIANCE_NAME).text(banner.getApplicationTitle());
                $(CLOSE_BUTTON).click(function(ev) {
                    onCloseButtonClick();
                    ev.preventDefault();
                });
            };
        }
        return new LicenseEulaView();
    }());
    return LicenseEulaView;
});