// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {NetworkInterfaceTableView}
 */
define(['hp/core/Localizer',
    'hp/core/Style',
    'jquery',  
    'hp/lib/jquery.hpToggle',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpSelect'],
function (localizer, style) {
"use strict";

    var NetworkInterfaceTableView = (function () {
        
        /**
         * 
         * This View is used to create the multi Nic Data view using DataTable. Currently the HTML code is emmebedded in the 
         * the view as the ID AND NAME attribites has to be created dynamically .THIS NEEDS TO BE MOVED IN TO A SEPERATE HTML
         * LATER  
         * 
         */
        /**
         * 
         * @returns {NetworkInterfaceTableView}
         */
        function NetworkInterfaceTableView() {

            var presenter = null;
            var base = null;
            var table = null;
            var dataTable = null;
            var sortColumnNames = [];
            var resource = null;
            var multiSelect = false;
            var primaryNetworkObj = null;
            var DHCP_IPV6_DISALLOWED = '#cic-network-DHCP-ipv6-disallowed',
                CLASS_IPV6_DISABLE = '.cic-fsnetwork-ipv6-remove';
            
            
            var aliasNICMacAddress = null;
            
            var AUTOGENERATED_PREFIX='ci-';

            var FQDN = 'fqdn', 
                IPV4 = 'ipv4', 
                IPV6 = 'ipv6', 
                MASKV4 = 'maskv4', 
                MASKV6 = 'maskv6',
                HIDDEN = "-hidden",
                ADD = 'add', 
                REMOVE = 'remove',
                REQUIRED = 'required';

        // name of setting for nic alias association
        var NIC_ALIAS_ASSOCIATION_SETTING_NAME = 'nic-associated-with-alias';
        var networkInterfaceTableView = this;
        var allNICs = [];
            
        var HOSTNAME = '#cic-network-hostname';
    
        var nicUsageEditable = null,
            aliasSupported = false,
            dhcpDisabled = false,
            ipv6Disabled = false,
            multiNICSameSubnetValidationDisabled = false,
            editDnsForAdditionalNICsDisabled = false,
            editGatewayForAdditionalNICsDisabled = false,
            generateCertificateForEachNicDisabled = false,
            applianceMoreView = false,
            FROM_DHCP = '-from-DHCP',
            UNAVAILABLE = 'hp-unavailable';
        var nicUsageLabels = [];
        // pulsar product config changes
        var disableNICConfigurationThroughUI = [],
            disableUpdateNICConfigurationThroughUI = [],
            disableUnconfigureNICThroughUI = [],
            rabbitmqEnabledNICs = [],
            userAllowedToChangeRabbitMQConf = false,
            importRabbitmqCertificateEnabled = false,
            postgresEnabledNICs = [],
            userAllowedToChangePostgresConf = false,
            importPostgresCertificateEnabled = false,
            importWebserverCertificateEnabled = false,
            webserverEnabledNICs = [],
            disableUnconfigureNICThroughREST  = [],
            disableUpdateNICConfigurationThroughREST = [],
            disableNICConfigurationThroughREST = [];

            function expandRow(row) {
                
            }

            function collapseRow(row) {
                if ($(ROW_COLLAPSER, row).hasClass(ACTIVE)) {
                    $(ROW_COLLAPSER, row).removeClass(ACTIVE);
                    row.removeClass(EXPANDED);
                    dataTable.fnClose(row[0]);
                }
            }

            function toggleExpansion(row) {
                if (row.hasClass(EXPANDED)) {
                    collapseRow(row);
                } else {
                    expandRow(row);
                }
            }

            // remove all selection classes
            function clearTableSelection() {
                $(dataTable.fnSettings().aoData).each(function (index, item) {
                    $(item.nTr).removeClass(SELECTED);
                });
            }


            
            function setIPV6Display() {
                if(presenter.iPv6Disabled()) {
                    $(CLASS_IPV6_DISABLE).remove();
                }
            }
            
            //Rule to validate usage field
            $.validator.addMethod(
                    'usageRegex',
                    function(value, element, regexp) {
                        var re = new RegExp(regexp);
                        return this.optional(element) || re.test(value);
                    },
                    localizer.getString('fs.settings.network.validator.usage')
            );
            
            function hostnameRule (index) {
                
                setTimeout(function() {
                    var dns1Id = "#cic-network-preferred-dns-"+index;
                    var dns2Id = "#cic-network-alternate-dns-"+index;

                    var hostNameId = HOSTNAME + "-" + index;
                    if((index != 200 && aliasSupported == true) || (aliasSupported == false)){
                        $(hostNameId).rules(REMOVE);
                        if($(dns1Id).val() || $(dns2Id).val()) {
                            var message = localizer.getString('fs.settings.network.validator.hostname.fqdn_required');
                            $(hostNameId).rules(ADD, {
                                readCert : [],
                                hostAddress : FQDN,
                                required : true,
                                messages : {
                                    hostAddress : message,
                                    required : message
                                }
                            });
                        } else {
                            $(hostNameId).rules(ADD, {
                                readCert : [],
                                hostAddress : ['hostname', FQDN],
                                messages : {
                                    hostAddress : localizer.getString('fs.settings.network.validator.hostname.fqdn_optional')
                                }
                            });
                        }
                    }
                },2000);
            }

            function addDNSIPV4AndV6Rules (index){
                if($("#cic-network-preferred-dns-" + index) .length > 0){
                    $("#cic-network-preferred-dns-" + index).rules("add", {
                        hostAddress : [IPV4, IPV6],
                        messages : {
                            hostAddress: localizer.getString('fs.settings.network.validator.dns.ipv4_ipv6') 
                        }
                    });
                }
                if($("#cic-network-alternate-dns-" + index) .length > 0){
                    $("#cic-network-alternate-dns-" + index).rules("add", {
                        hostAddress : [IPV4, IPV6],
                        messages : {
                            hostAddress: localizer.getString('fs.settings.network.validator.dns.ipv4_ipv6') 
                        }
                    });
                }
            }

            function addDNSIPV4Rules (index){
                if($("#cic-network-preferred-dns-" + index) .length > 0){
                    $("#cic-network-preferred-dns-" + index).rules("add", {
                        hostAddress : IPV4,
                        messages : {
                            hostAddress: localizer.getString('fs.settings.network.validator.dns.ipv4_only') 
                        }
                    });
                }
                if($("#cic-network-alternate-dns-" + index) .length > 0){
                    $("#cic-network-alternate-dns-" + index).rules("add", {
                        hostAddress : IPV4,
                        messages : {
                            hostAddress: localizer.getString('fs.settings.network.validator.dns.ipv4_only') 
                        }
                    });
                }
            }

             function addNICRules (index) {
                 hostnameRule (index);
                 var unassignipv6 = "#cic-network-ipv6-unassign-"+index; 

                 if($("#cic-network-ip-ipv4-" + index) .length > 0){
                  $("#cic-network-ip-ipv4-" + index).rules("add", {
                      hostAddress : IPV4,
                      messages : {
                          hostAddress: localizer.getString('fs.settings.network.validator.ipv4') 
                      }
                  });
                 }
                 if($("#cic-network-mask-ipv4-" + index) .length > 0){
                  $("#cic-network-mask-ipv4-" + index).rules("add", {
                      hostAddress : MASKV4,
                      messages : {
                          hostAddress: localizer.getString('fs.settings.network.validator.mask-ipv4') 
                      }
                  });
                 }
                 if($("#cic-network-gateway-ipv4-" + index) .length > 0){
                  $("#cic-network-gateway-ipv4-" + index).rules("add", {
                      hostAddress : IPV4,
                      messages : {
                          hostAddress: localizer.getString('fs.settings.network.validator.gateway-ipv4') 
                      }
                  });
                 }
                 setTimeout(function() {
                     if(ipv6Disabled || $(unassignipv6).is(':checked')){
                         addDNSIPV4Rules(index);
                     }
                     else{
                         addDNSIPV4AndV6Rules(index);
                     }
                 },2000);
                 if($("#cic-network-ip-ipv6-" + index) .length > 0){
                  $("#cic-network-ip-ipv6-" + index).rules("add", {
                      hostAddress : IPV6,
                      messages : {
                          hostAddress: localizer.getString('fs.settings.network.validator.ipv6') 
                      }
                  });
                 }
                  if($("#cic-network-mask-ipv6-" + index) .length > 0){
                  $("#cic-network-mask-ipv6-" + index).rules("add", {
                      hostAddress : MASKV6,
                      messages : {
                          hostAddress: localizer.getString('fs.settings.network.validator.mask-ipv6') 
                      }
                  });
                  }
                  if($("#cic-network-gateway-ipv6-" + index) .length > 0){
                  $("#cic-network-gateway-ipv6-" + index).rules("add", {
                      hostAddress : IPV6,
                      messages : {
                          hostAddress: localizer.getString('fs.settings.network.validator.gateway-ipv6') 
                      }
                  });
                  }
            } 
             
            /**
             * Based on the collapsed row index, assign row index
             * to expanded row
             */ 
            this.getTableRowIndex = function(index) {
             	
                var rowIndex = 0;
                switch (index) {
                    case 1:
                        rowIndex = 100;
                        break;
                    case 2:
                        rowIndex = 200;
                        break;
                    case 3:
                        rowIndex = 300;
                        break;
                    case 4:
                        rowIndex = 400;
                        break;
                    case 5:
                        rowIndex = 500;
                        break;
                    case 6:
                        rowIndex = 600;
                        break;
                    case 7:
                        rowIndex = 700;
                        break;
                    case 8:
                        rowIndex = 800;
                        break;
                }
                return rowIndex;
            };
            
            this.setAllNICs = function(nics){
                allNICs = nics;
            };
	    
            function resetErrors(cnt){
              $(".fs-manual-validator-errors-"+cnt+" label").remove('.hp-error'); 
              $(".fs-manual-validator-errors-"+cnt+" input").removeClass('.hp-error');
              $(".fs-manual-validator-errors-"+cnt).removeClass('hp-has-error');
            }

            function resetipv6Errors(cnt){
                $(".fs-manual-validator-IPV6-errors-"+cnt+" label").remove('.hp-error');
                $(".fs-manual-validator-IPV6-errors-"+cnt).removeClass('hp-has-error');
            }
             
             
            /**
             * @private
             * Called when a row is clicked on in the table
             * @param {Event} event The javascript click event
             */
            function onRowClick(event) {

                event.stopImmediatePropagation();

                var macAddress = $(this).find(".mac-address").html();
                var ipAddress = $(this).find(".ipAddress").html();
                var interfaceType = $(this).find(".interfaceType").html();
                var slNo = $(this).find(".sl-no").html();
                var collapserArrow = $(this).find(".hp-collapser");
                var aliasNICConfig = allNICs[1];
                if(macAddress != null)
                {

                    presenter.getSetting(NIC_ALIAS_ASSOCIATION_SETTING_NAME, {
                        success: function(setting) {
                            aliasNICMacAddress = setting.value;
                        }
                    });
                    var nicDevice = table.fnGetData(table.fnGetPosition( this )).device;


                    if (table.fnIsOpen(this)){
                        collapserArrow.removeClass("hp-active");
                        table.fnClose( this );
                    } else if((ipAddress === 'Unassigned' && (applianceMoreView))||((disableNICConfigurationThroughUI.indexOf(nicDevice)>= 0) || 
                        disableNICConfigurationThroughREST.indexOf(nicDevice)>= 0) )
                    {
                    	//eth0 we are not supporting for disableNICConfigurationThroughUI and disableNICConfigurationThroughREST
                        table.fnClose( this );
                    }else{
                        collapserArrow.addClass("hp-active");
                        var cnt = networkInterfaceTableView.getTableRowIndex(parseInt(slNo));

                        var eth1MacAddress = null;
                        var eth1AliasIPConfigured  = false;
                        var deviceEth0 = null;
                        
                        var aPos = table.fnGetPosition( this );           
                        // Get the data array for this row     
                        var aData = table.fnGetData( aPos ); 
                        deviceEth0 = aData.device;

                        if (aliasSupported){

                            eth1MacAddress = aData.aliasSupport;
                            if (eth1MacAddress != null && eth1MacAddress.indexOf("independentMacAddr")>=0){
                                eth1MacAddress = macAddress;
                            }
                            else if (eth1MacAddress != null && eth1MacAddress.indexOf("aliasMacAddr-")>=0){
                                //eth1 configured for alias

                                eth1AliasIPConfigured = true;
                                macAddress = eth1MacAddress.substr(eth1MacAddress.indexOf("-")+1);
                                eth1MacAddress = macAddress;
                            }
                            else if ( macAddress === ''){
                                //eth1 not configured for alias
                                macAddress = eth1MacAddress;

                            }
                        }
                        var ipv4Addr = primaryNetworkObj.app1Ipv4Addr;
                        if(ipv4Addr == null){
                            ipv4Addr = 'Unassigned';
                        }
                        
                        
                        var multinicservicepanel = ' <li class="hp-stacked-panel" id="fs-panel-services-'+cnt+'">'+
                        '<label data-localize="fs.settings.network.fields.services">'+localizer.getString("fs.settings.network.fields.services")+'</label>'+
                        '<fieldset>'+
                        '<ol>'+
                        '<li class="hp-form-item">'+
                        '<label></label>'+
                        '<div class="hp-form-content">'+
                        '<input id="fs-rabbitmq-listner-'+cnt+'" type="checkbox" name="rabbitmqlistner-'+cnt+'" class="fs-rabbitmq-listner-'+cnt+' disabled-'+cnt+'"/>'+
                        '<label for="fs-rabbitmq-listner-'+cnt+'" data-localize="fs.settings.network.fields.messaging" class="fs-rabbitmq-listner-'+cnt+'">'+localizer.getString("fs.settings.network.fields.messaging")+
                        '</label>'+
                        '<div class="hp-message-container">'+
                        '<label id="fs-rabbitmq-listner-warning-'+cnt+'" class="hp-help fs-rabbitmq-listner-'+cnt+'" data-localize="fs.settings.network.fields.rabbitmqlistner" for="fs-rabbitmq-listner-'+cnt+'" style="visibility: visible;">'+localizer.getString("fs.settings.network.fields.rabbitmqlistner")+
                        '</label>'+
                        '</div>'+
                        '</div>'+
                        '</li>'+
                        '<li class="hp-form-item">'+
                        '<label></label>'+
                        '<div class="hp-form-content">'+
                        '<input id="fs-postgresql-listner-'+cnt+'" type="checkbox" name="postgreslistner-'+cnt+'" class="fs-postgresql-listner-'+cnt+' disabled-'+cnt+'"/>'+
                        ' <label for="fs-postgresql-listner-'+cnt+'"  data-localize="fs.settings.network.fields.database" class="fs-postgresql-listner-'+cnt+'">'+localizer.getString("fs.settings.network.fields.database")+
                        '</label>'+
                        '<div class="hp-message-container">'+
                        '<label id="fs-postgresql-listner-warning-'+cnt+'" class="hp-help fs-postgresql-listner-'+cnt+'" data-localize="fs.settings.network.fields.postgresqllistner" for="fs-postgresql-listner-'+cnt+'" style="visibility: visible;">'+localizer.getString("fs.settings.network.fields.postgresqllistner")+
                        '</label>'+
                        '</div>'+
                        '</div>'+
                        '</li>'+
                        '</ol>'+
                        '</fieldset>'+
                        '</li>';
                         var multinicwebservicepanel = '<li class="hp-stacked-panel" id="fs-panel-webservercertificate-'+cnt+'">'+
                         '<label data-localize="fs.settings.network.fields.webservercertificates">'+localizer.getString("fs.settings.network.fields.webservercertificates")+'</label>'+
                         '<fieldset>'+
                         '<ol>'+
                         '<li>'+
                         '<div class="hp-section-warnings">'+
                          '<div class="hp-form-message-summary">'+
                           ' <h2 class="hp-form-message-text">Warning</h2>'+
                          '</div>'+
                          '<div class="hp-form-message-details">'+
                           ' <div class="hp-notification-details hp-sub-details">'+
                            '  <div class="hp-details">'+
                             '   <p data-localize="fs.settings.network.fields.restartwarn">'+localizer.getString("fs.settings.network.fields.restartwarn")+'</p>'+
                              '</div>'+
                            '</div>'+
                          '</div>'+
                        '</div>'+
                        '</li>'+
                         '<li class="fs-webserver-show">'+
                         '<div id="fs-webserver-servercertificate-section-'+cnt+'" class="hp-collapsible">'+
                         '<label data-localize="fs.settings.network.fields.certificate">'+localizer.getString("fs.settings.network.fields.certificate")+'</label>'+
                         '<ol>'+
                         
                         ' <li class="hp-form-item">'+
                         '   <div class="hp-form-content">'+
                         '     <textarea id="fs-webserver-cert-text-'+cnt+'" name="webServerCertificate-'+cnt+'" class="hp-form-content readonly-'+cnt+'"'+
                         '      rows="6"'+
                         '      cols="40"></textarea>'+
                         '     <div class="hp-message-container"><label for="fs-webserver-cert-text-'+cnt+'" id="fs-webserver-cert-text-label-comma-list-explain-'+cnt+'"  class="hp-help" data-localize="fs.settings.network.fields.compliantcert">'+localizer.getString("fs.settings.network.fields.compliantcert")+'</label>'+
                         '</div>'+
                         '   </div>'+
                         '</li>'+
                         '</ol>'+
                         '</div>'+
                         '<div id="fs-webserver-cacertificate-section-'+cnt+'" class="hp-collapsible">'+
                         '<label data-localize="fs.settings.network.fields.certificatechain">'+localizer.getString("fs.settings.network.fields.certificatechain")+'</label>'+
                         '<ol> '+
                         ' <li class="hp-form-item">'+
                         '   <div class="hp-form-content">'+
                         '     <textarea id="fs-webserver-certchain-text-'+cnt+'" name="webServerCertificateChain-'+cnt+'" class="hp-form-content readonly-'+cnt+'"'+
                         '       rows="6"'+
                         '      cols="40"></textarea>'+
                         '     <div class="hp-message-container"><label for="fs-webserver-certchain-text-'+cnt+'" id="fs-webserver-certchain-text-label-comma-list-explain-'+cnt+'"  class="hp-help" data-localize="fs.settings.network.fields.compliantcert">'+localizer.getString("fs.settings.network.fields.compliantcert")+'</label>'+
                         '</div>'+
                         '   </div>'+
                         ' </li>'+
                         '</ol>'+
                         '</div>'+
                         '<div id="fs-webserver-privatekey-section-'+cnt+'" class="hp-collapsible">'+
                         '<label data-localize="fs.settings.network.fields.privatekey">'+localizer.getString("fs.settings.network.fields.privatekey")+'</label>'+
                         '<ol> '+
                         '<li class="hp-form-item">'+
                         '   <div class="hp-form-content">'+
                         '<textarea id="fs-webserver-privatekey-text-'+cnt+'" name="webServerCertificateKey-'+cnt+'" class="hp-form-content readonly-'+cnt+'"'+
                         ' rows="6"'+
                         'cols="40"></textarea>'+
                         '<div class="hp-message-container">'+
                         '<label for="fs-webserver-privatekey-text-'+cnt+'" id="fs-webserver-privatekey-text-label-comma-list-explain-'+cnt+'" '+
                         ' class="hp-help" data-localize="fs.settings.network.fields.privatekeywarn">'+localizer.getString("fs.settings.network.fields.privatekeywarn")+'</label></div>'+
                         '</div>'+
                         '</li>'+
                         ' </ol>'+
                         '</div>'+
                         '</li>'+
                         '</ol>'+
                         '</fieldset>'+
                         '</li>';


                        var usageText = '<select id="cic-network-usage-'+cnt+'" size="45" />';
                        var hostnameText = '<input id="cic-network-hostname-'+cnt+'" name="nic-hostname-'+cnt+'" size="45" class="cic-network-hostname readonly-'+cnt+'"/>';
                        var ipv4Assignment = 
                            '<label for="cic-network-ipv4-'+cnt+'"'+
                            'data-localize="fs.settings.network.fields.addrselector.full">'+localizer.getString("fs.settings.network.fields.addrselector.full")+'</label>'+
                            '<div class="hp-form-content">'+
                            '<input type="radio" id="cic-network-ipv4-unassign-'+cnt+'" name="addressAssignment-'+cnt+'" value="UNCONFIGURE" class="disabled-'+cnt+'"/>'+
                            '<label for="cic-network-ipv4-unassign-'+cnt+'" data-localize="fs.settings.network.iptype.unassign">'+localizer.getString("fs.settings.network.iptype.unassign")+'</label>'+
                            '<input type="radio" id="cic-network-ipv4-static-'+cnt+'" name="addressAssignment-'+cnt+'" value="STATIC" class="disabled-'+cnt+'"/>'+
                            '<label for="cic-network-ipv4-static-'+cnt+'" data-localize="fs.settings.network.iptype.manual">'+localizer.getString("fs.settings.network.iptype.manual")+'</label>'+
                            '<input type="radio" id="cic-network-ipv4-dhcp-'+cnt+'" name="addressAssignment-'+cnt+'" value="DHCP" class="disabled-'+cnt+'"/>'+
                            '<label for="cic-network-ipv4-dhcp-'+cnt+'" data-localize="fs.settings.network.iptype.dhcp">'+localizer.getString("fs.settings.network.iptype.dhcp")+'</label>'+
                            '<label for="cic-network-ipv4-'+cnt+'"   id="cic-network-DHCP-ipv4-warning-'+cnt+'" '+
                            ' class="hp-details-notify hp-details-notify-warning" data-localize="fs.settings.network.dhcpWarning"> '
                            +localizer.getString("fs.settings.network.dhcpWarning")+' </label> '+
                            '</div>';
                        var ipv4address = 
                            '<input id="cic-network-ip-ipv4-'+cnt+'" name="ip-ipv4-'+cnt+'" size="15" class="cic-network-ipv4-'+cnt+' readonly-'+cnt+'" />'+
                            '<input type="hidden" id="cic-network-ip-ipv4-'+cnt+'-hidden" />'+
                            '<div id="cic-network-ip-ipv4-errors-'+cnt+'" class="hp-message-container">'+
                            ' <label id="fs-network-IPv4-onenode-cluster-IP-DHCP-'+cnt+'" '+
                            'class="fs-network-IPv4-cluster-IP-DHCP-'+cnt+' hp-optional hp-has-help" '+
                            ' for="cic-network-ip-ipv4" style="visibility:hidden" '+
                            ' data-localize="fs.settings.appliance.fromDHCP">'+localizer.getString("fs.settings.appliance.fromDHCP")+'</label>'+
                            ' <label id="cic-ip-selfsigned-label-comma-list-explain-'+cnt+ '" class="hp-help ipv4-non-DHCP-errors-'+cnt+'" data-localize="fs.settings.certificate.ipaddress_regen_cert_warn"> '
                            +localizer.getString("fs.settings.certificate.ipaddress_regen_cert_warn")+' </label> '+
                            '</div>';
                        var ipv4subnet = '<input id="cic-network-mask-ipv4-'+cnt+'" name="mask-ipv4-'+cnt+'" size="15" class="cic-network-ipv4-'+cnt+' readonly-'+cnt+'" />';
                        var ipv4gayway = '<input id="cic-network-gateway-ipv4-'+cnt+'" name="gateway-ipv4-'+cnt+'" size="15" class="cic-network-ipv4-'+cnt+' readonly-'+cnt+'" />';
                        var prefferedDns = '<input id="cic-network-preferred-dns-'+cnt+'" name="dns1-'+cnt+'" class="cic-network-dns cic-network-affects-layout readonly-'+cnt+'" size="45" />';
                        var alternateDns = '<input id="cic-network-alternate-dns-'+cnt+'" name="dns2-'+cnt+'" class="cic-network-dns cic-network-affects-layout readonly-'+cnt+'" size="45" />';
                        var ipv6assignment = 
                            '<label for="cic-network-ipv6-selector-'+cnt+'"  class="cic-network-ipv6"'+
                            ' data-localize="fs.settings.network.fields.addrselector.full">'+localizer.getString("fs.settings.network.fields.addrselector.full")+'</label>'+
                            '<div class="hp-form-content">'+
                            '<input type="radio" id="cic-network-ipv6-unassign-'+cnt+'" name="addressAssignmentforv6-'+cnt+'" value="UNCONFIGURE" class="disabled-'+cnt+'"/>'+
                            '<label for="cic-network-ipv6-unassign-'+cnt+'" data-localize="fs.settings.network.iptype.unassign">'+localizer.getString("fs.settings.network.iptype.unassign")+'</label>'+
                            '<input type="radio" id="cic-network-ipv6-static-'+cnt+'" name="addressAssignmentforv6-'+cnt+'" value="STATIC" class="disabled-'+cnt+'"/>'+
                            '<label for="cic-network-ipv6-static-'+cnt+'" data-localize="fs.settings.network.iptype.manual">'+localizer.getString("fs.settings.network.iptype.manual")+'</label>'+
                            '<input type="radio" id="cic-network-ipv6-dhcp-'+cnt+'" name="addressAssignmentforv6-'+cnt+'" value="DHCP" class="disabled-'+cnt+'"/>'+
                            '<label for="cic-network-ipv6-dhcp-'+cnt+'" data-localize="fs.settings.network.iptype.dhcpv6">'+localizer.getString("fs.settings.network.iptype.dhcpv6")+'</label>'+
                            '<label for="cic-network-ipv6-'+cnt+'" id="cic-network-DHCP-ipv6-warning-'+cnt+'" '+
                            ' class="hp-details-notify hp-details-notify-warning" data-localize="fs.settings.network.dhcpWarning">'
                            +localizer.getString("fs.settings.network.dhcpWarning")+' </label>'+
                            '<label for="cic-network-ipv6-'+cnt+'" id="cic-network-dualstack-warning-'+cnt+'" '+
                            ' class="hp-details-notify hp-details-notify-warning" data-localize="fs.settings.network.dualStackWarning">'
                            +localizer.getString("fs.settings.network.dualStackWarning")+' </label>'+
                            '</div>';
                        var ipv6address = 
                            '<input id="cic-network-ip-ipv6-'+cnt+'" name="ip-ipv6-'+cnt+'" size="40" class="cic-network-ipv6 cic-nonDHCP-ipv6 cic-ipv6-fields readonly-'+cnt+'" />'+
                            ' <input type="hidden" id="cic-network-ip-ipv6-'+cnt+'-hidden"/>'+
                            '<div  id="cic-network-ip-ipv6-errors-'+cnt+'"'+
                            ' class="hp-message-container cic-network-ipv6">'+
                            '<label class="hp-optional fs-network-IPv6-cluster-IP-DHCP-'+cnt+' hp-has-help" for="cic-network-ip-ipv6-'+cnt+'" '+ 
                            'id="fs-network-IPv6-onenode-cluster-IP-DHCP-'+cnt+'" style="visibility:hidden"'+
                            'data-localize="fs.settings.appliance.fromDHCP">'+localizer.getString("fs.settings.appliance.fromDHCP")+
                            '</label>'+
                            ' <label id="cic-ip-selfsigned-label-comma-list-explain-'+cnt+ '" class="hp-help ipv6-non-DHCP-errors-'+cnt+'" data-localize="fs.settings.certificate.ipaddress_regen_cert_warn"> '
                            +localizer.getString("fs.settings.certificate.ipaddress_regen_cert_warn")+' </label> '+
                            '</div>';
                        var ipv6mask = '<input id="cic-network-mask-ipv6-'+cnt+'" name="mask-ipv6-'+cnt+'" size="40" class="cic-network-ipv6 cic-nonDHCP-ipv6 cic-ipv6-fields readonly-'+cnt+'" />';
                        var ipv6gateway = '<input id="cic-network-gateway-ipv6-'+cnt+'" name="gateway-ipv6-'+cnt+'" size="40" class="cic-network-ipv6 cic-nonDHCP-ipv6 cic-ipv6-fields readonly-'+cnt+'" />';

                        var warningLabel = '<label class="hp-details-notify hp-details-notify-warning" data-localize="fs.settings.network.collapsibleWarning">'+localizer.getString("fs.settings.network.collapsibleWarning")+'</label>';
                        var deploymentIPWarningLabel = '<label class="hp-details-notify hp-details-notify-warning" data-localize="fs.settings.network.collapsibleWarning">'+localizer.getString("fs.settings.network.deploymentIPWarning")+'</label>';

                        if ((aliasSupported && aliasNICConfig != null && macAddress === aliasNICConfig.macAddress)){
                            warningLabel = warningLabel + deploymentIPWarningLabel;
                        }

                        var warningHtml =
                            '<fieldset>'+
                            '<ol>'+
                            '<li class="hp-form-item" >'+
                            '<label></label><label></label>'+
                            '<div class="hp-form-content">'+
                            warningLabel +
                            '</div>'+
                            '</li>'+
                            '</ol>'+
                            '</fieldset>'   ;

                        var ipv4typeHtml = '';
                        var ipv6typeHtml = '';
                        var independentStr = localizer.getString("fs.settings.network.fields.independent") + ' on ' + eth1MacAddress;;
                        var aliasStr = localizer.getString("fs.settings.network.fields.alias");
                        var aliasSection = 
                            '<input type="radio" id="cic-network-ipv4-independent-'+cnt+'" name="alias" value="INDEPENDENT" class="disabled-'+cnt+'"/>'+
                            '<label for="cic-network-ipv4-alias-independent-'+cnt+'" data-localize="fs.settings.network.fields.independent">'+independentStr+'</label><br/>'+
                            '<input type="radio" id="cic-network-ipv4-alias-'+cnt+'" name="alias" value="ALIAS" class="disabled-'+cnt+'"/>'+
                            '<label for="cic-network-ipv4-alias-'+cnt+'" data-localize="fs.settings.network.fields.alias">'+aliasStr+'</label>';
                       

                        var consolidateErrorHtml = 
                            '<div id="hp-form-section-errors-'+cnt+'" style="visibility:hidden">'+ 
                            '<div class="hp-form-message-summary">'+
                            '<h2 class="hp-form-message-text">'+localizer.getString("fs.settings.network.panel.errors") +'</h2>'+
                            '</div>'+
                            '<div class="hp-form-message-details" id="hp-form-errors-'+cnt+'">'+
                            '</div>'+
                            '</div>';
                              
                            
                        if(applianceMoreView) {
                            usageText = '<label id="cic-network-usage-'+cnt+'" name="nic-usage-'+cnt+'" size="45" class="cic-network-usage"/>';
                            hostnameText = '<label id="cic-network-hostname-'+cnt+'" name="nic-hostname-'+cnt+'" size="45" class="cic-network-hostname"/>';
                            ipv4Assignment = '';
                            ipv4address = '<label id="cic-network-ip-ipv4-'+cnt+'" name="ip-ipv4-'+cnt+'" size="45" class="cic-network-ipv4"/>';
                            ipv4subnet = '<label id="cic-network-mask-ipv4-'+cnt+'" name="mask-ipv4-'+cnt+'" size="15" class="cic-network-ipv4" />';
                            ipv4gayway = '<label id="cic-network-gateway-ipv4-'+cnt+'" name="gateway-ipv4-'+cnt+'" size="15" class="cic-network-ipv4" />';
                            prefferedDns = '<label id="cic-network-preferred-dns-'+cnt+'" name="dns1-'+cnt+'" class="cic-network-dns cic-network-affects-layout" size="45" />';
                            alternateDns = '<label id="cic-network-alternate-dns-'+cnt+'" name="dns2-'+cnt+'" class="cic-network-dns cic-network-affects-layout" size="45" />';
                            ipv6assignment = '';
                            ipv6address = '<label id="cic-network-ip-ipv6-'+cnt+'" name="ip-ipv6-'+cnt+'" size="40" class="cic-network-ipv6 cic-nonDHCP-ipv6 cic-ipv6-fields" />';
                            ipv6mask = '<label id="cic-network-mask-ipv6-'+cnt+'" name="mask-ipv6-'+cnt+'" size="40" class="cic-network-ipv6 cic-nonDHCP-ipv6 cic-ipv6-fields" />';
                            ipv6gateway = '<label id="cic-network-gateway-ipv6-'+cnt+'" name="gateway-ipv6-'+cnt+'" size="40" class="cic-network-ipv6 cic-nonDHCP-ipv6 cic-ipv6-fields" />';
                            warningHtml = '';
                            ipv4typeHtml = '<li  class="hp-form-item" ><label data-localize="fs.settings.network.panel.ipv4">'+localizer.getString("fs.settings.network.panel.ipv4")+'</label><div class="hp-form-content"><label class="fs-network-ipv4type" size="45" name="nic-ipv4type-'+cnt+'" id="fs-network-ipv4type-'+cnt+'"></label></div></li>';
                            ipv6typeHtml = '<li  class="hp-form-item" ><label for="cic-network-ipv6-switch-'+cnt+'" data-localize="fs.settings.network.fields.ipv6switch">'+localizer.getString("fs.settings.network.fields.ipv6switch")+'</label><div class="hp-form-content"><label class="fs-network-ipv6type" size="45" name="nic-ipv6type-'+cnt+'" id="fs-network-ipv6type-'+cnt+'"></label></div></li>';
                            multinicwebservicepanel = '';
                            multinicservicepanel = '';
                            if (eth1AliasIPConfigured){
                                aliasSection = '<label></label><label for="cic-network-ipv4-alias-'+cnt+'" data-localize="fs.settings.network.fields.alias">'+aliasStr+'</label>';
                            } else {
                                aliasSection = '';
                            }
                            consolidateErrorHtml = '';

                        }else if(interfaceType != 'Primary') {
                            if ((nicUsageEditable == null || !nicUsageEditable) || (aliasSupported))
                            {
                                // TODO for SK37 using SelectBox but need to followup with UI core team and make use of hpSearchCombo for Non Editable Combo and remove this ;
                                usageText = '<select id="cic-network-usage-'+cnt+'" class="hp-select"><option id="Deployment">Deployment</option><option id="Management">Management</option></select>';
                            }

                        }else if(interfaceType == 'Primary') {
                            usageText = '<input id="cic-network-usage-'+cnt+'" name="nic-usage-'+cnt+'" size="45" class="cic-network-usage readonly-'+cnt+'"/>';
                        }


                        var usageHtml =
                            '<li id="cic-network-usage-fieldset-'+cnt+'" class="">'+
                            '<fieldset>'+
                            '<ol>'+
                            '<li class="hp-form-item">'+
                            '<label for="cic-network-usage-'+cnt+'"'+
                            'data-localize="fs.settings.network.fields.usage">'+localizer.getString("fs.settings.network.fields.usage")+'</label>'+
                            '<div class="hp-form-content">'+usageText+
                            '<input type="hidden" id="cic-network-device-'+cnt+'" name="nic-device-'+cnt+'" size="45" class="cic-network-usage"/>'+
                            '<input type="hidden" id="cic-network-macaddress-'+cnt+'" name="nic-macaddress-'+cnt+'" value="'+macAddress+'" class="cic-network-usage"/>'+
                            '</div>'+
                            '</li>'+
                            '</ol>'+
                            '</fieldset>'+
                            '</li>';

                        var hostnameHtml = 
                            '<li id="cic-network-hostname-fieldset-'+cnt+'" class="hp-stacked-panel">'+
                            '<fieldset>'+
                            '<ol>'+
                            '<li class="hp-form-item">'+
                            '<label for="cic-network-hostname-'+cnt+'"'+
                            'data-localize="fs.settings.network.fields.hostname">'+localizer.getString("fs.settings.appliance.overview.hostname")+'</label>'+
                            '<div class="hp-form-content hp-has-help hp-wide">'+hostnameText+
                            '<div class="hp-message-container" >'+
                            ' <label id="cic-ip-selfsigned-label-comma-list-explain-'+cnt+ '" class="hp-help" data-localize="fs.settings.certificate.ipaddress_regen_cert_warn"> '
                            +localizer.getString("fs.settings.certificate.hostname_regen_cert_warn")+' </label> '+
                            '</div>'+
                            '</div>'+
                            '</li>'+
                            '</ol>'+
                            '</fieldset>'+
                            '</li>';

                        //var independentStr1 = localizer.getString("fs.settings.network.fields.independent") + ' on ' + eth1MacAddress;;

                        var aliasHtml = 
                            '<li id="cic-alias-fieldset-'+cnt+'" class="hp-stacked-panel" style="display:none">'+
                            '<fieldset>'+
                            '<ol>'+
                            '<li class="hp-form-item">'+
                            '<label for="cic-network-ipv4"'+
                            'data-localize="fs.settings.network.fields.addrselector.full">'+ "" +'</label>'+
                            '<div class="hp-form-content">'+aliasSection+
                            '</div>'+
                            '</li>'+
                            '</ol>'+
                            '</fieldset>'+
                            '</li>';

                        var ipv4AssignmentHtml =
                            '<li class="hp-stacked-panel">'+
                            '<label data-localize="fs.settings.network.panel.ipv4">'+localizer.getString("fs.settings.network.panel.ipv4")+'</label>'+//ipv4typeHtml+
                            '<fieldset>'+
                            '<ol>'+
                            '<li id="cic-network-address-assignment-fieldset-'+cnt+'" class="hp-form-item" cic-dhcp-allowed">'+ipv4Assignment+
                            '</li>';
                        var ipv4IPAddressHtml =

                            ipv4typeHtml+'<li id="cic-network-one-node-ipv4-fieldset-'+cnt+'" class="hp-form-item cic-one-node-layout" >'+
                            '<label for="cic-network-ip-ipv4-'+cnt+'" id="cic-network-ipv4-label-'+cnt+'" '+
                            ' data-localize="fs.settings.network.fields.ipaddr.short">'+localizer.getString("fs.settings.network.fields.ipaddr.short")+'</label>'+
                            '<div id="cic-network-ip-ipv4-errors-'+cnt+'" class="hp-form-content fs-manual-validator-errors-'+cnt+'">'+ipv4address+
                            '</div>'+
                            '</li> ';

                        var ipv4SubnetMaskHtml = 
                            '<li id="cic-network-subnetmask-ipv4-'+cnt+'" class="hp-form-item">'+
                            '<label for="cic-network-mask-ipv4-'+cnt+'" '+
                            ' data-localize="fs.settings.network.fields.subnet.full">'+localizer.getString("fs.settings.network.fields.subnet.full")+'</label> '+
                            '<div class="hp-form-content fs-manual-validator-errors-'+cnt+'">'+ipv4subnet+
                            '<input type="hidden" id="cic-network-mask-ipv4-'+cnt+'-hidden"  />'+
                            ' <label id="fs-network-IPv4-mask-DHCP-'+cnt+'" '+
                            'class="fs-network-IPv4-DHCP-'+cnt+' hp-optional"'+
                            ' for="cic-network-mask-ipv4" style="visibility:hidden"'+
                            ' data-localize="fs.settings.appliance.fromDHCP">'+localizer.getString("fs.settings.appliance.fromDHCP")+'</label>'+
                            '</div>'+
                            '</li>';

                        var ipv4GatewayHtml= 
                            '<li id="cic-network-gate-way-ipv4-'+cnt+'" class="hp-form-item">'+
                            '<label for="cic-network-gateway-ipv4-'+cnt+'"'+
                            ' data-localize="fs.settings.network.fields.gateway.full">'+localizer.getString("fs.settings.network.fields.gateway.full")+'</label>'+
                            '<div class="hp-form-content fs-manual-validator-errors-'+cnt+'">'+ipv4gayway+
                            '<input type="hidden" id="cic-network-gateway-ipv4-'+cnt+'-hidden"  />'+
                            '<div  id="cic-network-gateway-ipv4-errors-'+cnt+'" '+
                            'class="hp-message-container">'+
                            ' <label id="fs-network-IPv4-gateway-IP-DHCP-'+cnt+'" '+
                            ' class="fs-network-IPv4-DHCP-'+cnt+' hp-optional hp-has-help" '+
                            ' for="cic-network-gateway-ipv4" style="visibility:hidden" '+
                            ' data-localize="fs.settings.appliance.fromDHCP">'+localizer.getString("fs.settings.appliance.fromDHCP")+'</label> '+
                            ' <label for="cic-network-gateway-ipv4-'+cnt+'" id="cic-network-GATEWAY-ipv4-warning-'+cnt+'" '+
                            ' class="hp-help ipv4-non-DHCP-errors-'+cnt+'" data-localize="fs.settings.network.gatewayWarning">'+
                            localizer.getString("fs.settings.network.gatewayWarning")+
                            '</label>'+
                            '</div>'+
                            '</div>'+
                            '</ol>'+
                            '</fieldset>'+
                            '</li>';

                        var dnsFieldSetHtml=
                            '<li class="hp-stacked-panel" id="cic-fsnetwork-panel-dns-'+cnt+'">'+
                            '<label data-localize="fs.settings.network.panel.dns">'+localizer.getString("fs.settings.network.panel.dns")+'</label>'+
                            '<fieldset>'+
                            '<ol>'+
                            '<li class="hp-form-item">'+
                            '<label for="cic-network-preferred-dns-'+cnt+'" '+
                            ' data-localize="fs.settings.network.fields.dns1.full">'+localizer.getString("fs.settings.network.fields.dns1.full")+'</label>'+
                            ' <div class="hp-form-content fs-manual-validator-errors-'+cnt+'">'+prefferedDns+
                            ' <input type="hidden" id="cic-network-preferred-dns-'+cnt+'-hidden"  />'+
                            ' <label id="fs-network-IPv4-dns1-IP-DHCP-'+cnt+'" '+
                            ' class="fs-network-dns-DHCP hp-optional"'+
                            'for="cic-network-dns1" style="visibility:hidden"'+
                            ' data-localize="fs.settings.appliance.fromDHCP">'+localizer.getString("fs.settings.appliance.fromDHCP")+'</label>'+
                            '</div>'+
                            '</li>'+
                            '<li class="hp-form-item">'+
                            '<label for="cic-network-alternate-dns-'+cnt+'"'+
                            ' data-localize="fs.settings.network.fields.dns2.full">'+localizer.getString("fs.settings.network.fields.dns2.full")+'</label>'+
                            ' <div class="hp-form-content fs-manual-validator-errors-'+cnt+'">'+alternateDns+
                            '<input type="hidden" id="cic-network-alternate-dns-'+cnt+'-hidden"  />'+
                            '<label id="fs-network-IPv4-dns2-IP-DHCP-'+cnt+'"'+
                            ' class="fs-network-dns-DHCP hp-optional"'+
                            'for="cic-network-dns2" style="visibility:hidden"'+
                            ' data-localize="fs.settings.appliance.fromDHCP">'+localizer.getString("fs.settings.appliance.fromDHCP")+'</label>'+
                            '</div>'+
                            '</li>'+
                            '</ol>'+
                            '</fieldset>'+
                            '</li>';

                        var ipv6AssignmentHtml = 
                            '<li class="hp-stacked-panel cic-fsnetwork-ipv6-remove" id="cic-fsnetwork-panel-ipv6-'+cnt+'">'+
                            '<label for="cic-network-ipv6-switch-'+cnt+'" data-localize="fs.settings.network.fields.ipv6switch">'+localizer.getString("fs.settings.network.fields.ipv6switch")+'</label> '+//ipv6typeHtml+
                            '<fieldset>'+
                            '<div class="cic-network-ipv6 cic-dhcp-allowed" id="cic-network-address-assignment-fieldset-ipv6-'+cnt+'">'+
                            '<ol>'+
                            '<li class="hp-form-item" >'+ipv6assignment+
                            '</li>';

                        var  ipv6IPAddressHtml=  
                            ipv6typeHtml+'<li  id="cic-network-one-node-ipv6-fieldset-'+cnt+'" class="hp-form-item cic-one-node-layout cic-network-ipv6" >'+
                            '<label for="cic-network-ip-ipv6-'+cnt+'" id="cic-network-ipv6-label" class="cic-network-ipv6 cic-nonDHCP-ipv6"'+
                            ' data-localize="fs.settings.network.fields.ipaddr.one-node.full">'+localizer.getString("fs.settings.network.fields.ipaddr.one-node.full")+'</label>'+
                            ' <div class="hp-form-content  hp-wide fs-manual-validator-IPV6-errors-'+cnt+'">'+ipv6address+
                            '</div>'+
                            '</li>';

                        var ipv6SubnetHtml =  
                            '<li class="hp-form-item cic-network-ipv6" id="cic-network-ipv6-subnetmask-'+cnt+'">'+
                            '<label for="cic-network-mask-ipv6-'+cnt+'" class="cic-network-ipv6"'+
                            ' data-localize="fs.settings.network.fields.subnet.full">'+localizer.getString("fs.settings.network.fields.subnet.full")+'</label>'+
                            '<div class="hp-form-content hp-wide fs-manual-validator-IPV6-errors-'+cnt+'">'+ipv6mask+
                            '<input type="hidden" id="cic-network-mask-ipv6-'+cnt+'-hidden"  />'+
                            '<label id="fs-network-IPv6-subnet-IP-DHCP-'+cnt+'"'+
                            ' class="fs-network-IPv6-DHCP-'+cnt+' hp-optional" for="cic-network-mask-ipv6-'+cnt+'" style="visibility:hidden" '+
                            ' data-localize="fs.settings.appliance.fromDHCP">'+localizer.getString("fs.settings.appliance.fromDHCP")+'</label>'+
                            '</div>'+
                            ' </li> ';

                        var ipv6GatewayHtml  = 
                            ' <li class="hp-form-item" id="cic-network-ipv6-gateway-'+cnt+'"> '+
                            ' <label for="cic-network-gateway-ipv6-'+cnt+'" class="cic-network-ipv6" '+
                            ' data-localize="fs.settings.network.fields.gateway.full">'+localizer.getString("fs.settings.network.fields.gateway.full")+'</label>'+
                            ' <div class="hp-form-content hp-wide fs-manual-validator-IPV6-errors-'+cnt+'">'+ipv6gateway+
                            ' <input type="hidden" id="cic-network-gateway-ipv6-'+cnt+'-hidden"  />'+
                            ' <div id="cic-network-gateway-ipv6-errors-'+cnt+'"'+
                            ' class="hp-message-container cic-network-ipv6">'+
                            ' <label id="fs-network-IPv6-gateway-IP-DHCP-'+cnt+'"'+
                            ' class="fs-network-IPv6-DHCP-'+cnt+' hp-optional hp-has-help" for="cic-network-gateway-ipv6-'+cnt+'" style="visibility:hidden"'+
                            ' data-localize="fs.settings.appliance.fromDHCP">'+localizer.getString("fs.settings.appliance.fromDHCP")+'</label>'+
                            ' <label for="cic-network-gateway-ipv6-'+cnt+'" id="cic-network-GATEWAY-ipv6-warning-'+cnt+'" '+
                            ' class="hp-help ipv6-non-DHCP-errors-'+cnt+'" data-localize="fs.settings.network.gatewayWarning">'+
                            localizer.getString("fs.settings.network.gatewayWarning")+
                            '</label>'+
                            '</div>'+
                            '</div>'+
                            '</ol>'+
                            '</div>'+
                            '</fieldset>'+
                            '</li>';




                        var nicHtml =   
                            '<ol class="hp-stacked-panels" id="cic-appliance-network-panel">'+
                            '<li class="hp-stacked-panel" id="cic-fsnetwork-panel-ipv4-'+cnt+'">'
                            + consolidateErrorHtml
                            + warningHtml
                            + aliasHtml
                            + usageHtml
                            + hostnameHtml
                            +ipv4AssignmentHtml
                            +ipv4IPAddressHtml
                            +ipv4SubnetMaskHtml
                            +ipv4GatewayHtml
                            +dnsFieldSetHtml
                            +ipv6AssignmentHtml
                            +ipv6IPAddressHtml
                            +ipv6SubnetHtml
                            +ipv6GatewayHtml
                            +multinicservicepanel
                            +multinicwebservicepanel
                            + '</li></ol>';


                        var row = table.fnOpen( this, nicHtml, "hp-stacked-panel" );  
                        $(row).addClass('hp-stacked-panel');

                        setIPV6Display();

                        var usageId = "#cic-network-usage-"+cnt;
                        var usageInput = usageId + "-input";
                        var hostnameId = "#cic-network-hostname-"+cnt;
                        var staticIPAssignId = "#cic-network-ipv4-static-"+cnt;
                        var dhcpIPAssignId = "#cic-network-ipv4-dhcp-"+cnt;
                        var ipId = "#cic-network-ip-ipv4-"+cnt;
                        var maskId = "#cic-network-mask-ipv4-"+cnt;
                        var gatewayId = "#cic-network-gateway-ipv4-"+cnt;
                        var dns1Id = "#cic-network-preferred-dns-"+cnt;
                        var dns2Id = "#cic-network-alternate-dns-"+cnt;
                        var ipV6Id = "#cic-network-ip-ipv6-"+cnt;
                        var dhcpIPV6AssignId = "#cic-network-ipv6-dhcp-"+cnt;
                        var staticIPV6AssignId = "#cic-network-ipv6-static-"+cnt;
                        var maskV6Id = "#cic-network-mask-ipv6-"+cnt;
                        var gatewayV6Id = "#cic-network-gateway-ipv6-"+cnt;
                        var addressAssignment = "#cic-network-address-assignment-fieldset-"+cnt;
                        var addressipV6Assignment = "#cic-network-address-assignment-fieldset-ipv6-"+cnt;
                        var networkoneonenodeipv6 = "#cic-network-one-node-ipv6-fieldset-"+cnt;
                        var cicnetworkipv6 = "#cic-network-ipv6-subnetmask-"+cnt;
                        var gatewayipv6id = "#cic-network-ipv6-gateway-"+cnt;
                        var hostnamePanel = "#cic-network-hostname-fieldset-"+cnt;
                        var usagePanel = "#cic-network-usage-fieldset-"+cnt;
                        var aliasPanel = "#cic-alias-fieldset-"+cnt;
                        var independentRadio = "#cic-network-ipv4-independent-"+cnt;
                        var aliasRadio = "#cic-network-ipv4-alias-"+cnt;
                        var unassignipv4 = "#cic-network-ipv4-unassign-"+cnt;
                        var unassignipv6 = "#cic-network-ipv6-unassign-"+cnt;
                        var subnetmaskipv4id = "#cic-network-subnetmask-ipv4-"+cnt;
                        var gatewayipv4id = "#cic-network-gate-way-ipv4-"+cnt;
                        var networkoneonenodeipv4  = "#cic-network-one-node-ipv4-fieldset-"+cnt;
                        var PANEL_DNS = '#cic-fsnetwork-panel-dns-'+cnt;
                        var PANEL_IPV6 = '#cic-fsnetwork-panel-ipv6-'+cnt;
                        var dhcp_ipv6_disallowed = DHCP_IPV6_DISALLOWED  + "-" + cnt;
                        var dhcpIPAssignIdLabel = "cic-network-ipv4-dhcp-"+cnt;
                        var dhcpIPV6AssignIdLabel = "cic-network-ipv6-dhcp-"+cnt;
                        var ipV6dhcpmsg = "#fs-network-IPv6-onenode-cluster-IP-DHCP-"+cnt;
                        var ipV4dhcpmsg = "#fs-network-IPv4-onenode-cluster-IP-DHCP-"+cnt;
                        var ipV6networkswitch = "cic-network-ipv6-switch-"+cnt;
                        var ipV4maskdhcpmsg = "#fs-network-IPv4-mask-DHCP-"+cnt; 
                        var ipV4gatewaymsg = "#fs-network-IPv4-gateway-IP-DHCP-"+cnt;
                        var ipV6subnetdhcpmsg = "#fs-network-IPv6-subnet-IP-DHCP-"+cnt;
                        var ipV6gatewaydhcpmsg = "#fs-network-IPv6-gateway-IP-DHCP-"+cnt;
                        var dhcpIPv4Warning = '#cic-network-DHCP-ipv4-warning-'+cnt;
                        var dhcpIPv6Warning = '#cic-network-DHCP-ipv6-warning-'+cnt;
                        var dualStackWarning = '#cic-network-dualstack-warning-'+cnt;
                        var unassignipv4Label = "cic-network-ipv4-unassign-"+cnt;
                        var addressAssignmentLabel = "cic-network-address-assignment-fieldset-"+cnt;
                        var staticIPAssignIdLabel = "cic-network-ipv4-static-"+cnt;

                        var maskIPv4Panel = "#cic-network-subnetmask-ipv4-"+cnt;
                        var dnsIPv4Panel = "#cic-fsnetwork-panel-dns-"+cnt;
                        var dns1dhcpmsg = "#fs-network-IPv4-dns1-IP-DHCP-"+cnt;
                        var dns2dhcpmsg = "#fs-network-IPv4-dns2-IP-DHCP-"+cnt;

                        var CLASS_IPV4_NON_DHCP_ERRORS = ".ipv4-non-DHCP-errors-"+cnt;
                        var CLASS_IPV6_NON_DHCP_ERRORS = ".ipv6-non-DHCP-errors-"+cnt;
                        var validator = base.getValidator();
                        var ipv4type = "#fs-network-ipv4type-"+cnt;
                        var ipv6type = "#fs-network-ipv6type-"+cnt;
                        // added newly for pulsar requirements for cert changes
                        var WEBSERVER_SERVCERT_SECTION = '#fs-webserver-servercertificate-section-'+cnt,
                            WEBSERVER_CACERT_SECTION = '#fs-webserver-cacertificate-section-'+cnt,
                            WEBSERVER_PRIVATEKEY_SECTION = '#fs-webserver-privatekey-section-'+cnt,
                            webservicepanel = "#fs-panel-webservercertificate-"+cnt,
                            CLASS_RABBITMQ_LISTNER = ".fs-rabbitmq-listner-"+cnt,
                            CLASS_POSTGRESQL_LISTNER = ".fs-postgresql-listner-"+cnt,
                            servicespanel = "#fs-panel-services-"+cnt,
                            POSTGRES_LISTNER_WARN = "#fs-postgresql-listner-warning-"+cnt,
                            RABBITMQ_LISTENER_WARN = "#fs-rabbitmq-listner-warning-"+cnt,
                            WEBSERVER_CERTIFICATE_TEXT = "#fs-webserver-cert-text-"+cnt,
                            WEBSERVER_PRIVATEKEY_TEXT = "#fs-webserver-privatekey-text-"+cnt;
                        $(PANEL_DNS).hide();
                        if(ipAddress != 'Unassigned' && (!eth1AliasIPConfigured))
                        {
                            presenter.getSelectedNetworkConfiguration(macAddress, {

                                success: function(config) {

                                    var aliasNICConfig1 = allNICs[1];
                                    if(aliasSupported){
                                        var configuredAliasFlag = false;
                                        if(aliasNICMacAddress === null){
                                            if(macAddress === aliasNICConfig1.macAddress){
                                                configuredAliasFlag = true;
                                            }
                                            else {
                                                configuredAliasFlag = false;
                                            }
                                        }
                                        else {

                                            if(macAddress === aliasNICMacAddress){
                                                configuredAliasFlag = true;
                                            }
                                            else{
                                                configuredAliasFlag = false;
                                            }
                                        }
                                        if (configuredAliasFlag){
                                            if(applianceMoreView ){
                                                $(usagePanel).hide();
                                                $(hostnamePanel).hide();
                                                setField(ipId, config.app1Ipv4Addr);
                                                setField(maskId, config.ipv4Subnet);
                                                setField(ipv4type, localizer.getString('fs.settings.appliance.addrType.' + config.ipv4Type));
                                                $(PANEL_IPV6).hide();
                                                $(dnsIPv4Panel).hide();
                                                $(gatewayipv4id).hide();

                                            }else {
                                                $(aliasPanel).show();
                                                $(gatewayipv4id).hide();
                                                $(usagePanel).hide();
                                                $(hostnamePanel).hide();
                                                $(addressAssignment).hide();
                                                $(independentRadio).attr('checked',true);
                                                $(ipId).val(config.app1Ipv4Addr);
                                                $(maskId).val(config.ipv4Subnet);
                                                base.setAliasAssociatedNIC(config);
                                                $(PANEL_IPV6).hide();
                                                $(dnsIPv4Panel).hide();
                                            }
                                        }
                                        else {
                                            $(aliasPanel).hide();
                                            $(usagePanel).show();
                                            $(hostnamePanel).show();
                                            $(addressAssignment).show();
                                            base.fillFields(config, cnt);
                                            base.setAliasAssociatedNIC(null);
                                        }
                                    }
                                    else {
                                        base.fillFields(config, cnt);
                                    }


                                    if(config.device == 'eth0'){
                                        $('label[for="' + unassignipv4Label + '"]').hide();
                                        $(unassignipv4).hide();
                                        $(PANEL_DNS).show();
                                    }
                                    // TODO common code need to single call
                                    // product config view settings
                                    if(editGatewayForAdditionalNICsDisabled && deviceEth0 != 'eth0'){
                                        $(gatewayId).attr("disabled", true);  
                                        $(gatewayV6Id).attr("disabled", true);  
                                    }
                                    if(editDnsForAdditionalNICsDisabled && deviceEth0 != 'eth0'){
                                        $(dns1Id).attr("disabled", true);
                                        $(dns2Id).attr("disabled", true);
                                    }
                                    if(ipv6Disabled){
                                        $(PANEL_IPV6).hide();
                                    }
                                    if (aliasSupported)
                                    {
                                        if(config.device == 'eth0'){
                                            $(addressAssignment).hide();
                                            $(addressipV6Assignment).hide();
                                            $('label[for="' + ipV6networkswitch + '"]').hide();
                                        }
                                    }

                                    if(dhcpDisabled){
                                        $('label[for="' + dhcpIPAssignIdLabel + '"]').hide();
                                        $(dhcpIPAssignId).hide();
                                        $('label[for="' + dhcpIPV6AssignIdLabel + '"]').hide();
                                        $(dhcpIPV6AssignId).hide();
                                        $('label[for="' + addressAssignmentLabel + '"]').hide();
                                        if(config.device == 'eth0'){
                                            $('label[for="' + unassignipv4Label + '"]').hide();
                                            $(unassignipv4).hide();
                                            $('label[for="' + staticIPAssignIdLabel + '"]').hide();
                                            $(staticIPAssignId).hide();
                                            $(addressAssignment).hide();
                                            $(PANEL_DNS).show();
                                        }

                                        $(staticIPAssignId).attr('checked',true);


                                        if($(dhcpIPAssignId).is(':checked')) {
                                            $(staticIPAssignId).attr('checked',true);
                                            $(ipId).attr("disabled", false);  
                                            $(maskId).attr("disabled", false);
                                            $(gatewayId).attr("disabled", false); 
                                            $('label[for="' + dhcpIPAssignIdLabel + '"]').hide();
                                            $(dhcpIPAssignId).hide();
                                            $('label[for="' + dhcpIPV6AssignIdLabel + '"]').hide();
                                            $(dhcpIPV6AssignId).hide();
                                            $(ipV4dhcpmsg).css('visibility','hidden');
                                            $(ipV4maskdhcpmsg).css('visibility','hidden');
                                            $(ipV4gatewaymsg).css('visibility','hidden');
                                            $(ipV4dhcpmsg).removeClass('hp-has-help');
                                            $(ipV4gatewaymsg).removeClass('hp-has-help');
                                            $(ipV6dhcpmsg).css('visibility','hidden');
                                            $(ipV6subnetdhcpmsg).css('visibility','hidden');
                                            $(ipV6gatewaydhcpmsg).css('visibility','hidden');
                                            $(ipV6dhcpmsg).removeClass('hp-has-help');
                                            $(ipV6gatewaydhcpmsg).removeClass('hp-has-help');
                                        } 
                                        if ($(unassignipv4).is(':checked')){
                                            $(subnetmaskipv4id).hide();
                                            $(networkoneonenodeipv4).hide();
                                            $(gatewayipv4id).hide();
                                        }
                                        if($(unassignipv6).is(':checked')){
                                            $(cicnetworkipv6).hide();
                                            $(gatewayipv6id).hide();
                                            $(networkoneonenodeipv6).hide();
                                        }

                                        if(editGatewayForAdditionalNICsDisabled && deviceEth0 != 'eth0'){
                                            $(gatewayId).attr("disabled", true);
                                            $(gatewayV6Id).attr("disabled", true);
                                        } else {
                                            $(gatewayId).attr("disabled", false);
                                            $(gatewayV6Id).attr("disabled", false);
                                        }
                                        if(editDnsForAdditionalNICsDisabled && deviceEth0 != 'eth0'){
                                            $(dns1Id).attr("disabled", true);
                                            $(dns2Id).attr("disabled", true);
                                        } else {
                                            $(dns1Id).attr("disabled", false);
                                            $(dns2Id).attr("disabled", false);
                                        }
                                    }
                                }, // success of getSelectedNetworkConfiguration
                                error: base.onError
                            });                	

                        }
                        else {

                            var aliasNICConfig2 = allNICs[1];
                            if(primaryNetworkObj != null )
                            {
                                var aliasNICFlag = false;
                                if(aliasSupported){

                                    if(aliasNICMacAddress === null){
                                        if(macAddress === aliasNICConfig2.macAddress){
                                            aliasNICFlag = true;
                                        }
                                        else {
                                            aliasNICFlag = false;
                                        }
                                    }
                                    else {
                                        if(macAddress === aliasNICMacAddress){
                                            aliasNICFlag = true;
                                        }
                                        else{
                                            aliasNICFlag = false;
                                        }
                                    }
                                    if (applianceMoreView){
                                        setField(ipId, primaryNetworkObj.app1Ipv4Alias);
                                        setField(maskId, primaryNetworkObj.ipv4Subnet);
                                        setField(gatewayId, primaryNetworkObj.ipv4Gateway);
                                        setField(dns1Id, primaryNetworkObj.ipv4NameServers[0]);
                                        setField(dns2Id, primaryNetworkObj.ipv4NameServers[1]);
                                        setField(ipV6Id, primaryNetworkObj.app1Ipv6Addr);
                                        setField(maskV6Id, primaryNetworkObj.ipv6Subnet);
                                        setField(gatewayV6Id, primaryNetworkObj.ipv6Gateway);
                                        setField(ipv4type, localizer.getString('fs.settings.appliance.addrType.' + primaryNetworkObj.ipv4Type));
                                        setField(ipv6type, localizer.getString('fs.settings.appliance.addrType.' + primaryNetworkObj.ipv6Type));
                                    }else {
                                        $(ipId).val(primaryNetworkObj.app1Ipv4Alias);
                                        $(maskId).val(primaryNetworkObj.ipv4Subnet);
                                        $(gatewayId).val(primaryNetworkObj.ipv4Gateway);
                                        $(dns1Id).val(primaryNetworkObj.ipv4NameServers[0]);
                                        $(dns2Id).val(primaryNetworkObj.ipv4NameServers[1]);
                                        // IPV6 value settings
                                        $(ipV6Id).val(primaryNetworkObj.app1Ipv6Addr);
                                        $(maskV6Id).val(primaryNetworkObj.ipv6Subnet);
                                        $(gatewayV6Id).val(primaryNetworkObj.ipv6Gateway);
                                    }
                                    if(primaryNetworkObj.ipv6Type == presenter.STATIC){
                                        $(staticIPV6AssignId).attr('checked',true);
                                        $(dhcpIPv6Warning).hide();
                                        $(dualStackWarning).show();

                                        if(!applianceMoreView && $(ipV6Id).length > 0){
                                            $(ipV6Id).rules(ADD, REQUIRED);
                                        }
                                        if(!applianceMoreView && $(maskV6Id).length > 0){
                                            $(maskV6Id).rules(ADD, REQUIRED);
                                        }
                                    }
                                    else if(primaryNetworkObj.ipv6Type == presenter.DHCP){
                                        $(dhcpIPv6Warning).show();
                                        $(dualStackWarning).show();
                                        $(dhcpIPV6AssignId).attr('checked',true);
                                        $(ipV6Id).attr("disabled", true);  
                                        $(maskV6Id).attr("disabled", true);
                                        $(gatewayV6Id).attr("disabled", true);

                                        if(!applianceMoreView && $(ipV6Id).length > 0){
                                            $(ipV6Id).rules(REMOVE, REQUIRED);
                                        }
                                        if(!applianceMoreView && $(maskV6Id).length > 0){
                                            $(maskV6Id).rules(REMOVE, REQUIRED);
                                        }
                                    }else if(primaryNetworkObj.ipv6Type == presenter.UNCONFIGURE){
                                        $(unassignipv6).attr('checked',true);
                                        $(PANEL_IPV6).show();
                                        $(cicnetworkipv6).hide();
                                        $(gatewayipv6id).hide();
                                        $(networkoneonenodeipv6).hide();
                                        $(dhcpIPv6Warning).hide();
                                        $(dualStackWarning).hide();

                                        if(!applianceMoreView && $(ipV6Id).length > 0){
                                            $(ipV6Id).rules(REMOVE, REQUIRED);
                                        }
                                        if(!applianceMoreView && $(maskV6Id).length > 0){
                                            $(maskV6Id).rules(REMOVE, REQUIRED);
                                        }
                                    }

                                    if(primaryNetworkObj.app1Ipv4Alias != null && aliasNICFlag) {
                                        $(aliasPanel).show();
                                        $(gatewayipv4id).hide();
                                        $(usagePanel).hide();
                                        $(hostnamePanel).hide();
                                        $(addressAssignment).hide();
                                        $(aliasRadio).attr('checked',true);
                                        $(maskIPv4Panel).hide();
                                        $(dnsIPv4Panel).hide();
                                        $(PANEL_IPV6).hide();
                                    }
                                    else {
                                        if(aliasNICFlag){
                                            $(aliasPanel).show();
                                            $(gatewayipv4id).hide();
                                            $(usagePanel).hide();
                                            $(hostnamePanel).hide();
                                            $(addressAssignment).hide();
                                            $(aliasRadio).attr('checked',true);
                                            $(maskIPv4Panel).hide();
                                            $(dnsIPv4Panel).hide();
                                            $(PANEL_IPV6).hide();
                                        }
                                        else{
                                            $(ipId).val('');
                                            $(hostnameId).val(primaryNetworkObj.hostname); 
                                            $(staticIPAssignId).attr('checked',true);
                                            $(aliasPanel).hide();
                                            $(usagePanel).show();
                                            $(hostnamePanel).show();
                                            $(addressAssignment).show();
                                            $(gatewayipv4id).show();
                                        }

                                        if(!applianceMoreView && $(ipId).length > 0){
                                            $(ipId).rules(ADD, REQUIRED);
                                        }
                                        if(!applianceMoreView && $(maskId).length > 0){
                                            $(maskId).rules(ADD, REQUIRED);
                                        }                                              
                                    }

                                }else if (applianceMoreView){
                                    setField(hostnameId, getHostname(primaryNetworkObj));
                                    setField(ipId, null);
                                    setField(maskId, primaryNetworkObj.ipv4Subnet);
                                    setField(gatewayId, primaryNetworkObj.ipv4Gateway);
                                    setField(dns1Id, primaryNetworkObj.ipv4NameServers[0]);
                                    setField(dns2Id, primaryNetworkObj.ipv4NameServers[1]);
                                    setField(ipV6Id, null);
                                    setField(maskV6Id, primaryNetworkObj.ipv6Subnet);
                                    setField(gatewayV6Id, primaryNetworkObj.ipv6Gateway);
                                    setField(usageId, null);
                                    setField(ipv4type, localizer.getString('fs.settings.appliance.addrType.' + primaryNetworkObj.ipv4Type));
                                    setField(ipv6type, localizer.getString('fs.settings.appliance.addrType.' + primaryNetworkObj.ipv6Type));
                                } else {
                                    $(hostnameId).val(getHostname(primaryNetworkObj)); 
                                    $(staticIPAssignId).attr('checked',true);
                                    if(!applianceMoreView && $(maskId).length > 0){
                                        $(maskId).rules(ADD, REQUIRED);
                                    }
                                    if(!applianceMoreView && $(ipId).length > 0){
                                        $(ipId).rules(ADD, REQUIRED);
                                    } 
                                    $(dhcpIPv4Warning).hide();
                                    $(dns1dhcpmsg).css('visibility','hidden');
                                    $(dns2dhcpmsg).css('visibility','hidden');
                                    $(ipId).val('');
                                    $(maskId).val(primaryNetworkObj.ipv4Subnet);
                                    $(gatewayId).val(primaryNetworkObj.ipv4Gateway);
                                    $(dns1Id).val(primaryNetworkObj.ipv4NameServers[0]);
                                    $(dns2Id).val(primaryNetworkObj.ipv4NameServers[1]);
                                    // IPV6 settings
                                    if(primaryNetworkObj.ipv6Type == presenter.STATIC){
                                        $(staticIPV6AssignId).attr('checked',true);
                                        if(!applianceMoreView && $(ipV6Id).length > 0){
                                            $(ipV6Id).rules(ADD, REQUIRED);
                                        }
                                        if(!applianceMoreView && $(maskV6Id).length > 0){
                                            $(maskV6Id).rules(ADD, REQUIRED);
                                        }
                                        $(dhcpIPv6Warning).hide();
                                        $(dualStackWarning).show();
                                        $(ipV6dhcpmsg).css('visibility','hidden');
                                        $(ipV6subnetdhcpmsg).css('visibility','hidden');
                                        $(ipV6gatewaydhcpmsg).css('visibility','hidden');
                                        $(CLASS_IPV6_NON_DHCP_ERRORS).css('visibility','visible');  
                                    }else if(primaryNetworkObj.ipv6Type == presenter.DHCP){
                                        $(dhcpIPV6AssignId).attr('checked',true);
                                        $(ipV6Id).attr("disabled", true);  
                                        $(maskV6Id).attr("disabled", true);
                                        $(gatewayV6Id).attr("disabled", true); 
                                        $(dhcpIPv6Warning).show();
                                        $(dualStackWarning).show();
                                        if(!applianceMoreView && $(ipV6Id).length > 0){
                                            $(ipV6Id).rules(REMOVE, REQUIRED);
                                        }
                                        if(!applianceMoreView && $(maskV6Id).length > 0){
                                            $(maskV6Id).rules(REMOVE, REQUIRED);
                                        }
                                        $(ipV6dhcpmsg).css('visibility','visible');
                                        $(ipV6subnetdhcpmsg).css('visibility','visible');
                                        $(ipV6gatewaydhcpmsg).css('visibility','visible');
                                        $(CLASS_IPV6_NON_DHCP_ERRORS).css('visibility','hidden');  
                                    }else if(primaryNetworkObj.ipv6Type == presenter.UNCONFIGURE) 
                                    {
                                        $(unassignipv6).attr('checked',true);
                                        $(cicnetworkipv6).hide();
                                        $(gatewayipv6id).hide();
                                        $(networkoneonenodeipv6).hide();
                                        $(PANEL_IPV6).show();
                                        $(dhcpIPv6Warning).hide();
                                        $(dualStackWarning).hide();
                                        if(!applianceMoreView && $(ipV6Id).length > 0){
                                            $(ipV6Id).rules(REMOVE, REQUIRED);
                                        }
                                        if(!applianceMoreView && $(maskV6Id).length > 0){
                                            $(maskV6Id).rules(REMOVE, REQUIRED);
                                        }
                                    }
                                    $(ipV6Id).val('');
                                    $(maskV6Id).val(primaryNetworkObj.ipv6Subnet);
                                    $(gatewayV6Id).val(primaryNetworkObj.ipv6Gateway);

                                }
                                if (!applianceMoreView){
                                    if( deviceEth0 == 'eth0') {
                                        $(usageInput).hide();
                                        $(usageId).val(localizer.getString("fs.settings.network.fields.appliance"));
                                        $(usageId).attr("disabled", true); 
                                        $('label[for="' + unassignipv4Label + '"]').hide();
                                        $(unassignipv4).hide();
                                        $(PANEL_DNS).show();
                                        if(aliasSupported) {

                                            $(PANEL_IPV6).hide();
                                            $(addressAssignment).hide();
                                            $(addressipV6Assignment).hide();
                                            $('label[for="' + ipV6networkswitch + '"]').hide();

                                        }
                                    }else if (nicUsageEditable ){
                                        $(usageId).hpSearchCombo({results: nicUsageLabels, maxResults: nicUsageLabels.length});
                                        // Set the current Usage Labels to combo box.
                                        $(usageId).hpSearchCombo('set', {id: nicUsageLabels[0], name: nicUsageLabels[0]});
                                    } else {
                                        $(usageId).selectBox({autoWidth: false});
                                        $(usageInput).hide();
                                    }

                                    if(editGatewayForAdditionalNICsDisabled && deviceEth0 != 'eth0'){
                                        $(gatewayId).attr("disabled", true);  
                                        $(gatewayV6Id).attr("disabled", true);  
                                    }
                                    if(editDnsForAdditionalNICsDisabled && deviceEth0 != 'eth0'){
                                        $(dns1Id).attr("disabled", true);
                                        $(dns2Id).attr("disabled", true);
                                    }
                                    if(ipv6Disabled){
                                        $(PANEL_IPV6).hide();
                                    }

                                    if(dhcpDisabled){
                                        $('label[for="' + dhcpIPAssignIdLabel + '"]').hide();
                                        $(dhcpIPAssignId).hide();
                                        $('label[for="' + dhcpIPV6AssignIdLabel + '"]').hide();
                                        $(dhcpIPV6AssignId).hide();
                                        //TODO need to check this condtion
                                        $('label[for="' + addressAssignmentLabel + '"]').hide();
                                        if(deviceEth0 == 'eth0'){
                                            $('label[for="' + unassignipv4Label + '"]').hide();
                                            $(unassignipv4).hide();
                                            $(PANEL_DNS).show();
                                            $('label[for="' + staticIPAssignIdLabel + '"]').hide();
                                            $(staticIPAssignId).hide();
                                            $(addressAssignment).hide();
                                        }

                                        $(staticIPAssignId).attr('checked',true);


                                        if($(dhcpIPAssignId).is(':checked')) {
                                            $(staticIPAssignId).attr('checked',true);
                                            $(ipId).attr("disabled", false);  
                                            $(maskId).attr("disabled", false);
                                            $(gatewayId).attr("disabled", false); 
                                            $('label[for="' + dhcpIPAssignIdLabel + '"]').hide();
                                            $(dhcpIPAssignId).hide();
                                            $('label[for="' + dhcpIPV6AssignIdLabel + '"]').hide();
                                            $(dhcpIPV6AssignId).hide();
                                            $(ipV4dhcpmsg).css('visibility','hidden');
                                            $(ipV4maskdhcpmsg).css('visibility','hidden');
                                            $(ipV4gatewaymsg).css('visibility','hidden');
                                            $(ipV4dhcpmsg).removeClass('hp-has-help');
                                            $(ipV4gatewaymsg).removeClass('hp-has-help');
                                            $(ipV6dhcpmsg).css('visibility','hidden');
                                            $(ipV6subnetdhcpmsg).css('visibility','hidden');
                                            $(ipV6gatewaydhcpmsg).css('visibility','hidden');
                                            $(ipV6dhcpmsg).removeClass('hp-has-help');
                                            $(ipV6gatewaydhcpmsg).removeClass('hp-has-help');
                                        } 
                                        if ($(unassignipv4).is(':checked')){
                                            $(subnetmaskipv4id).hide();
                                            $(gatewayipv4id).hide();
                                            $(networkoneonenodeipv4).hide();
                                        }
                                        if($(unassignipv6).is(':checked')){
                                            $(cicnetworkipv6).hide();
                                            $(gatewayipv6id).hide();
                                            $(networkoneonenodeipv6).hide();
                                        }

                                        if(editGatewayForAdditionalNICsDisabled && deviceEth0 != 'eth0'){
                                            $(gatewayId).attr("disabled", true);
                                            $(gatewayV6Id).attr("disabled", true);
                                        } else {
                                            $(gatewayId).attr("disabled", false);
                                            $(gatewayV6Id).attr("disabled", false);
                                        }
                                        if(editDnsForAdditionalNICsDisabled && deviceEth0 != 'eth0'){
                                            $(dns1Id).attr("disabled", true);
                                            $(dns2Id).attr("disabled", true);
                                        } else {
                                            $(dns1Id).attr("disabled", false);
                                            $(dns2Id).attr("disabled", false);
                                        }
                                    } 
                                }
                            }
                        }
                        if (!applianceMoreView){
                            addNICRules(cnt);
                        }
                        
                        $(WEBSERVER_SERVCERT_SECTION).hpCollapsible();
                        $(WEBSERVER_CACERT_SECTION).hpCollapsible();
                        $(WEBSERVER_PRIVATEKEY_SECTION).hpCollapsible();
                        if(disableUnconfigureNICThroughUI.indexOf(nicDevice)>= 0) {
                             $('label[for="' + unassignipv4Label + '"]').hide();
                             $(unassignipv4).hide();
                        }
                        if(networkInterfaceTableView.getImportWebserverCertificateEnabled() === false) {
                            $(webservicepanel).hide();
                        }
                        if(networkInterfaceTableView.getUserAllowedToChangePostgresConf() === false) {
                            $(CLASS_POSTGRESQL_LISTNER).hide();
                            $(POSTGRES_LISTNER_WARN).hide();
                        }
                        if(networkInterfaceTableView.getUserAllowedToChangeRabbitMQConf() === false) {
                            $(CLASS_RABBITMQ_LISTNER).hide();
                            $(RABBITMQ_LISTENER_WARN).hide(); 
                        }
                        if(networkInterfaceTableView.getUserAllowedToChangePostgresConf() === false && networkInterfaceTableView.getUserAllowedToChangeRabbitMQConf() === false) {
                            $(servicespanel).hide();
                        }
                        $(WEBSERVER_PRIVATEKEY_SECTION).click(function() {
                            if (!$(WEBSERVER_PRIVATEKEY_SECTION).hasClass("hp-collapsed")){  
                                if($(WEBSERVER_CERTIFICATE_TEXT) .length > 0){
                                    $(WEBSERVER_CERTIFICATE_TEXT).rules(ADD, REQUIRED);
                                 }
                            } else{
                                if($(WEBSERVER_SERVCERT_SECTION).hasClass("hp-collapsed") && $(WEBSERVER_CACERT_SECTION).hasClass("hp-collapsed")) {
                                    $(WEBSERVER_CERTIFICATE_TEXT).rules(REMOVE, REQUIRED);
                                }
                            }
                            });
                       //required validation rules for web server certificate private key.
                        $(WEBSERVER_CACERT_SECTION).click(function() {
                            if (!$(WEBSERVER_CACERT_SECTION).hasClass("hp-collapsed")){
                                if($(WEBSERVER_CERTIFICATE_TEXT) .length > 0){
                                     $(WEBSERVER_CERTIFICATE_TEXT).rules(ADD, REQUIRED);
                                }
                            } else{
                                if($(WEBSERVER_SERVCERT_SECTION).hasClass("hp-collapsed") && $(WEBSERVER_PRIVATEKEY_SECTION).hasClass("hp-collapsed")) {
                                    $(WEBSERVER_CERTIFICATE_TEXT).rules(REMOVE, REQUIRED);
                                 }
                            }
                            });

                        $(WEBSERVER_SERVCERT_SECTION).click(function() {
                            if (!$(WEBSERVER_SERVCERT_SECTION).hasClass("hp-collapsed")){
                                if($(WEBSERVER_CERTIFICATE_TEXT) .length > 0){
                                     $(WEBSERVER_CERTIFICATE_TEXT).rules(ADD, REQUIRED);
                                }
                            } else{
                                if($(WEBSERVER_CACERT_SECTION).hasClass("hp-collapsed") && $(WEBSERVER_PRIVATEKEY_SECTION).hasClass("hp-collapsed")) {
                                    $(WEBSERVER_CERTIFICATE_TEXT).rules(REMOVE, REQUIRED);
                                }
                            }
                            });

                        $(aliasRadio).change(function(){
                            if($(aliasRadio).is(':checked')) {
                                $(aliasPanel).show();
                                $(ipId).attr("disabled", false);  
                                $(maskIPv4Panel).hide();
                                $(dnsIPv4Panel).hide();
                                $(gatewayipv4id).hide();

                            }
                        });

                        $(independentRadio).change(function(){
                            if($(independentRadio).is(':checked')) {
                                $(aliasPanel).show();
                                $(ipId).attr("disabled", false);  
                                $(maskIPv4Panel).show();
                                $(dnsIPv4Panel).hide();
                                $(gatewayipv4id).hide();
                            }
                        });

                        $(dns1Id).change(function(){
                            hostnameRule(cnt);
                        });
                        $(dns2Id).change(function(){
                            hostnameRule(cnt);
                        });

                    }

                    $(dhcpIPAssignId).change(function(){
                        if($(dhcpIPAssignId).is(':checked')) {
                            $(ipId + HIDDEN).val($(ipId).val());
                            $(maskId + HIDDEN).val($(maskId).val());
                            $(gatewayId + HIDDEN).val($(gatewayId).val());
                            $(dns1Id + HIDDEN).val($(dns1Id).val());
                            $(dns2Id + HIDDEN).val($(dns2Id).val());
                            $(subnetmaskipv4id).show();
                            $(gatewayipv4id).show();
                            $(networkoneonenodeipv4).show();
                            $(ipId).val('');
                            $(maskId).val('');
                            $(gatewayId).val('');
                            $(dns1Id).val('');
                            $(dns2Id).val('');
                            $(ipId).attr("disabled", true);  
                            $(maskId).attr("disabled", true);
                            $(gatewayId).attr("disabled", true);
                            $(ipV4dhcpmsg).css('visibility','visible');
                            $(ipV4maskdhcpmsg).css('visibility','visible');
                            $(ipV4gatewaymsg).css('visibility','visible');
                            $(dhcpIPv4Warning).show();
                            $(dns1dhcpmsg).css('visibility','visible');
                            $(dns2dhcpmsg).css('visibility','visible');
                            $(CLASS_IPV4_NON_DHCP_ERRORS).css('visibility', 'hidden');
                            $(ipId).rules(REMOVE, REQUIRED);
                            $(maskId).rules(REMOVE, REQUIRED);
                            $(ipV4dhcpmsg).removeClass('hp-has-help');
                            $(ipV4gatewaymsg).removeClass('hp-has-help');
                            validator.element(dns1Id);
                            validator.element(dns2Id);
                            resetErrors(cnt);



                        }
                    });
                    $(staticIPAssignId).change(function(){
                        if($(staticIPAssignId).is(':checked')) {
                            $(ipId).val($(ipId + HIDDEN).val());
                            $(maskId).val($(maskId + HIDDEN).val());
                            $(gatewayId).val($(gatewayId + HIDDEN).val());
                            $(dns1Id).val($(dns1Id + HIDDEN).val());
                            $(dns2Id).val($(dns2Id + HIDDEN).val());
                            $(subnetmaskipv4id).show();
                            $(gatewayipv4id).show();
                            $(networkoneonenodeipv4).show();
                            $(ipId).attr("disabled", false);  
                            $(maskId).attr("disabled", false);
                            $(gatewayId).attr("disabled", false);
                            $(ipV4dhcpmsg).css('visibility','hidden');
                            $(ipV4maskdhcpmsg).css('visibility','hidden'); 
                            $(ipV4gatewaymsg).css('visibility','hidden');
                            $(dhcpIPv4Warning).hide();
                            $(dns1dhcpmsg).css('visibility','hidden');
                            $(dns2dhcpmsg).css('visibility','hidden');
                            $(CLASS_IPV4_NON_DHCP_ERRORS).css('visibility','visible'); 
                            $(ipV4dhcpmsg).addClass('hp-has-help');
                            $(ipV4gatewaymsg).addClass('hp-has-help');
                            //added rules 
                            $(maskId).rules(ADD, REQUIRED);
                            $(ipId).rules(ADD, REQUIRED);
                            validator.element(ipId);
                            validator.element(gatewayId);
                            validator.element(maskId);
                            validator.element(dns1Id);
                            validator.element(dns2Id);

                            if(editGatewayForAdditionalNICsDisabled ){
                                $(gatewayId).attr("disabled", true);  
                            }
                            if(editDnsForAdditionalNICsDisabled ){
                                $(dns1Id).attr("disabled", true);
                                $(dns2Id).attr("disabled", true);
                            }
                        }
                    });
                    $(unassignipv4).change(function(){
                        if($(unassignipv4).is(':checked')){
                            $(subnetmaskipv4id).hide();
                            $(gatewayipv4id).hide();
                            $(networkoneonenodeipv4).hide();
                            $(PANEL_DNS).hide();
                            $(ipV4dhcpmsg).css('visibility','hidden');
                            $(ipV4maskdhcpmsg).css('visibility','hidden');
                            $(ipV4gatewaymsg).css('visibility','hidden');
                            $(dhcpIPv4Warning).hide();
                            if($(dhcpIPV6AssignId).is(':checked')) {
                                $(hostNameId).rules(REMOVE);
                            }
                            $(ipId).rules(REMOVE, REQUIRED);
                            $(maskId).rules(REMOVE, REQUIRED);

                        }
                    });

                    $(dhcpIPV6AssignId).change(function(){
                        if($(dhcpIPV6AssignId).is(':checked')) {
                            $(ipV6Id + HIDDEN).val($(ipV6Id).val());
                            $(maskV6Id + HIDDEN).val($(maskV6Id).val());
                            $(gatewayV6Id + HIDDEN).val($(gatewayV6Id).val());
                            $(cicnetworkipv6).show();
                            $(gatewayipv6id).show();
                            $(networkoneonenodeipv6).show();
                            $(dhcp_ipv6_disallowed).show();
                            $(ipV6Id).attr("disabled", true);  
                            $(maskV6Id).attr("disabled", true);
                            $(gatewayV6Id).attr("disabled", true);
                            $(ipV6Id).val(''); 
                            $(maskV6Id).val('');
                            $(gatewayV6Id).val('');
                            $(ipV6dhcpmsg).css('visibility','visible');
                            $(ipV6subnetdhcpmsg).css('visibility','visible');
                            $(ipV6gatewaydhcpmsg).css('visibility','visible');
                            $(dhcpIPv6Warning).show();
                            $(dualStackWarning).show();
                            $(CLASS_IPV6_NON_DHCP_ERRORS).css('visibility','hidden');
                            $(ipV6Id).rules(REMOVE, REQUIRED);
                            $(maskV6Id).rules(REMOVE, REQUIRED);
                            $(ipV6dhcpmsg).removeClass('hp-has-help');
                            $(ipV6gatewaydhcpmsg).removeClass('hp-has-help');
                            addDNSIPV4AndV6Rules(cnt);
                            resetipv6Errors(cnt);

                        }
                    });
                    $(staticIPV6AssignId).change(function(){
                        if($(staticIPV6AssignId).is(':checked')) {
                            $(ipV6Id).val($(ipV6Id + HIDDEN).val());
                            $(maskV6Id).val($(maskV6Id + HIDDEN).val());
                            $(gatewayV6Id).val($(gatewayV6Id + HIDDEN).val());
                            $(cicnetworkipv6).show();
                            $(gatewayipv6id).show();
                            $(networkoneonenodeipv6).show();
                            $(dhcp_ipv6_disallowed).show();
                            validator.element(ipV6Id);
                            validator.element(maskV6Id);
                            validator.element(gatewayV6Id);
                            $(ipV6Id).attr("disabled", false);  
                            $(maskV6Id).attr("disabled", false);
                            $(gatewayV6Id).attr("disabled", false);
                            $(ipV6dhcpmsg).css('visibility','hidden');
                            $(ipV6subnetdhcpmsg).css('visibility','hidden');
                            $(ipV6gatewaydhcpmsg).css('visibility','hidden');
                            $(ipV6dhcpmsg).addClass('hp-has-help');
                            $(ipV6gatewaydhcpmsg).addClass('hp-has-help');
                            $(dhcpIPv6Warning).hide();
                            $(dualStackWarning).show();
                            if(editGatewayForAdditionalNICsDisabled){
                                $(gatewayV6Id).attr("disabled", true);  
                            }
                            $(ipV6Id).rules(ADD, REQUIRED);
                            $(maskV6Id).rules(ADD, REQUIRED);
                            $(CLASS_IPV6_NON_DHCP_ERRORS).css('visibility','visible');
                            addDNSIPV4AndV6Rules(cnt);
                        }
                    });
                    $(unassignipv6).change(function(){
                        if($(unassignipv6).is(':checked')){
                            $(cicnetworkipv6).hide();
                            $(gatewayipv6id).hide();
                            $(networkoneonenodeipv6).hide();
                            $(dhcp_ipv6_disallowed).hide();
                            $(ipV6dhcpmsg).css('visibility','hidden');
                            $(ipV6subnetdhcpmsg).css('visibility','hidden');
                            $(ipV6gatewaydhcpmsg).css('visibility','hidden');
                            $(dhcpIPv6Warning).hide();
                            $(dualStackWarning).hide();
                            if($(unassignipv4).is(':checked')){
                                $(hostNameId).rules(REMOVE);
                            }
                            addDNSIPV4Rules(cnt);
                            $(ipV6Id).rules(REMOVE, REQUIRED);
                            $(maskV6Id).rules(REMOVE, REQUIRED);
                        }
                    });


                }

            }
            
            /**
             * returns the Hostname.
             * @param primaryNetworkObj
             * @returns
             */
            function getHostname(primaryNetworkObj){
                var hostnameValue = primaryNetworkObj.hostname;
                // check to see whether we have an intitial  non-FQDN hostname
                // and it is not autogenerated one, i.e. it does not start with "ci-"
                if (base.getFirstTime() && (hostnameValue.indexOf('.') == -1) && (hostnameValue.indexOf(AUTOGENERATED_PREFIX) != 0) &&
                    (primaryNetworkObj.domainName || primaryNetworkObj.searchDomains[0] ))  {
                  var suffix =  (primaryNetworkObj.domainName) ?  primaryNetworkObj.domainName : primaryNetworkObj.searchDomains[0] ;   
                  hostnameValue = hostnameValue + '.' + suffix;      
                }
                return hostnameValue;
            }
            /**
             * set the fileds.
             * @param field
             * @param value
             */
            function setField(field, value) {
            	// Show the contents of a field, with handling of "not set".
                if (value) {
                    $(field).text(value).removeClass(UNAVAILABLE);
                } else {
                    $(field).text(localizer.getString('core.common.notset')).removeClass(UNAVAILABLE);
                    $(field + FROM_DHCP).hide();
                }
            }



            /**
             * @private
             * Initialize the master table and attach event handlers from the presenter
             * @param {object} optionsArg Any options to pass to jQuery.datatables.
             */
            function networkInterfaceTableInit(optionsArg) {
              
                var options = {
                    "bPaginate" : false,
                    "bFilter" : false,
                    "bInfo" : false,
                    "bDeferRender": true,
                    "bAutoWidth": false,
                    "bSort": false,
                    "bDestroy": true,
                    "aaData" : resource
                };
                $.extend(options, optionsArg);
                

                // Initialize dataTable
                dataTable = table.dataTable(options);

                 $.map(options.aoColumns, 
                    function (col) {
                        return col.hasOwnProperty('bSortable') ? col.bSortable : true;
                    });

                // We do our own sorting, since we don't give datatables all
                // the data and we use the index service to sort.
                sortColumnNames = $.map(options.aoColumns, function (col) {
                    var match;
                    if (col.mDataProp) {
                        // strip leading "attributes.", if any
                        match = col.mDataProp.match(/^(multiA|a)ttributes\.(.*)/);
                        if (match) {
                            return match[2];
                        } else {
                            return col.mDataProp;
                        }
                    } else {
                        return ''; // if undefined, so be it
                    }
                });

                table.on('click', 'tbody tr', onRowClick);

            }

            /**
             * @public
             * Stop the timer polling of the index service.
             */
            this.pause = function () {
            };

            /**
             * @public
             * Resume the timer polling of the index service.
             */
            this.resume = function () {
            };

            this.setPrimaryNetworkObj = function(obj){
                primaryNetworkObj = obj;
            };
            
            this.setEditGatewayForAdditionalNICsDisabled = function(obj){
                editGatewayForAdditionalNICsDisabled = obj;
            };
            
            
            this.setEditDnsForAdditionalNICsDisabled = function(obj){
                editDnsForAdditionalNICsDisabled = obj;
            };
            
            this.setIpv6Disabled = function(obj){
                ipv6Disabled = obj;
            };
            this.getIpv6Disabled = function(){
                return ipv6Disabled;
            };
            this.setDhcpDisabled = function(obj){
                dhcpDisabled = obj;
            };
            
            
            this.setNicUsageEditable = function(obj){
                nicUsageEditable = obj;
            };
            this.getNicUsageEditable = function(){
                return nicUsageEditable;
            };
            this.setAliasSupported = function(obj){
                aliasSupported = obj;
            };
            
            this.setMultiNICSameSubnetValidationDisabled = function(obj){
                multiNICSameSubnetValidationDisabled = obj;
            } ;
            this.setGenerateCertificateForEachNicDisabled = function(obj){
                generateCertificateForEachNicDisabled = obj;
            };
            
            this.setNicUsageLabels = function(obj){
            	nicUsageLabels = obj;
            };
            this.getNicUsageLabels = function(){
            	return nicUsageLabels;
            };
            this.getAliasSupported = function(){
                return aliasSupported;
            };
            this.setApplianceMoreView = function(obj){
                applianceMoreView = obj ;
             };
             // pulsar product config variables
             this.getDisableNICConfigurationThroughUI = function(){
                 return disableNICConfigurationThroughUI;
             };
             this.getDisableUpdateNICConfigurationThroughUI = function(){
                 return disableUpdateNICConfigurationThroughUI;
             };
             this.getDisableUnconfigureNICThroughUI = function(){
                 return disableUnconfigureNICThroughUI;
             };
             this.getRabbitmqEnabledNICs = function(){
                 return rabbitmqEnabledNICs;
             };
             this.getUserAllowedToChangeRabbitMQConf = function(){
                 return userAllowedToChangeRabbitMQConf;
             };
             this.getImportRabbitmqCertificateEnabled = function(){
                 return importRabbitmqCertificateEnabled;
             };
             this.getPostgresEnabledNICs = function(){
                 return postgresEnabledNICs;
             };
             this.getUserAllowedToChangePostgresConf = function(){
                 return userAllowedToChangePostgresConf;
             };
             this.getImportPostgresCertificateEnabled = function(){
                 return importPostgresCertificateEnabled;
             };
             this.getImportWebserverCertificateEnabled = function(){
                 return importWebserverCertificateEnabled;
             };
             this.getWebserverEnabledNICs = function(){
                 return webserverEnabledNICs;
             };
            
             this.setDisableNICConfigurationThroughUI = function(obj){
                 disableNICConfigurationThroughUI = obj;
             };
             this.setDisableUpdateNICConfigurationThroughUI = function(obj){
                 disableUpdateNICConfigurationThroughUI = obj;
             };
             this.setDisableUnconfigureNICThroughUI = function(obj){
                 disableUnconfigureNICThroughUI = obj;
             };
             this.setRabbitmqEnabledNICs = function(obj){
                 rabbitmqEnabledNICs = obj;
             };
             this.setUserAllowedToChangeRabbitMQConf = function(obj){
                 userAllowedToChangeRabbitMQConf = obj;
             };
             this.setImportRabbitmqCertificateEnabled = function(obj){
                 importRabbitmqCertificateEnabled = obj;
             };
             this.setPostgresEnabledNICs = function(obj){
                postgresEnabledNICs = obj;
             };
             this.setUserAllowedToChangePostgresConf = function(obj){
                userAllowedToChangePostgresConf = obj;
             };
             this.setImportPostgresCertificateEnabled = function(obj){
                importPostgresCertificateEnabled = obj;
             };
             this.setImportWebserverCertificateEnabled = function(obj){
                 importWebserverCertificateEnabled = obj;
             };
             this.setWebserverEnabledNICs = function(obj){
                webserverEnabledNICs = obj;
             };
             this.setDisableUnconfigureNICThroughREST = function(obj){
                 disableUnconfigureNICThroughREST = obj;
             };
             this.getDisableUnconfigureNICThroughREST = function(){
                return disableUnconfigureNICThroughREST;
             };
             this.setDisableUpdateNICConfigurationThroughREST = function(obj){
                 disableUpdateNICConfigurationThroughREST = obj;
             };
             this.getDisableUpdateNICConfigurationThroughREST = function(){
                 return disableUpdateNICConfigurationThroughREST;
             };
             this.setDisableNICConfigurationThroughREST = function(obj){
                 disableNICConfigurationThroughREST = obj;
             };
             this.getDisableNICConfigurationThroughREST = function(){
                return disableNICConfigurationThroughREST;
             };
            
            /**
             * @public
             * Intialize the view.
             */
            this.init = function (presenterArg, baseArg, args) {
                presenter = presenterArg;
                base = baseArg;
                resource = args.resource;
                table = args.table;
                multiSelect = args.multiSelect;

                networkInterfaceTableInit(args.dataTableOptions);

            };
        }

        return NetworkInterfaceTableView;

    }());

    return NetworkInterfaceTableView;
});
