// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define([
    'hp/core/NotificationFormatter',
    'hp/core/StatusState',
    'hp/core/Localizer',
    'hp/services/Log'],
function(notificationFormatter, statusState, localizer, log) {"use strict";

    var RestoreAlertNotificationFormatter = ( function() {

        /**
         * @constructor
         * @type {RestoreAlertNotificationFormatter}
         */
        function RestoreAlertNotificationFormatter() {
        
            var alertFormatter = null;
        
            function formatAlert(notification, alert) {
                alertFormatter.formatAlert(notification, alert);
            }
        
            function formatIndex(notification, indexResult) {
                alertFormatter.formatIndex(notification, indexResult);
                notification.sourceName =
                    localizer.getString('fs.settings.backup.backupSourceName');
            }

            function format(notification, item) {
                if ('IndexResource' === item.type) {
                    formatIndex(notification, item);
                } else {
                    formatAlert(notification, item);
                }
            }

            this.register = function(alertNotificationFormatter) {
                alertFormatter = alertNotificationFormatter;
                notificationFormatter.register({
                    category: 'alerts',
                    associatedResourceCategory: 'restores',
                    index: true,
                    format: format});
            };

            this.formatAlert = formatAlert;

            this.formatIndex = formatIndex;
   
        }

        return new RestoreAlertNotificationFormatter();
    }());

    return RestoreAlertNotificationFormatter;
});
