// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hp/core/Notifications',
        'hp/core/Localizer'],
function(notifications, localizer) { "use strict";
    var UploadRestoreActivityView = ( function() {
        
        var NOTIFY_STATUS_ERROR = 'error';
        
        var localizedStrings = {
            uploadActivity : localizer.getString('fs.settings.restore.uploadActivity'),
            restoreActivity : localizer.getString('fs.settings.restore.restoreActivity')
        };
        
        var backupFileName;
            
        /**
         * Constructor
         */
        function UploadRestoreActivityView() {

////////////////////////////////////////////////////////////////////////////////
/// All ordered beyond this point to make SONAR happy                        ///
////////////////////////////////////////////////////////////////////////////////

            function captureFileName (info) {
                var nameVal;
                var data;
                var file;
                if (info) {
                    if (info.files && info.files[0]) {
                        file = info.files[0];
                    }
                    if (info.data) {
                        data = info.data;
                    } else {
                        data = info;
                    }
                    
                    // Look for name
                    
                    if (data.id) {
                        nameVal = data.id + '.bkp';
                    }
                    if (file && file.name) {
                        nameVal = file.name;
                    }
                    if (data.name) {
                        nameVal = data.name;
                    }
                }
                backupFileName = nameVal;
            }
            
            function reportErrorNotification(notification) {
                notifications.add(notification, true);
            }
            
            function reportUploadError (result) {
                var errorInfo = result.data;
                var note = {
                    summary    : localizedStrings.uploadActivity + backupFileName,
                    uri        : backupFileName,
                    status     : NOTIFY_STATUS_ERROR,
                    details    : errorInfo.errorMessage,
                    resolution : errorInfo.resolutionMessage
                };
                reportErrorNotification(note);
            }
            
            function reportValidationFailure (errorInfo) {
                var note = {
                    summary    : localizedStrings.uploadActivity + backupFileName,
                    uri        : backupFileName,
                    status     : NOTIFY_STATUS_ERROR,
                    details    : errorInfo.errorMessage,
                    resolution : errorInfo.resolutionMessage
                };
                reportErrorNotification(note);
            }
            function reportRestoreModeStartError (errorInfo) {
                var note = {
                    summary    : localizedStrings.restoreActivity + backupFileName,
                    uri        : backupFileName,
                    status     : NOTIFY_STATUS_ERROR,
                    details    : errorInfo.message,
                    resolution : errorInfo.resolution
                };
                reportErrorNotification(note);
            }
            
            this.getActivityEventHandlers = function () {
                var eventHandlers = {
                    stagedMode: captureFileName,
                    selectedStep: captureFileName,
                    uploadSuccess: captureFileName,
                    uploadError: reportUploadError,
                    validationFailure: reportValidationFailure,
                    restoreModeStartError: reportRestoreModeStartError
                };
                return eventHandlers;
            };
        }
        return new UploadRestoreActivityView();
    }());
return UploadRestoreActivityView;
});


