//(C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['jquery'],
function(jquery) { "use strict";

    var ViewCustomizer = ( function() {
        
        var targetView = null;
        /**
         * Constructor
         */
        function ViewCustomizer() {
            
            /**
             * @public
             * Inject a Partner Customization into the HTML Markup for this View.
             * @param {src} The text of an HTML page that contains the markup to be injected into this view.
             * @param {selector} The jQuery selector used to extract the new markup from src and to find the
             *      injection site within the current page.
             */
            this.customizeMarkup = function (src, selector) {
                var template = $(src);
                template = template.filter(selector);
                if (1 === template.length) {
                    var injection = template[0].innerHTML;
                    $(selector).html("");
                    $(selector).append(injection);
                    // needed??? reset();
                }
            };

            /**
             * @public
             * Inject a Partner Customization into the Behavior of this View.
             * @param {name} The name of a customizable set of behaviors.
             * @param {behaviors} A hash of name:function pairs that define the behaviors to be injected.
             */
            this.customizeBehavior = function (name, behaviors) {
                /*
                 * At this time, the only known use of this interface is in
                 * UploadTheRestoreView (formerly RestoreUploadView) to allow
                 * the Fusion program to inject an explicit confirmation with
                 * an "implications understood" checkbox in Sprint 37. This
                 * confirmation was added to the standard Atlas behavior in 
                 * Sprint 38.
                 * 
                 * Removing the interface would be a breaking change. Keeping it
                 * until it can be removed in an orderly fashion.
                 * 
                 * FYI, If it wasn't ignoring the call, it would be doing it wrong
                 * once this code is no longer part of the object being customized. So
                 * a re-think is needed in any event.
                 * 
                 * Such as use targetView.hasOwnProperty()
                 *
                if ('customizableConfirmation' === name) {
                    customizableConfirmation = behaviors;
                    reset();
                }
                 * 
                 * 
                 */
            };
            
            /**
             * @public
             * Register Partner Customizations on Target View
             * @param {parnerCustomizations} An array of customizations to the HTML markup or to JavaScript
             *      behaviors. Each customization injects itself via the customizeMarkup() or the 
             *      customizeBehavior() method. Markup customizations are limited to any element of the page
             *      that can be found via a jQuery selector. Behavior modifications are restricted to specifically
             *      defined calling points implemented in the code.
             */
            this.registerPartnerCustomizationsOnTargetView = function (view, parnerCustomizations) {
                var index, regCall;
                var customizations = parnerCustomizations.getCustomizations();
                targetView = view;
                for (index in customizations) {
                    if (customizations.hasOwnProperty(index)) {
                        regCall = customizations[index].registerCustomization;
                        if (regCall) {
                            regCall();
                        }
                    }
                }
                targetView = null;
            };
            
            /**
             * @public
             * Register Partner Customizations
             * 
             * DEPRECATED: At present, the only known use of this code is to
             *             inject Fusion specific content into the now obsolete
             *             RestoreUpdateView.
             *             
             * @param {parnerCustomizations} An array of customizations to the HTML markup or to JavaScript
             *      behaviors. Each customization injects itself via the customizeMarkup() or the 
             *      customizeBehavior() method. Markup customizations are limited to any element of the page
             *      that can be found via a jQuery selector. Behavior modifications are restricted to specifically
             *      defined calling points implemented in the code.
             */
            this.registerPartnerCustomizations = function (parnerCustomizations) {
                var index, regCall;
                var customizations = parnerCustomizations.getCustomizations();
                for (index in customizations) {
                    if (customizations.hasOwnProperty(index)) {
                        regCall = customizations[index].registerCustomization;
                        if (regCall) {
                            regCall();
                        }
                    }
                }
            };
        }
            
        return new ViewCustomizer();
    }());

    return ViewCustomizer;
});

