// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define([
    'fs/presenter/settings/PublicKeyPresenter',
    'hp/core/Router',
    'hp/core/Notifications',
    'hp/core/Localizer',
    'hp/core/UrlFragment',
    'hp/view/FormStateView',
    'fs/view/users/UsersViewUtil',
    'fs/presenter/settings/AuthNPresenter',
    'fs/presenter/settings/SettingsPresenter',
    'text!fsPages/settings/authentication/remove_confirm.html',
    'text!fsPages/settings/authentication/directoryupdate_confirm.html',
    'hp/model/Session',
    'hp/view/DialogView',
     'fs/model/settings/ProductConfig',
    'jquery',
    'lib/jquery.selectBox',
    'lib/jquery.validate',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpStackedPanels'],
function(presenter, router, notifications, Localizer,urlFragment, FormStateView, UsersViewUtil, authnPresenter,settingsPresenter, removeConfirmHtml,updateDirectoryHtml,session,DialogView,ProductConfig) { "use strict";

    var SecurityEditView = (function() {

        var validator;
        var DEFAULT_PROVIDER_SELECT = '#fs-settings-authn-edit-default-provider',
        LOCAL_LOGIN_CHECK = '#fs-settings-authn-edit-allow-local',
        DEFAULT_DIRECTORY_ERROR = "#fs-settings-authn-edit-default-provider-error",
        NO_DIRECTORIES = "#fs-settings-security-authn-no-directories",
        DIRECTORIES_TEMPLATE = "#security-authn-directories",
        DIRECTORIES_TABLE = '#security-directories-table',
        REMOVE_DIRECTORY_TITLE = '#fs-security-remove-directory-confirm-title',
        REMOVE_DIRECTORY_PROMPT_MESSAGE = '#fs-security-remove-directory-prompt',
        SECURITY_FIRMWAREBUNDLE_UPDATE_OPTION = "SECURITY_FIRMWAREBUNDLE_UPDATE_OPTION";

       /**
        * Constructor
        */
        function SecurityEditView() {

            var OK = '#hp-settings-edit-ok',
                CANCEL = '#hp-settings-edit-cancel',
                ROUTE_PREFIX = '/settings/edit/security',
                PANELS = '#hp-appliance-security-panel',
                PANEL_SELECTOR = '#hp-setting-security-panel-selector',
                FORM = '#hp-settings-security-form',
                KEY = '#hp-public-key',
                KEY_LOCATION = '#hp-security-key-location-msg',
                FW_BUTTONSET = '#firmwarebundle-update-options',
                FIRMWARE_BUNDLE_UPDATE_OPTION = 'input[name=firmwarebundle-update-options]:checked',
                FIRMWARE_BUNDLE_UPDATE_OPTION_HTTP = '#firmwarebundle-update-options-http',
                FIRMWARE_BUNDLE_UPDATE_OPTION_HTTPS = '#firmwarebundle-update-options-https',
                FIRMWARE_BUNDLE_DIV_HTTP = '#fs-settings-firmwarebundle-item-http',
                FIRMWARE_BUNDLE_DIV_HTTPS = '#fs-settings-firmwarebundle-item-https',
                FIRMWARE_BUNDLE_HELP_HTTP = '#fs-settings-firmwarebundle-helptext-http',
                FIRMWARE_BUNDLE_HELP_HTTPS = '#fs-settings-firmwarebundle-helptext-https',
                FIRMWARE_BUNDLE_DROPDOWN_LINK = '#hp-security-panel-firmwarebundle-link',
                FIRMWARE_BUNDLE_PANEL = '#hp-security-panel-firmwarebundle',
                APPLY_WARNING ='#fs-settings-default-directory-warning',
                APPLY_WARNING_MSG = '#fs-settings-default-directory-warning-msg';
            var cancelAfterApply = false;
            var allowLocalLoginDto = null;
            var defaultProvider = null;
            var formStateView = new FormStateView(),
                isSubmitted;
            var directoriesTable = null;
            var associations = [];
            var removeInProgress = false;
            var deleteDialog = null;
            var updateDirDialog = null ;
            var verifyPublicKey = false;
            var productConfigMembersData = null;
         function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                }
                else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }

            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(PANEL_SELECTOR, selection.uris);
                urlFragment.replaceHrefUris(CANCEL, selection.uris);
                $(PANELS).hpStackedPanels('setPanelByLocation',
                    '#' + router.location());
           }
            
            
            function setDefaultProviderDisplayValue() {
                if (defaultProvider !== null) {
                    $(DEFAULT_PROVIDER_SELECT).val(defaultProvider.loginDomain);
                    $("#fs-settings-authn-edit-default-provider-not-set").hide();
                    $(DEFAULT_PROVIDER_SELECT).selectBox('control').show();
                   
                }
                $(DEFAULT_PROVIDER_SELECT).selectBox('reset');
            }
      
             function getGlobalSettingsSuccess() {
 
                allowLocalLoginDto = authnPresenter.getAllowLocalLogin();

                if (allowLocalLoginDto !== null) {

                    $(LOCAL_LOGIN_CHECK).show();
                    $(LOCAL_LOGIN_CHECK).prop("checked", allowLocalLoginDto.allowLocalLogin);
                    if (session.getAuthService() === 'LOCAL') {
                        $(LOCAL_LOGIN_CHECK).attr("disabled", true);
                    }
                    if (allowLocalLoginDto.allowLocalLogin) {
                        if (session.getAuthService() !== "LOCAL") {
                            $("#fs-settings-authn-label-allow-local-explain").hide();
                        }
                        $(DEFAULT_PROVIDER_SELECT).append($("<option>", {value : "0"})
                                .text(Localizer.getString('login.LocalUser')));
                        $("#fs-settings-authn-edit-default-provider-not-set").hide();
                        try {
                            $(DEFAULT_PROVIDER_SELECT).selectBox('control').show();
                        } catch (error) {
                            // nothing
                        }
                    }
                }

                var providerInfos = authnPresenter.getProviderInfos();
                defaultProvider = authnPresenter.getDefaultProvider();
                if (providerInfos !== null && providerInfos.length > 0) {
                    $.each(providerInfos, function(index, providerInfo) {
                        $(DEFAULT_PROVIDER_SELECT).append($("<option>", {
                            value : providerInfo.loginDomain
                        }).text(providerInfo.name));
                    });
                }
                if (providerInfos !== null && providerInfos.length === 0) {
                     $(NO_DIRECTORIES).show();
                     $(DIRECTORIES_TEMPLATE).hide();
                     }else{
                    $(DIRECTORIES_TEMPLATE).show();
                    $(NO_DIRECTORIES).hide(); 
                    }
                setDefaultProviderDisplayValue();
            }
           function toggleLocalLoginCheckbox() {
                var exists = false;

                if ($(LOCAL_LOGIN_CHECK).is(':checked')) {
                    if ($(DEFAULT_PROVIDER_SELECT + ' option[value="0"]').text() ===
                        Localizer.getString('login.LocalUser')) {
                        exists = true;
                    }
                    if (!exists) {
                        $(DEFAULT_PROVIDER_SELECT).append(
                                $("<option>", {value : "0"}).text(Localizer.getString('login.LocalUser')));
                        $(DEFAULT_PROVIDER_SELECT).selectBox('reset');
                    }
                }
           }
           /**
            *  Reset the form
            */
           function reset() {
               $(DEFAULT_DIRECTORY_ERROR).text('');
               $(DEFAULT_DIRECTORY_ERROR).hide();
               $(KEY).val("");
               formStateView.reset();
               validator.resetForm();
               isSubmitted = false;
           }

           function settingsPage(){
               router.go('/settings');
           }
           function onDeleteDirSuccess(directoryName) {
               var alertMsg =  Localizer.getString('fs.settings.security.edit_authn.delete_title', [directoryName]);
               var notif = {
                       summary : alertMsg,
                       status : 'ok'
                   };
                   notifications.add(notif, true);
                   removeInProgress = false;
                   reset();
                   settingsPage();
               }

           function onDeleteDirError(error) {
                  formStateView.setMessage({
                   status : "error",
                   errorMessage : error
               });
               removeInProgress = false;
           }
           //validate the delete default directory
           function validateIfDefaultDirectory(directoryId,directoryName) {
               removeInProgress = false;
               if ($(DEFAULT_PROVIDER_SELECT).val() === directoryId) {
                   $(DEFAULT_DIRECTORY_ERROR).text(Localizer.getString('fs.settings.authn.edit.default_dir_delete_error'));
                   $(DEFAULT_DIRECTORY_ERROR).addClass('hp-error');
                   $(DEFAULT_DIRECTORY_ERROR).show();
                   return true;
               }else if(session.getAuthService() === directoryName ){
                   var errorMsg = Localizer.getString('fs.settings.authn.edit.delete_directory_errormessage');
                   formStateView.setMessage({
                       summary : errorMsg,
                       status : "error"
                      
                   });
                   return true;
               }else {
                   return false;
               }
           }
           //Delete the directory from server
           function onDeleteDirectory(event){
              
               if( !event.isPropagationStopped() && ! removeInProgress){
                   removeInProgress = true;
                   var contents = $(removeConfirmHtml);
                   Localizer.localizeDom(contents);
                   var row = $(this).parents('tr')[0];
                   var association = directoriesTable.fnGetData(row);
                   var directoryName = association.name;
                   var id = association.id;
                   var config = authnPresenter.getProviderConfigByIndex(id);
                   if( !validateIfDefaultDirectory(config.loginDomain,directoryName) ){
                      $(REMOVE_DIRECTORY_TITLE, contents).text(
                       Localizer.getString('fs.settings.security.edit_authn.delete_title', [directoryName]));
                   $(REMOVE_DIRECTORY_PROMPT_MESSAGE,contents).html(Localizer.getString('fs.settings.security.edit_authn.delete_message', [directoryName]));
                   deleteDialog = new DialogView({contents: contents,
                       ok: function () {
                                authnPresenter.deleteProviderConfig(config.uri, 
                                        {
                                    success : function() {
                                         onDeleteDirSuccess(directoryName);
                                    },
                                    error : function(error) {
                                         onDeleteDirError(error);
                                    }
                              });
                        },
                         cancel: function () {
                           removeInProgress = false;
                        }
                   });
                  
               }  
               }
             
             event.stopPropagation();
             event.preventDefault();
             
           }
           //Edit the directory 
           function onEditDirectory(event){
              if( !event.isPropagationStopped()){
               var row = $(this).parents('tr')[0];
               var association = directoriesTable.fnGetData(row);
               if(session.getAuthService() === association.name ){
                   var errorMsg = Localizer.getString('fs.settings.authn.edit.delete_directory_errormessage');
                   formStateView.setMessage({
                       summary : errorMsg,
                       status : "error"
                      
                   });
                   return true;
               }else {
               var id = association.id;
               var config = authnPresenter.getProviderConfigByIndex(id);
               if (config !== null){
               require(['fs/view/settings/authentication/AuthnEditDirectoryView'],
                       function (view) {view.initialize(event,config,defaultProvider);}
                   );
               }
               }
              }
               event.stopPropagation();
               event.preventDefault();
           }
            //Retrieve directories data from server success
            function getDirectoriesData(){
                var authConfigs = authnPresenter.getProviderConfigs();
                associations =[];
                for (var i=0; i<authConfigs.length; i+=1) {
                    associations.push({
                        id: i,
                        name: authConfigs[i].name
                    });
                }
             if(authConfigs !== null){
                directoriesTable = $(DIRECTORIES_TABLE).dataTable({
                    bPaginate : false,
                    bFilter : false,
                    bInfo : false,
                    sScrollY : 400,
                    sScrollX : 200,
                    sScrollXInner : "100%",
                    bScrollCollapse: true,
                    bDestroy : true,
                    bAutoWidth: false,
                    aaData: associations,
                    aoColumns : [{
                          sTitle : "id",
                          mDataProp : 'id',
                          bVisible : false},
                         {
                         sTitle : "Name",
                         mDataProp : 'name',
                         sWidth : 5 },
                         { fnRender : function(oObj) {
                                return '<div class="hp-edit"></div>';
                            },
                            sDefaultContent : '',
                            sClass : 'hp-icon',
                            sWidth : 5,
                            bSortable : false }, 
                         { fnRender : function(oObj) {
                                return '<div class="hp-close"></div>';
                            },
                            sDefaultContent : '',
                            sClass : 'hp-icon',
                            sWidth : 5,
                            bSortable : false
                        }
                    ]
                });
             }
             $(DIRECTORIES_TABLE).on('click', '.hp-close', onDeleteDirectory);
             $(DIRECTORIES_TABLE).on('click', '.hp-edit', onEditDirectory);
             }
        
            function validateForm() {
                var errorCount = 0;

                $(DEFAULT_DIRECTORY_ERROR).text('');
                $(DEFAULT_DIRECTORY_ERROR).hide();

                //check to see if user has not allowed local login and still has LOCAL selected
                //as default provider
                if (!$(LOCAL_LOGIN_CHECK).prop("checked") && $(DEFAULT_PROVIDER_SELECT).val() === '0') {
                    errorCount++;
                    $(DEFAULT_DIRECTORY_ERROR).text(Localizer.getString('fs.settings.authn.edit.default_dir_error'));
                    $(DEFAULT_DIRECTORY_ERROR).addClass('hp-error');
                    $(DEFAULT_DIRECTORY_ERROR).show();
                }
                if (errorCount > 0) {
                    return false;
                } else {
                    return true;
                }
            }
            function onApplySuccess() {
            
                var alertMsg = Localizer.getString('fs.settings.authn.edit.success');
                var notif = {
                        summary : alertMsg,
                        status : 'ok'
                    };
                    notifications.add(notif, true);
                  if (cancelAfterApply) {
                    $(CANCEL).trigger('click');
                }
              }
           function onApplyError(error) {
                   formStateView.setMessage({
                    summary : error.failureMessage,
                    status : "error",
                    errorMessage : error.errorInfo
                });
              }
            function apply(cancelOnSuccess) {
                cancelAfterApply = cancelOnSuccess;
                  if (validateForm()) {
                   authnPresenter.setAllowLocalLogin($(LOCAL_LOGIN_CHECK).prop("checked"));
                    authnPresenter.setDefaultProviderById($(DEFAULT_PROVIDER_SELECT).val());
                    if(productConfigMembersData['settings.security.ldap.settings.edit.confirmation'] === "true" &&
                            defaultProvider.loginDomain !== $(DEFAULT_PROVIDER_SELECT).val() && $(DEFAULT_PROVIDER_SELECT).val() !== '0' ){
                        var contentsDir = $(updateDirectoryHtml);
                        $("#fs-dir-update-confirm-title", contentsDir).text(Localizer.getString('fs.settings.authn.edit.default_dir_change_title'));
                        $("#fs-dir-update-confirm-msg", contentsDir).text(Localizer.getString('fs.settings.authn.edit.default_dir_change_common_msg'));
                        $("#fs-dir-update-confirm-msg1", contentsDir).text(Localizer.getString('fs.settings.authn.edit.default_dir_change_confirm_msg'));
                        updateDirDialog = new DialogView({contents: contentsDir,
                             ok: function () {
                                 authnPresenter.saveSettings({
                                     success : onApplySuccess,
                                     error : onApplyError
                                 });
                              },
                              cancel: function () {
                              }
                         });
                        }else {
                        authnPresenter.saveSettings({
                            success : onApplySuccess,
                            error : onApplyError
                        });
                    }
                    } else {
                    var error = {
                        "failureMessage" : Localizer.getString('fs.settings.authn.edit.save_failure'),
                        "errorInfo" : {
                            "errorMessage" : "",
                            "resolution" : Localizer.getString('fs.settings.authn.edit.failure_resolution')
                        }
                    };
                    onApplyError(error);
                }
            }
           

            function initForm() { 
                validator = $(FORM).validate();
                isSubmitted = false;
            }

            function onUpdatePublicKeyError(errorMessage) {
                var addMsg = Localizer.getString('fs.settings.security.panel.hp_public_key');
                formStateView.setMessage({summary: addMsg, status: 'error',
                    errorMessage: errorMessage});
                $(KEY).val("");
                isSubmitted = false;
            }


            function onUpdatePublicKeySuccess(data) {
                var publicKeyUpdated = {
                    summary : Localizer.getString('fs.settings.security.publickey.uploaded'),
                    status : "ok"
                };
                notifications.add(publicKeyUpdated, true, true, true);
                reset();
                settingsPage();
                verifyPublicKey = true;
            }

            function updatePublicKey(){
       
                if ($(FORM).valid() && isSubmitted === false) {
                    isSubmitted = true;
                    var publicKey= $(KEY).val();
                    presenter.updatePublicKey(publicKey);
                }
            }
            function onError(error) {
                formStateView.setMessage({
                    summary : error.failureMessage,
                    status : "error",
                    errorMessage : error.errorInfo
                });
               
            }

            function onSettingSuccess(setting){
                if (setting.value === "http"){
                    $(FIRMWARE_BUNDLE_UPDATE_OPTION_HTTP).attr("checked", true);
                }
                if(setting.value === "https"){
                    $(FIRMWARE_BUNDLE_UPDATE_OPTION_HTTPS).attr("checked", true);
                }
            }

            function onGetSettingError(errorInfo){
                settingsPresenter.setSettingWithNameAndValue(SECURITY_FIRMWAREBUNDLE_UPDATE_OPTION, "http");
            }

            function getProductConfigSuccess(productConfigs){
              UsersViewUtil.setProductConfigs(productConfigs);
              if (productConfigs["settings.security.firmwarebundles.show"] === "true"){
                  settingsPresenter.getSetting(SECURITY_FIRMWAREBUNDLE_UPDATE_OPTION);
                  $(FIRMWARE_BUNDLE_DROPDOWN_LINK).show();
                  $(FIRMWARE_BUNDLE_PANEL).show();
              }else{
                  $(FIRMWARE_BUNDLE_DROPDOWN_LINK).detach();
                  $(FIRMWARE_BUNDLE_PANEL).hide();
                }
            }

            function getProductConfigError(errorInfo){
                $(FIRMWARE_BUNDLE_DROPDOWN_LINK).detach();
                $(FIRMWARE_BUNDLE_PANEL).hide();
            }

            /**
             *  Register events with presenter layer
             */
            function registerEvents() {
             
                presenter.on('updatePublicKeySuccess', onUpdatePublicKeySuccess);
                presenter.on('updatePublicKeyError', onUpdatePublicKeyError);
                presenter.on("selectionChange", onSelectionChange);
                authnPresenter.on("getGlobalSettingsComplete", getGlobalSettingsSuccess);
                authnPresenter.on("getGlobalSettingsError", onError);
                authnPresenter.on("onGetAllProvidersComplete", getDirectoriesData);
                settingsPresenter.on("onGetSettingSuccess",onSettingSuccess);
                settingsPresenter.on("onGetSettingError", onGetSettingError);
                settingsPresenter.on("onSetSettingSuccess",onSettingSuccess);
                settingsPresenter.on('getProductConfigSuccess', getProductConfigSuccess);
                settingsPresenter.on('getProductConfigError', getProductConfigError);
            }

            /**
             *  Un-register events
             */
            function removeEvents() {
                presenter.off('updatePublicKeySuccess', onUpdatePublicKeySuccess);
                presenter.off('updatePublicKeyError', onUpdatePublicKeyError);
                presenter.off("selectionChange", onSelectionChange);
                authnPresenter.off("getGlobalSettingsComplete", getGlobalSettingsSuccess);
                authnPresenter.off("getGlobalSettingsError", onError);
                authnPresenter.off("onGetAllProvidersComplete", getDirectoriesData);
                settingsPresenter.off("onGetSettingSuccess",onSettingSuccess);
                settingsPresenter.off("onGetSettingError", onGetSettingError);
                settingsPresenter.off("onSetSettingSuccess",onSettingSuccess);
                settingsPresenter.off('getProductConfigSuccess', getProductConfigSuccess);
                settingsPresenter.off('getProductConfigError', getProductConfigError);
            }
            function loadData() {
                  authnPresenter.loadSettingsEdit();
            }
            this.pause = function() {
                reset();
                removeEvents();
                cancelAfterApply = false;
                formStateView.reset();
                $(PANELS).hpStackedPanels('pause'); 
            };

            this.resume = function() {
               $(DEFAULT_PROVIDER_SELECT).empty();
                formStateView.reset();
                loadData();
                reset();
                registerEvents();
                settingsPresenter.getProductConfig();
                $(PANELS).hpStackedPanels('resume');
                $(APPLY_WARNING).hide();
              };
            function submitForm(){
              if($(KEY).val() !== ""){
                 updatePublicKey();
                 if(verifyPublicKey === true) {
                     apply(true);
                 }
              }else{
                   apply(true);
                   settingsPresenter.updateSettingWithNameAndValue(SECURITY_FIRMWAREBUNDLE_UPDATE_OPTION,
                       $(FIRMWARE_BUNDLE_UPDATE_OPTION).val());
            }
            }
            /**
             * Loads the product-config data
             */
            function loadProductConfigData(){
                ProductConfig.getproductConfigMembers({
                    success : function(productConfigMembers) {
                     productConfigMembersData = productConfigMembers;
                     }
                });
            }
            /**
             *  Initialization function
             */
            this.init = function() {
                $(KEY).attr('placeholder', Localizer.getString('fs.settings.security.publickey.paste_message'));
                var keyLink = '<a href="https://h20392.www2.hp.com/portal/swdepot/displayProductInfo.do?productNumber=HPLinuxCodeSigning" target="_blank">'+"hp.com"+'</a>',
                publicKeyLinkMsg = Localizer.getString('fs.settings.security.publickey.download_location_msg',[keyLink]);
                $(KEY_LOCATION).html(publicKeyLinkMsg);

                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                $(FW_BUTTONSET).buttonset();
                router.watch('appliance security edit section', ROUTE_PREFIX + '.*',
                   {parent: ROUTE_PREFIX, change: changeLocation});

                formStateView.init({form: FORM,routePattern : ROUTE_PREFIX + '.*',
                    autoTrack: true});
                registerEvents();
                initForm();

                //Reset the formStateView when (re-)entering the key in case of error scenario
                $(KEY).focus(function() {
                formStateView.reset();
                });
              
                $("#fs-settings-authn-edit-allow-local-not-set").show();
                $(LOCAL_LOGIN_CHECK).hide();
                $("#fs-settings-authn-label-allow-local").hide();
                $("#fs-settings-authn-edit-default-provider-not-set").show();
                $(DEFAULT_PROVIDER_SELECT).selectBox({
                    autoWidth : false
                });
                $(DEFAULT_PROVIDER_SELECT).selectBox('control').hide();
                /*
                 * In IE8, maxlength attribute is not supported
                 * This function will make sure entered text in textarea has upper bound as 'maxlength'
                 */ 
                $(KEY).on(" keyup mouseup",function(){  
                    var keyUpperBound = parseInt($(this).attr('maxlength')),  
                        key = $(this).val(),
                        keyLength = key.length;
                    if(keyLength > keyUpperBound){
                        key = key.substr(0, keyUpperBound);
                        $(this).val(key);
                    }
                });

                $(FIRMWARE_BUNDLE_DIV_HTTP).hover(function(){
                    $(FIRMWARE_BUNDLE_HELP_HTTP).attr("style", "display:inline-block;");
                },
                function(){
                    $(FIRMWARE_BUNDLE_HELP_HTTP).attr("style", "display:none;");
                });

                $(FIRMWARE_BUNDLE_DIV_HTTPS).hover(function(){
                    $(FIRMWARE_BUNDLE_HELP_HTTPS).attr("style", "display:inline-block;");
                },
                function(){
                    $(FIRMWARE_BUNDLE_HELP_HTTPS).attr("style", "display:none;");
                });

                $(OK).click(submitForm);
               
             
                $(CANCEL).click(reset);
                loadData();

                settingsPresenter.getProductConfig();

                $(LOCAL_LOGIN_CHECK).bind('click', toggleLocalLoginCheckbox);
                $(DEFAULT_PROVIDER_SELECT).change(function() {
                    if(productConfigMembersData['settings.security.ldap.settings.edit.warning'] === "true" &&
                            defaultProvider.loginDomain !== $(DEFAULT_PROVIDER_SELECT).val() && $(DEFAULT_PROVIDER_SELECT).val() !== '0' ){
                        $(APPLY_WARNING_MSG).text(Localizer.getString('fs.settings.authn.edit.default_dir_change_common_msg')+
                                Localizer.getString('fs.settings.authn.edit.default_dir_change_warning_msg'));
                        $(APPLY_WARNING).show();
                    }else {
                        $(APPLY_WARNING).hide();
                    }
                    $(DEFAULT_DIRECTORY_ERROR).text('');
                    $(DEFAULT_DIRECTORY_ERROR).hide();
                });
                $(APPLY_WARNING).hide();
                loadProductConfigData();
               };
        }

        return new SecurityEditView();

    }());

    return SecurityEditView;

});