// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Localizer', 'hp/presenter/EulaPresenter',
    'hp/core/Router',
    'hp/core/Notifications',
    'hp/view/FormStateView', 'jquery', 'hp/lib/jquery.hpToggle',
    'lib/jquery.validate'],

function(localizer, presenter, router, notifications, FormStateView)
    { "use strict";

    var SupportEditView = (function() {

        var FORM = '#hp-supportaccess-form';
        var OK_BUTTON = "#hp-supportaccess-ok-button",
            CANCEL_BUTTON = "#hp-supportaccess-cancel-button",
            EULA_SERVICE_TOGGLE = "#hp-eula-service-access-toggle-button",
            EULA_CONTENT_BODY = "#hp-form-contents-body";
        var SUPPORT_ACCESS_WARNING ='#hp-support-access-warning';
      
        var SUPPORT_ACCESS_MANUAL = '#hp-eula-supportaccess-manual';

        function SupportEditView() {

            var formStateView = new FormStateView();
            
            function onToggleButtonChange(){
                if ($(EULA_SERVICE_TOGGLE).is(':checked')) {
                    $(SUPPORT_ACCESS_WARNING).hide();
                } else {
                    $(SUPPORT_ACCESS_WARNING).show();
                }
            }
            
            function onLoadSupportSuccess(data, status, xhr) {
                
                var suppportAccessHtml = $(data).filter('#hp-eula-supportaccess-content');
                localizer.localizeDom(suppportAccessHtml);
                $(EULA_CONTENT_BODY).empty();
                $(EULA_CONTENT_BODY).append(suppportAccessHtml);
                $(EULA_SERVICE_TOGGLE).hpToggle({
                    checked: localizer.getString('fs.settings.eula.config.enabled'),
                    unchecked: localizer.getString('fs.settings.eula.config.disabled')
                });
                formStateView.reset();
                $(EULA_SERVICE_TOGGLE).change(onToggleButtonChange);
                presenter.checkIsSupportEnabled();
            }
            
            function onLoadSupportError(jqXHR, textStats, errorThrown) {
            }

            function loadSupportAccessHtml(){
               var url = localizer.getString('fs.settings.eula.config.content_directory') + "/" +
                   localizer.getString('fs.settings.eula.config.support_access_file');
               $.ajax({
                   url: url,
                   type: 'GET',
                   async: true,
                   dataType: "html",
                   success: onLoadSupportSuccess,
                   error: onLoadSupportError
               });
            }
            
            function onOkButtonClick() {
                var isSupportEnabled = false;
                if ($(EULA_SERVICE_TOGGLE).is(':checked')) {
                    isSupportEnabled = true;
                }
                presenter.updateServiceAccess(isSupportEnabled);
            }

            function onCancelButtonClick() {
                formStateView.reset();
                router.go('/settings/show/supportaccess', 'on Edit Service Access cancel');
            }

            function isSupportEnabledSuccess(isSupportEnabled) {
                if (isSupportEnabled) {
                    $(EULA_SERVICE_TOGGLE).attr("checked", "checked");
                    $(SUPPORT_ACCESS_WARNING).hide();
                } else {
                    $(EULA_SERVICE_TOGGLE).removeAttr("checked");
                    $(SUPPORT_ACCESS_WARNING).show();
                }
                $(EULA_SERVICE_TOGGLE).trigger('change');
                formStateView.reset();
            }

            function isSupportEnabledFailure(isSupportEnabled) {
                $(EULA_SERVICE_TOGGLE).removeAttr("checked");
                $(EULA_SERVICE_TOGGLE).trigger('change');
            }

            function enableServiceSuccess(data) {
            	var notif = {
            	    summary : localizer.getString('fs.settings.supportaccess.update'),
            	    uri : "editServicesAcess-" + (new Date()).getTime(),
            	    status : 'ok',
            	    sourceName : localizer.getString('fs.settings.supportaccess.source_object'),
            	    details : localizer.getString('fs.settings.supportaccess.success')
            	};
            	notifications.add(notif, true);
                router.go('/settings/show/supportaccess', 'on Edit Service Access ok');
                presenter.checkIsSupportEnabled();
            }

            function enableServiceFailure(errorMessage){
                var errorDetail = JSON.stringify(errorMessage.message);
                errorDetail = errorDetail.replace(/["']{1}/gi,"");
                var message = localizer.getString('fs.settings.supportaccess.failure');
                var notif = {
                    summary : localizer.getString('fs.settings.supportaccess.update'),
                    uri : "editServicesAcess-" + (new Date()).getTime(),
                    sourceName : localizer.getString('fs.settings.supportaccess.source_object'),
                    status : 'error',
                    details : message + '\n' + errorDetail
                };
                formStateView.setMessage(notif);
                notifications.add(notif, true);
            }

            function registerEvents() {
                presenter.on("isSupportEnabledSucess", isSupportEnabledSuccess);
                presenter.on("isSupportEnabledFailure", isSupportEnabledFailure);
                presenter.on("enableServiceSucess", enableServiceSuccess);
                presenter.on("enableServiceFailure", enableServiceFailure);
            }

            this.resume = function(){
                loadSupportAccessHtml();
            };

            this.init = function() {
                loadSupportAccessHtml();
                $(SUPPORT_ACCESS_MANUAL).hide();
                registerEvents();
                $(OK_BUTTON).click(onOkButtonClick);
                $(CANCEL_BUTTON).click(function(ev) {
                    onCancelButtonClick();
                    ev.preventDefault();
                });
                formStateView.init({form: FORM,autoTrack: true});
            };
        }

        return new SupportEditView();

    }());

    return SupportEditView;
});