// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['fs/presenter/status/StatusPresenter', 'hp/core/Localizer', 
        'hp/core/Router', 'hp/services/SessionService'], 
function(presenter, localizer, router, session) {"use strict";

    var StatusResetView = ( function() {

        var PROGRESS_BAR = '#factory-reset-progress';
        var PROGRESS_STATE = '#factory-reset-state';
        var OK_BUTTON = "#factory-reset-ok";   
           
  
        /**
         * @class View script for the /status/restore page
         */
        function StatusResetView() {
            
           /**
             * Redirect and reload to login page upon success          *
           */            
            function redirect() {
                presenter.setFactoryReset(false);
                // window.location.replace(window.location.pathname);
                router.go('/login', 'login');
            }
               
      
           /**
            * Callback function when the call to get factory reset fails            *
           */
            function onFactoryResetFailure() {
                $(PROGRESS_STATE).val(localizer.getString('fs.status.reset.resetFailure'));
                $(OK_BUTTON).css('display', 'block'); // causes ok button to be displayed on its own line
            }

            function updateProgressBar(taskState) {

                var percent = (taskState.completedSteps * 100) / (taskState.totalSteps);
                $(PROGRESS_BAR).hpProgressBar(percent);
                $(PROGRESS_STATE).text(taskState.state);
            }
           /**
            * Callback function when the call to monitor factory reset task succeeds               
           */
            function onFactoryResetTaskURISuccess() {

                presenter.monitorFactoryResetTask({
                    running : function(taskState) {
                        updateProgressBar(taskState);
                    },
                    success : function(taskState) {
                         updateProgressBar(taskState);
                         redirect();
                    },
                    error : function() {
                       onFactoryResetFailure();
                    }
                });
            }


            this.init = function() {
                document.title = localizer.getString('fs.status.reset.title');
                $(PROGRESS_BAR).hpProgressBar();
                $(PROGRESS_BAR).hpProgressBar(0);
                $(PROGRESS_STATE).text('');  
                $(PROGRESS_BAR).hpProgressBar();
                $(OK_BUTTON).hide();
                $(OK_BUTTON).on('click', function() {
                   redirect();
               });  
                presenter.getFactoryResetTaskURI({
                    success : onFactoryResetTaskURISuccess,
                    error : onFactoryResetFailure
                    
                });

            };

            this.pause = function() {
                // nothing
            };

            this.resume = function() {
                // nothing
            };
        }

        return new StatusResetView();

    }());

    return StatusResetView;

});
