// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['fs/presenter/status/StatusPresenter',
        'hp/core/Localizer',
        'jquery'],

function(statusPresenter, Localizer) {"use strict";

    var StatusUseFloatingView = ( function() {

        /**
         * @class View script for the /status/useFloating page
         */
        function StatusUseFloatingView() {

            var MESSAGE = '#cic-status-message';

            this.init = function() {
                document.title = Localizer.getString('fs.status.useFloating.title');

                var floatingAddrs = statusPresenter.getFloatingAddresses();
                if (floatingAddrs) {
                    var message = Localizer.getString('fs.status.useFloating.message', [ floatingAddrs.join(', ') ]);
                    $(MESSAGE).text(message);
                }
            };

            this.pause = function() {
                // nothing
            };

            this.resume = this.init;
        }

        return new StatusUseFloatingView();

    }());

    return StatusUseFloatingView;

});
