// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['fs/presenter/status/StatusPresenter',
        'hp/core/Router',
        'fs/view/status/StatusStatePages',
        'fs/view/status/StatusPager'],
function(statusPresenter, router, statusStatePages, statusPager) {"use strict";

    var StatusView = ( function() {

        /**
         * @class View script for the status page.
         */
        function StatusView() {
            
            var locationContext;
            var statusLocation = null;

            function updatePage() {
                var view = statusPresenter.getViewForServerStatus();
                if (!view) {
                    if (statusLocation) {
                        statusPager.unload(statusLocation);
                    }
                    // state must be OK, so go to the saved location                   
                    router.go(locationContext, 'server status ok');                    
                } else {
                    if (statusPresenter.hasStateChanged()) {
                        statusPager.unload(statusLocation);
                    } 
                    statusLocation = 'status ' + view; 
                    statusPager.load(statusLocation);
                    
                    router.replaceWith('/status/' + view);
                }
            }

            this.init = function() {
                statusStatePages.register();
                updatePage();
                statusPresenter.on(statusPresenter.SERVER_STATE_CHANGE, updatePage);
            };

            this.pause = function() {
                statusPresenter.off(statusPresenter.SERVER_STATE_CHANGE, updatePage);
            };

            this.resume = function() {
                updatePage();
                statusPresenter.on(statusPresenter.SERVER_STATE_CHANGE, updatePage);
            };

            this.setLocationContext = function(location) {
                locationContext = location;
            };

        }

        return new StatusView();

    }());

    return StatusView;

});
