// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Localizer',
        'fs/presenter/status/StatusPresenter',
        'hp/core/HelpMenu'],

function(Localizer, statusPresenter, helpMenu) {"use strict";

    var StatusWaitingView = ( function() {

    var NOTIFY_MSG = "#cic-appliance-restart-msg-id";


        /**
         * @class View script for the /status/waiting page
         */
        function StatusWaitingView() {
            
            this.resume = function() {
                $(NOTIFY_MSG).html(Localizer.getString('fs.status.waiting.' + statusPresenter.getCachedState().toLowerCase() ));            
                $(NOTIFY_MSG).show();
                helpMenu.allowLocal(false);
            };

            this.pause = function() {
                helpMenu.allowLocal(true);
            };
            this.init = function() {
                this.resume();
            };


        }

        return new StatusWaitingView();

    }());

    return StatusWaitingView;

});
