// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['fs/presenter/welcome/WelcomePresenter', 
'hp/core/Localizer',
'hp/core/Banner',
'jquery'], 
function( presenter, localizer, banner) {"use strict";

    var LAN_STATUS = "#fs-lan-status", 
        LAN_VALUE = "#fs-lan-value", 
        CPU_STATUS = "#fs-cpu-status", 
        CPU_VALUE = "#fs-cpu-value", 
        MEMORY_STATUS = "#fs-memory-status", 
        MEMORY_VALUE = "#fs-memory-value", 
        WELCOME_TITLE = "#fs-welcome-title";
        
    var CLASS_NODE_FIELD_VALUE = '.fs-node-field-value';

 
    var WelcomeView = ( function() {

        /**
         * Constructor
         */
        function WelcomeView() {


            function setStatus(field, minConfigMet){
                if (minConfigMet) {
                    $(field).addClass('hp-status-ok');
                } else {
                    $(field).addClass('hp-status-error');                   
                }
            }
            function showLanStatus(nodeStatus) {                
                $(LAN_VALUE).html(nodeStatus.lan + " " + nodeStatus.lanUnits); 
                setStatus(LAN_STATUS, presenter.isLANMinConfigMet(nodeStatus));
            }
            
            function showCPUStatus(nodeStatus){  
                $(CPU_VALUE).text(nodeStatus.cpu + " @ " + nodeStatus.cpuSpeed + " " + nodeStatus.cpuSpeedUnits);
                setStatus(CPU_STATUS, presenter.isCPUMinConfigMet(nodeStatus));                          
            }
            
            function showMemoryStatus(nodeStatus){
                $(MEMORY_VALUE).text(nodeStatus.memory + " " + nodeStatus.memoryUnits);
                setStatus(MEMORY_STATUS, presenter.isMemoryMinConfigMet(nodeStatus));                          
            }                
          
            function showStatus(nodeStatus) {
                 showLanStatus(nodeStatus);
                 showCPUStatus(nodeStatus);
                 showMemoryStatus(nodeStatus);
            }

            function handleRequestError() {
               $(CLASS_NODE_FIELD_VALUE).text('');
               $(CLASS_NODE_FIELD_VALUE).addClass('hp-status-unknown');
            }

            /**
             * @public
             */
            this.pause = function() {
            };

            this.resume = function() {
            };

            this.init = function() {

                $(WELCOME_TITLE).text(localizer.getString('fs.welcome.welcomeHeading',
                                    [banner.getApplicationTitle()]));
               
                presenter.getNodeStatus({
                    success : function(nodeStatus) {                        
                        showStatus(nodeStatus);                        
                    },
                    error : function(errorInfo) {
                        handleRequestError();
                    }
                });  
                $('.hp-button.hp-primary').focus();
            };
            

        }

        return WelcomeView;
    }());

    return new WelcomeView();
});
