// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
//File to init help.html

require({
    baseUrl : './',
    paths : {
        //This needs to mirror (be a subset of) what is in src/main/build/app.build.js and shell-require.js
        jquery : 'js/lib/jquery-1.7.1',
        lib : 'js/lib',
        hp : 'js/hp' //shorthand
    },
    priority : ['jquery'],
    waitSeconds : 20 // make VPN more resilient
}, ['hp/model/help/HelpModel',
    'hp/services/Log',
    'jquery'],
function(helpModel, log) { "use strict";

    var debug = false;

    function normaliseLang(lang) {
        lang = lang.replace(/_/, '-').toLowerCase();
        if(lang.length > 3) {
            lang = lang.substring(0, 3) + lang.substring(3).toUpperCase();
        }
        return lang;
    }
    
    function getLang() {
        var lang;
        
        switch(normaliseLang(navigator.language || navigator.userLanguage).toLowerCase()) {
        case 'es':
        case 'es-es':
            //spanish
            lang = 'es';
            break;
        case 'en':
        case 'en-us':
        case 'en_us':
        default:
            //english
            lang = 'en';
        break;
        }
        
        return lang;
    }
    
    function hashChanged() {
        helpModel.help(getLang(), function(url) {
            if (!debug) {
                log.info('Redirecting to ' + url);
                window.location = url; // redirect
            }
        });
    }

    $(document).ready(function() {
        $(window).bind('hashchange', hashChanged);
        hashChanged();
    });
});