// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {Application}
 */
define([ 'hp/view/LocationView', 'hp/core/Banner', 'hp/core/Environment',
        'hp/core/Localizer', 'hp/view/login/LoginView', 'hp/core/UrlFragment',
        'hp/core/Router', 'hp/core/Validator', 'hp/core/Datepicker','hp/core/Timepicker',
        'hp/presenter/settings/DevelopmentPresenter',
        'hp/services/IndexService', 'text!hpPages/core/body_contents.html',
        'lib/jquery.cookie', 'jquery' ], function(locationView, banner,
        environment, localizer, loginView, urlFragment, router, validator, datepicker, timepicker,
        developmentPresenter, indexService, bodyContentsHtml) {
    "use strict";

    var Application = (function() {

        var BODY = 'body';
        var KIOSK_MODE = 'kiosk';
        var DEFAULT_OPTIONS = {
            title : 'Title',
            subTitle : null,
            banner : {
                search : true,
                notifications : 'sidebar'
            },
            version : 1
        }

        function Application() {

            var options;

            function loadCss(file) {
                var primary = $('html head link[href$="hp-piano.css?BMN="]').attr(
                        'href');
                if (primary) {
					primary = primary + Date.now();
                    var link = document.createElement("link");
                    link.type = "text/css";
                    link.rel = "stylesheet";
                    link.href = primary.replace('hp-piano.css', file);
                    document.getElementsByTagName("head")[0].appendChild(link);
                }
            }

            function onResize() {
                $(BODY).toggleClass('hp-narrow', $(window).width() < 600);
            }

            this.init = function(optionsArg) {
                if (typeof optionsArg === 'string') {
                    optionsArg = {
                        title : optionsArg
                    };
                }

                options = $.extend(true, {}, DEFAULT_OPTIONS, optionsArg);

                // allow tests to insert something around the application
                if ($('#hp-body').length > 0) {
                    BODY = '#hp-body';
                }
                $(BODY).empty();
                $(BODY).append($(bodyContentsHtml));
                if (options.layout) {
                    $(BODY).addClass('hp-' + options.layout + '-layout');
                }

                // look for kiosk cookie. If found,
                // environment.setKioskMode(true)
                if ($.cookie(KIOSK_MODE)) {
                    environment.setKioskMode(true);
                } else {
                    // cookie not found
                    var params = urlFragment
                            .getParameters(window.location.href);
                    if (params.kiosk === 'true') {
                        $.cookie(KIOSK_MODE, 'true');
                        environment.setKioskMode(true);
                    }
                }

                localizer.init();
                locationView.init();
                banner.init(options.title, options.subTitle, options.banner);
                validator.init();
                datepicker.init();
                timepicker.init();
                // check in case partner has their own index service
                if (indexService.init) {
                    indexService.init(options.version);
                }
                loginView.setTitle(options.title, options.subTitle);

                localizer.localizeDom();

                $(BODY).addClass('hp-active');
                $(window).resize(onResize);
                onResize();

                if (developmentPresenter.isExperimentalFeatures()) {
                    $('html').addClass('experimental');
                } else {
                    $('html').removeClass('experimental');
                }

                if (developmentPresenter.getHighContrast()) {
                    $('html').addClass('hp-high-contrast');
                } else {
                    $('html').removeClass('hp-high-contrast');
                }

                loadCss('hp-piano-containers.css');
                loadCss('hp-piano-graphics.css');
            };

            this.start = function() {
                if (environment.supportedBrowser()) {
                    router.start();
                } else {
                    $('#hp-unsupported-browser').show();
                    $('#hp-page-spinner').hide();
                    banner.startMenu({
                        simpleBanner : true
                    });
                }
            };

            this.options = function() {
                return $.extend({}, options);
            }
        }

        return new Application();
    }());

    return Application;
});
