// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

if (!hp) {
    var hp = {};
}
//function from jquery.localize
hp.normaliseLang = function(lang) {
    lang = lang.replace(/_/, '-').toLowerCase();
    if(lang.length > 3) {
        lang = lang.substring(0, 3) + lang.substring(3).toUpperCase();
    }
    return lang;
};
//var normally $.defaultLanguage from jquery.localize
if (!hp.defaultLanguage) {
    var cookies = document.cookie.split('; '), // can't use jquery here. get it the hard way
        cookie,
        lang;
    for (var i=0; i<cookies.length; i++) {
        cookie = cookies[i].split('=');
        if (cookie[0] === 'locale') {
            lang = cookie[1];
            break;
        }
    }
    //browserLanguage: Retrieves the current operating system language.
    //userLanguage: Retrieves the operating system's natural language setting.
    //language: Retrieves the browser locale, used by FF/Chrome 
    hp.defaultLanguage = hp.normaliseLang(lang || navigator.language || navigator.browserLanguage || navigator.userLanguage);
}

if (!hp.supportedLocales) {
    hp.supportedLocales = ['en','es','zh','ja'];
}

// hp.getLang can be overridden by the application's shell-require.js to choose the current locale.
// For example, put something like this at the very top of shell-require.js, before the require() call:
// if (!hp) {
//     var hp = {};
// }
// hp.getLang = function() {
//    // choose the language here and return it
// }

if (!hp.getLang) {
    hp.getLang = function() {
        var lang,
            supportedLocale,
            locale = hp.defaultLanguage;
        for (var i=0; i < hp.supportedLocales.length; i++) {
            supportedLocale = hp.supportedLocales[i];
            if (typeof supportedLocale === 'string') {
                supportedLocale = {lang: supportedLocale };
            }
            if (supportedLocale.pattern) {
                if (locale.match(supportedLocale.pattern)) {
                    lang = supportedLocale.lang;
                    break;
                }
            }
            else {
                if (locale.split(/[-_]/)[0] === supportedLocale.lang) {
                    lang = supportedLocale.lang;
                    break;
                }
            }
        }
        return lang ? lang : 'en';
    };
}
//problem, the above defines a global hp with getLang, defaultLanguage, and normalizseLang functions

define(['lang/' + hp.getLang(), 'hp/services/Log'], function(bundle, log) {
    "use strict";
    var Language = ( function() {

        /**
         * @type {AvailableLanguages}
         * @constructor
         */
        function Language() {

            var loadedLang = hp.getLang();
            
            this.getBundle = function(lang) {
                if (lang && lang !== loadedLang) {
                    log.warn('Requested locale ' + lang + ' but using ' + loadedLang);
                }
                return bundle;
            };
        }

        return new Language();
    }());
    return Language;
});
