// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['./upload-en', './settings-en', './help-en', './notify-en', './datepicker-en', './timepicker-en'],
function (upload, settings, help, notify, datepicker, timepicker) {
"use strict";
    return {
        upload : upload,
        settings : settings,
        help : help,
        notify : notify,
        datepicker : datepicker,
        timepicker : timepicker,

        loading : "Loading ...",
        // TODO: remove styling and use CSS
        rest_error_fmt : "<b>{0}</b><BR>{1}<BR><b>Resolution:</b> {2}",

        //TODO consider moving the CIC specific stuff out of core.

        login : {
            "user" : "User",
            "password" : "Password",
            "loginButton" : "Login",
            "domain" : "Domain",
            "title" : "Appliance"
        },
        menu : {
            settings : "Settings",
            search : "Search",
            map : "Map",
            activity : "Activity"
        },
        shell : {
            banner : {
                title : "Browse",
                session : {
                    control : {
                        tooltip : "Session"
                    },
                    duration : "Logged in",
                    logout : "Logout"
                },
                local : "Local"
            },
            unsupportedBrowser : "The web browser you are using is not supported. Please consider using the most recent (stable) version of Chrome, Safari, Firefox, Opera, or Internet Explorer version 8 or better."
        },
        dataTables : {
            oLanguage : {
                sProcessing : "Processing...",
                sLengthMenu : "Show _MENU_ entries",
                sZeroRecords : "No matching records found",
                sEmptyTable : "No items",
                sLoadingRecords : "Loading...",
                sInfo : "Showing _START_ to _END_ of _TOTAL_ entries",
                sInfoEmpty : "Showing 0 to 0 of 0 entries",
                sInfoFiltered : "(filtered from _MAX_ total entries)",
                sInfoPostFix : "",
                sSearch : "Search:",
                sUrl : "",
                oPaginate : {
                    sFirst : "First",
                    sPrevious : "Previous",
                    sNext : "Next",
                    sLast : "Last"
                },
                fnInfoCallback : null
            }
        },
        master : {
            header : {
                all : "All",
                referenced : "References",
                searched : "Search",
                filtered : "Filtered"
            },
            filters : {
                title : "Filters",
                filter : "Filter",
                noFilters : "No filters",
                error : "Error",
                warning : "Warning",
                recentlyAdded : "Recently added",
                recentlyChanged : "Recently changed",
                resetAll : "Reset",
                date : {
                    specific : "Specific date range"
                },
                matchesCount : "{0} matches out of {1}",
                matchCount : "1 match out of {0}",
                referrerLabel : "Related to"
            },
            loadingItems : 'Loading {0} ...',
            noItems : 'No {0}',
            noMatches : 'No matches',
            showMore : 'Load more',
            top: 'Top',
            selectAll : 'Select all'
        },
        details : {
            view : "View",
            actions : "Actions",
            edit : "Edit",
            close : "Close",
            cancel : "Cancel",
            reset : "Reset",
            add : "Add",
            addAgain : "Add +",
            addAgainTip : "Add and add another",
            create : "Create",
            createAgain : "Create +",
            createAgainTip : "Create and create another",
            remove : "Remove",
            removeAgain : "Remove +",
            select : "Select",
            save : "Save",
            update : "Update",
            "delete" : "Delete",
            ok : "OK",
            apply : "Apply",
            more : "More",
            enable: "Enable",
            disable: "Disable",
            addAll : "Add All",
            addSelected : "Add Selected",
            removeAll : "Remove All",
            removedSelected : "Remove Selected",
            overview : "Overview",
            backToOverview : "Back to overview"

        },
        deleteConfirm : {
            title : "Delete {0}",
            dependencyHeader : "{0} items depend on {1}",
            prompt : "Continue with delete?",
            ok : "Yes, delete"
        },
        "delete" : {
            title : "Warning: {0} {1} is currently in use.",
            accordian_button : "{0} server profiles using {1}",
            accordian_button_singular : "1 server profile using {0}",
            message : "Delete {0} {1}?",
            name : "Name",
            description : "Description",
            delete_button : "Yes, delete",
            cancel_button : "Cancel"
        },
        formState : {
            changed : "Changed: {0} to \"{1}\"",
            changed_label_only : "Changed: {0}",
            unchanged : "Reset: {0}",
            checked : "Checked: {0}",
            unchecked : "Unchecked: {0}",
            checkedValue: "checked",
            uncheckedValue: "unchecked",
            navigateAway : {
                warning : "Warning: Your changes will be lost.",
                prompt : "Proceed to new page?",
                proceed : "Yes, proceed",
                cancel : "Cancel"
            }
        },
        associationEdit : {
            selected : "{0} selected",
            added : "{0} added",
            removed : "{0} removed"
        },
        common : {
            close: "Close",
            yes : "Yes",
            no : "No",
            notset : "not set",
            none : "none",
            cancel : "Cancel"
        },
        validator : {
            messages : {
                required : "This field is required.",
                number : "Enter a valid number.",
                digits : "Enter a whole number (digits only).",
                range: "Enter a value between {0} and {1}."	,
                max : "Enter a value less than or equal to {0}.",
                min : "Enter a value greater than or equal to {0}.",
                name : "The name can only contain printable characters, and may not include leading whitespace.",
                remote: "Fix this field.",
                email: "Enter a valid email address.",
                url: "Enter a valid URL.",
                date: "Enter a valid date.",
                dateISO: "Enter a valid date (ISO).",
                equalTo: "Enter the same value again.",
                maxlength: "Enter no more than {0} characters.",
                minlength: "Enter at least {0} characters.",
                rangelength: "Enter a value between {0} and {1} characters long."
            }
        },
        noDetails : {
            header : "Unable to locate the item you requested.",
            detail : "The item you requested does not exist. It is possible that another user has deleted this item. Refresh this page or select a different item.",
            specificErrorDetails : "Details"               
        },
        noItems : {
            header : "Unable to retrieve {0}.",
            detail : "There was a problem getting the list of items.  Please try refreshing this page."
        },
        noPage : {
            header : "Unable to locate the page you requested.",
            detail : "The page or referenced item you requested either does not exist or the URL has been entered incorrectly. If you reached this page by clicking a link in a previous page, return to that page, refresh it and try again. If you manually entered a URL or used a bookmark, check it for accuracy and validity."
        },
        notAuthorized : {
            header : "Not authorized.",
            detail_user : "{0} is not authorized to view this page.",
            detail : "You are not authorized to view this page."
        },
        noRoles : {
            header : "No roles.",
            detail : "You do not have any management roles on this system. Please contact the security administrator about your role."
        },
        noSession : {
            header : "The login session has been lost."
        },

        measurements : {
            "millimeters" : "{0} mm",
            "meters" : "{0} m",
            "celsius" : "{0} \u00B0C",
            "fahrenheit" : "{0} \u00B0F",
            "usMeasurement" : "{0}' {1}\"",
            "dimensions" : "{0}  x {1}",
            units : {
                "meter" : "m",
                "millimeter" : "mm",
                "feet" : "ft",
                "inches" : "in"
            }
        },
        units : {
            "meter" : "m",
            "millimeter" : "mm",
            "feet" : "ft",
            "inches" : "in",
            "bytes" : "B",
            "kilobytes" : "KB",
            "megabytes" : "MB",
            "gigabytes" : "GB",
            "terrabytes" : "TB",
            "petabytes" : "PB"
        },
        date : {
            absoluteFormat : "M/d/yy h:mm:ss a",
            today : "Today {0}",
            yesterday : "Yesterday {0}",
            tomorrow : "Tomorrow {0}",
            todayFormat : "h:mm:ss a",
            yesterdayFormat : "h:mm:ss a",
            tomorrowFormat : "h:mm:ss a",
            thisYearFormat : "MMM d h:mm:ss a",
            priorYearFormat : "M/d/yy h:mm:ss a"
        },
        duration : {
            dh: "{0}d{1}h", // days and hours
            hm: "{0}h{1}m", // hours and minutes
            ms: "{0}m{1}s", // minutes and seconds
            s: "{0}s",      // seconds
            m: "{0}m",      // minutes
            h: "{0}h",      // hours
            d: "{0}d",      // days
            y: "{0}y",      // years
            today: "today"  // within today
        },
        timeago : {
            prefixAgo: null,
            prefixFromNow: null,
            suffixAgo: "ago",
            suffixFromNow: "from now",
            seconds: "< 1 minute",
            minute: "1 minute",
            minutes: "%d minutes",
            hour: "1 hour",
            hours: "%d hours",
            day: "1 day",
            days: "%d days",
            month: "1 month",
            months: "%d months",
            year: "1 year",
            years: "%d years",
            numbers: []
        },
        sort : {
            ascending : "Ascending",
            descending : "Descending"
        },
        map: {
            title: "Map"
        },
        related: {
            title: "Related"
        },
        file: {
            upload: {
                control: {
                    tooltip: 'Uploads',
                    doNotExitBrowser: 'Do not close the window, log out or reload the browser when a file upload is in progress.'
                },
                flyout: {
                    upload: "Uploads",
                    elapsed: "{0} elapsed",
                    remaining: "{0} remaining"
                },
                cancel: {
                    confirmTitle: "Stop upload",
                    confirmQuestion: "Stop upload file {0}?",
                    confirmNote: "Note: Any data transferred so far will be discarded.",
                    yesButton: "Yes, stop upload",
                    canceled: "Upload Canceled"
                },
                error : {
                    emptyResponse : "Empty response",
                    accessDenied : "Upload failed but unable to get response details: {0}.",
                    noDrop: "This browser doesn't support drag and drop of files."
                }
            },
            chooser : {
                label: "File",
                dragAndDrop: "Drag and drop a file or select a file to upload.",
                browse_only: "Select a file to upload.",
                dragOverText: "Drop file here",
                oneFileOnly: "Choose one file at a time for upload.",
                dropOneFileOnly: "Drop one file only.",
                invalidSelection: "A file is required.",
                noDragDrop: "Drag and drop is not supported by this browser.",
                browse: "Browse",
                disabled: "File upload is disabled when running on the console.",
                disclaimerMessage: "Your browser upload is limited to {0}GB. To upload a larger file use Firefox or Chrome."
            }
        },
        connectionError : "Encountered a communication problem with {0}. Try again.",
        dashboard: {
            alerts : {
                label : {
                    single: 'alert',
                    plural: 'alerts'
                }
            }
        }
    };
});
