// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['./upload-es', './settings-es', './help-es', './notify-es', './datepicker-es', './timepicker-es'],
function (upload, settings, help, notify, datepicker, timepicker) {
"use strict";
    return {
        upload : upload,
        settings : settings,
        help : help,
        notify : notify,
        datepicker : datepicker,
        timepicker : timepicker,

        loading : "Cargando...",

        rest_error_fmt : "<b>{0}</b><BR>{1}<BR><b>Resoluci\u00F3n:</b> {2}",

        login : {
            "user" : "Usuario",
            "password" : "Contrase\u00F1a",
            "loginButton" : "Login",
            "domain" : "Dominio",
            "title" : "Aparato"
        },
        menu : {
            settings : "Configuracion",
            search : "B\u00fasqueda",
            map : "Mapa",
            activity : "Actividad"
        },
        shell : {
            banner : {
                title : "Explorar",
                session : {
                    control : {
                        tooltip : "Sesion"
                    },
                    duration : "Conectado",
                    logout : "cierre de sesion"
                },
                local : "local"
            },
            unsupportedBrowser : "El navegador que est\u00E1i utilizando no es compatible. Por favor, considere el uso de " +
                                 "la m\u00E1s reciente (estable) versi\u00F3n de Chrome, Safari, Firefox, Opera o Internet " +
                                 "Explorer versi\u00F3n 8 o superior."
        },
        dataTables : {
            oLanguage : {
                sProcessing : "Procesamiento",
                sLengthMenu : "Mostrar las entradas _MENU_",
                sZeroRecords : "No hay registros coincidentes encontrados",
                sEmptyTable : "No hay elementos",
                sLoadingRecords : "Cargando...",
                sInfo : "Mostrando _START_ de _END_ de entradas _TOTAL_",
                sInfoEmpty : "Mostrando 0 a 0 de 0 entradas",
                sInfoFiltered : "(filtrado de _MAX_ total de entradas)",
                sInfoPostFix : "",
                sSearch : "Buscar:",
                sUrl : "",
                oPaginate : {
                    sFirst : "Primero",
                    sPrevious : "Anterior",
                    sNext : "Pr\u00F3ximo",
                    sLast : "Pasado"
                },
                fnInfoCallback : null
            }
        },
        master : {
            header : {
                all : "Todo",
                referenced : "Referencia",
                searched : "B\u00fasqueda",
                filtered : "Filtrado"
            },
            filters : {
                title : "Filtros",
                filter : "Filtrar",
                noFilters : "No hay filtros",
                error : "Error",
                warning : "Advertencia",
                recentlyAdded : "Recientemente anadido",
                recentlyChanged : "Ha cambiado recientemente el",
                resetAll : "Restaurar",
                date : {
                    specific : "Rango de fechas especifico"
                },
                matchesCount : "{0} matches out of {1}", 
                matchCount : "1 match out of {0}",
                referrerLabel : "Related to"
            },
            loadingItems : 'Carga de {0} ...',
            noItems : 'No hay {0}',
            noMatches : 'No hay coincidencias',
            showMore : 'Cargue mas',
            top: '[SP] Top',
            selectAll : '[SP] Select all'
        },
        details : {
            view : "Vista",
            actions : "Acciones",
            edit : "Editar",
            close : "Cerrar",
            cancel : "Cancelar",
            reset : "Reinicializar",
            add : "A\u00F1adir",
            addAgain : "A\u00F1adir +",
            addAgainTip : "Agregar y agregue otra",
            create : "Crear",
            createAgain : "Crear +",
            createAgainTip : "Crear y crear otra",
            remove: "Remove",
            removeAgain : "Remove +",
            select : "Select",
            save : "Ahorrar",
            update : "Actualizaci\u00F3n",
            "delete" : "Eliminar",
            ok : "Aceptar",
            apply : "Aplicar",
            more : "M\u00E1s",
            enable: "Permitir",
            disable: "Inhabilitar",
            addAll : "Agregar Todos",
            addSelected : "Agregar Seleccionados",
            removeAll : "Eliminar Todos Los",
            removedSelected : "Eliminar Seleccionados",
            overview : "Resumen",
            backToOverview : "Volver a la vista"
        },
        deleteConfirm : {
            title : "Eliminar {0}",
            dependencyHeader : "{0} elementos dependen de {1}",
            prompt : "Continuar con delete?",
            ok : "Si, eliminar"
        },
        "delete" : {
            title : "Advertencia: {0} {1} esta actualmente en uso.",
            accordian_button : "{0} perfiles de servidor utilizando {1}",
            accordian_button_singular : "Un servidor de perfiles con {0}",
            message : "Eliminar {0} {1}?",
            name : "Nombre",
            description : "Descripcion",
            delete_button : "Si, eliminar",
            cancel_button : "Cancelar"
        },
        formState : {
            changed : "Cambiado: {0} a \"{1}\"",
            changed_label_only : "Cambiado: {0}",
            unchanged : "Reajustar: {0}",
            checked : "Comprobado: {0}",
            unchecked : "No comprobado: {0}",
            checkedValue: "comprobado",
            uncheckedValue: "no comprobado",
            navigateAway : {
                warning : "Advertencia: Los cambios se perderan.",
                prompt : "Vaya a la pagina de nuevo?",
                proceed : "Si, pase",
                cancel : "Cancelar"
            }
        },
        associationEdit : {
            selected : "{0} seleccionado",
            added : "{0} anadido",
            removed : "{0} removed"
        },
        common : {
            close: "Cerrar",
            yes : "Si",
            no : "No",
            notset : "no se establece",
            none : "ninguno",
            cancel : "Cancelar"
        },
        validator : {
            messages : {
                required : "Este campo es obligatorio.",
                number : "Introduzca un n\u00FAmero valido.",
                digits : "Introduzca solo n\u00FAmeros.",
                range : "Introduzca un valor entre {0} y {1}.",
                max : "Introduzca un valor menor o igual a {0}.",
                min : "Introduzca un valor mayor o igual a {0}.",
                name : "El nombre s\u00F3lo puede contener caracteres imprimibles, y no puede incluir espacios " +
                    "en blanco que conduce.",
                remote: "Fix this field.",
                email: "Enter a valid email address.",
                url: "Enter a valid URL.",
                date: "Enter a valid date.",
                dateISO: "Enter a valid date (ISO).",
                equalTo: "Enter the same value again.",
                maxlength: "Enter no more than {0} characters.",
                minlength: "Enter at least {0} characters.",
                rangelength: "Enter a value between {0} and {1} characters long."
            }
        },
        noDetails : {
            header : "No se puede encontrar el articulo que usted solicito.",
            detail : "El articulo que usted solicito no existe. " +
                "Es posible que otro usuario ha eliminado este elemento. " +
                "Actualizar esta p\u00E1gina o seleccione un elemento diferente",
            specificErrorDetails : "Detalles"
            
        },
        noItems : {
            header : "No se puede encontrar {0}.",
            detail : "Hubo un problema al obtener la lista de articulos." +
                "Por favor, prueba a actualizar esta pagina."
        },
        noPage : {
            header : "No se puede encontrar la pagina solicitada.",
            detail : "La pagina o \u00EDtem referenciado que ha solicitado o bien " +
                "no existe o la direccion URL se ha introducido correctamente. " +
                "Si llego a esta pagina haciendo clic en un enlace en una pagina anterior, " +
                "regresar a esa pagina, actualice y vuelva a intentarlo. " +
                "Si introduce manualmente una direccion URL o usar un marcador, " +
                "verificar su exactitud y validez."
        },
        notAuthorized : {
            header : "No se autoriza.",
            detail_user : "{0} no est\u00e1n autorizado a ver esta p\u00e1ngina.",
            detail : "Usted no esta autorizado para ver esta pagina."
        },
        noRoles : {
            header : "No hay papeles.",
            detail : "Usted no tiene ninguna funci\u00F3n de gesti\u00F3n de este sistema. Por favor, " +
                     "p\u00F3ngase en contacto con el administrador de seguridad acerca de su papel."
        },
        noSession : {
            header : "La sesi\u00F3n de inicio de sesi\u00F3n se ha perdido."
        },
        measurements : {
            "millimeters" : "{0} mm",
            "meters" : "{0} m",
            "celsius" : "{0} \u00B0C",
            "fahrenheit" : "{0} \u00B0F",
            "usMeasurement" : "{0}' {1}\"",
            "dimensions" : "{0}  x {1}",
            units : {
                "meter" : "m",
                "millimeter" : "mm",
                "feet" : "pies",
                "inches" : "plgds"
            }
        },
        units : {
            "meter" : "m",
            "millimeter" : "mm",
            "feet" : "ft",
            "inches" : "in",
            "bytes" : "B",
            "kilobytes" : "KB",
            "megabytes" : "MB",
            "gigabytes" : "GB",
            "terrabytes" : "TB",
            "petabytes" : "PB"
        },
        date : {
            absoluteFormat : "d/M/yy h:mm:ss a",
            today : "Hoy {0}",
            yesterday : "Ayer {0}",
            tomorrow : "Manana {0}",
            todayFormat : "h:mm:ss a",
            yesterdayFormat : "h:mm:ss a",
            tomorrowFormat : "h:mm:ss a",
            thisYearFormat : "MMM d h:mm:ss a",
            priorYearFormat : "d/M/yy h:mm:ss a"
        },
        duration : {
            dh: "{0}d{1}h",
            hm: "{0}h{1}m",
            ms: "{0}m{1}s",
            s: "{0}s",
            m: "{0}m",
            h: "{0}h",
            d: "{0}d",
            y: "{0}y",
            today: "hoy"  // within today
        },
        timeago : {
            prefixAgo: "hace",
            prefixFromNow: "dentro de",
            suffixAgo: "",
            suffixFromNow: "",
            seconds: "menos de un minuto",
            minute: "un minuto",
            minutes: "unos %d minutos",
            hour: "una hora",
            hours: "%d horas",
            day: "un dia",
            days: "%d dias",
            month: "un mes",
            months: "%d meses",
            year: "un a\u00d1o",
            years: "%d a\u00d1os"
        },
        sort : {
            ascending : "Ascendente",
            descending : "Descendente"
        },
        map: {
            title: "Mapa"
        },
        related: {
            title: "Conexo"
        },
        file: {
            upload: {
                control : {
                    tooltip : 'Archivos',
                    doNotExitBrowser: 'No cierre la ventana o cerrar la sesion cuando un archivo de carga esta en progreso'
                },
                flyout : {
                    upload : "Archivos",
                    elapsed: "{0} transcurrido",
                    remaining: "{0} restante"
                },
                cancel: {
                    confirmTitle: "Deje de cargar",
                    confirmQuestion: "Deje de cargar el archivo {0}?",
                    confirmNote: "Nota: Todos los datos transferidos hasta el momento se descarta.",
                    yesButton: "Si, deja de subir",
                    canceled: "Subsida se ha cancelado"
                },
                error : {
                    emptyResponse : "La respuesta de vac\u00edo",
                    accessDenied : "Error al subir, pero no pueden obtener detalles de la respuesta: {0}",
                    noDrop: "Este navegador no soporta arrastrar y soltar archivos"
                }
            },
            chooser : {
                label: "archivo Selector",
                dragAndDrop: "Arrastrar y soltar un archivo de actualizaci\u00f3n aqu\u00ed para cargar el aparato o " +
                    "haga clic en el bot\u00f3n {0} para buscar archivos",
                browse_only: "Haga clic en el bot\u00f3n {0} para buscar archivos",
                dragOverText: "Deja tu archivo aqui",
                oneFileOnly: "Seleccione un archivo al mismo tiempo para cargar",
                dropOneFileOnly: "Escoja solo un archivo",
                invalidSelection: "seleccion no valida",
                noDragDrop: "Arrastrar y soltar no es compatible con este navegador.",
                browse : "Elija",
                disabled: "La carga de archivos se desactiva cuando se ejecuta en la consola.",
                disclaimerMessage: "Su navegador carga est\u00e1 limitado a " +
                                   "{0}GB. Para subir un archivo m\u00e1s " +
                                   "grande de uso de Firefox o Chrome."
            }
        },        
        connectionError : "Se encontr\u00F3 un problema de comunicaci\u00F3n con {0}. Int\u00E9ntelo de nuevo.",
        dashboard: {
            alerts : {
                label : {
                    single: 'alert',
                    plural: 'alerts'
                }
            }
        }
    };

});
