// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hp/core/Style', 'jquery', 'lib/excanvas'],
function(style) { "use strict";
  
    var GraphicEnclosure = (function() {
      
        /**
         * Constructor
         */
        function GraphicEnclosure() {
          
            var container = null;
            var scrollContext = null;
            
            var resizeTimer = null;
            
            // LAYOUT functions
            
            function resetSmall() {
                if (scrollContext && scrollContext.length > 0) {
                    container.css('visibility', 'hidden');
                    container.removeClass('hp-small');
                    if (scrollContext.width() < container.width() ||
                        scrollContext.height() < container.height()) {
                        container.addClass('hp-small');
                        if (container.hasClass('hp-enclosure-front')) {
                            container.removeClass('hp-vertical').addClass('hp-horizontal');
                        }
                    } else {
                        if (container.hasClass('hp-enclosure-front')) {
                            container.removeClass('hp-horizontal').addClass('hp-vertical');
                        }
                    }
                    container.css('visibility', '');
                }
            }
          
            function layout() {
                resetSmall();
            }
            
            function reset() {
                layout();
            }
            
            function onResize(event) {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function () {
                    reset(false);
                }, 50);
            }
            
            function registerListeners() {
                $(window).on('resize', onResize);
                container.parents('.hp-page').on('relayout', reset);
            }
            
            function unregisterListeners() {
                $(window).off('resize', onResize);
                container.parents('.hp-page').off('relayout', reset);
            }
            
            /**
             * @public
             */
            this.init = function(containerArg, scrollContextArg) {
                container = $(containerArg);
                scrollContext = $(scrollContextArg);
                
                registerListeners();
                reset();
            };
            
            this.pause = function () {
                unregisterListeners();
            };
            
            this.resume = function () {
                registerListeners();
                reset();
            };
            
            this.reset = reset;
        }

        return GraphicEnclosure;
    }());
    
    return GraphicEnclosure;
});
