// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
// From: http://webreflection.blogspot.com/2009/07/ecmascript-iso-date-for-every-browser.html
define([], function() {"use strict";
    function t(i){return i<10?"0"+i:i;}
    function h(i){return i.length<2?"00"+i:i.length<3?"0"+i:3<i.length?Math.round(i/Math.pow(10,i.length-3)):i;}
    
    if(!('toISOString' in Date.prototype)) {
        
        Date.prototype.toISOString = function () {
            return "".concat(
                this.getUTCFullYear(), "-",
                t(this.getUTCMonth() + 1), "-",
                t(this.getUTCDate()), "T",
                t(this.getUTCHours()), ":",
                t(this.getUTCMinutes()), ":",
                t(this.getUTCSeconds()), ".",
                h("" + this.getUTCMilliseconds()), "Z"
            );
        };
    }
    
    if(!('isToday' in Date.prototype)) {
        
        Date.prototype.isToday = function () {
            var now = new Date();
            return (this.getFullYear() === now.getFullYear() &&
                this.getMonth() === now.getMonth() &&
                this.getDate() === now.getDate());
        };
    }
    
    if(!('parseISOString' in Date)) {
        
        Date.parseISOString = function (str) {
            // ISO 8601 allows many variations on the timestamp format.
            // This parser supports two:
            //     2011-12-20T08:48:22.888Z
            //     2011-12-20T08:48:22Z
            var ms = (str.length > 20) ? parseFloat(str.slice(19,23)) * 1000 : 0;
            return new Date(Date.UTC(
                parseInt(str.slice(0,4), 10),
                parseInt(str.slice(5,7), 10) - 1,
                parseInt(str.slice(8,10), 10),
                parseInt(str.slice(11,13), 10),
                parseInt(str.slice(14,16), 10),
                parseInt(str.slice(17,19), 10),
                ms));
        };
    }
    
    if(!('now' in Date)) {
        
        Date.now = function (str) {
            return (new Date()).getTime();
        };
    }

    if(!('tzOffsetString' in Date)) {

        Date.tzOffsetString = function () {
            var tzOffset = (new Date()).getTimezoneOffset();
            var tzOffsetString;
            if(tzOffset!==0){
                var sign = (tzOffset < 0)?"+":"-";
                tzOffset = Math.abs(tzOffset);
                tzOffsetString = "(UTC "+sign+t(parseInt(tzOffset/60,10))+""+t(tzOffset%60)+")";
            }else{
                tzOffsetString = "(UTC)";
            }
            //return whitespace padded timezone offset String
            return "  "+tzOffsetString;
        };
    }
    /**
     * @public
     * Registers a running clock 
     * @param {on} Boolean value indicating whether clock timers 
     *     will be created or not
     * @param {viewData} Object with properties as follows:
     *     timerList: timers list of the view
     *     dateTimeUTS: global dateTime Unix timestamp object of the view
     *     dateTimeFieldHandler: callback function which should specify the 
     *       UI field to be updated with date object.Other related operations
     *       which needs be performed with each timeout, should also be included in this. 
     *     timeout: unit of clock tick e.g. 1 sec(1000ms) or 1 min(60000ms)
     *
     *  Remember to de-register the clock on view pause() by passing a 'false'
     *  boolean as first parameter
     */
    if(!('registerClock' in Date)){
        Date.registerClock = function(on,viewData){
            //clear old timers
            $.each(viewData.timerList,function(){
                clearInterval(viewData.timerList.pop());
            });
            if(on){
                var d = new Date();
                //register clock
                var clockTick = setInterval(function(){
                    viewData.dateTimeUTS.val += viewData.timeout;
                    d.setTime(viewData.dateTimeUTS.val);
                    viewData.dateTimeFieldHandler(d);
                },viewData.timeout);
                //Add to timers list
                viewData.timerList.push(clockTick);
            }
        };
    }
    
});
