// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define([], function() {"use strict";
window.Interval = function(arg) {
    if (arg) {
        if ('number' === typeof arg) {
            var delta = arg;
            // calculate ellapsed years
            this.years = Math.floor(delta / (1000 * 60 * 60 * 24 * 365));
            // reduce delta to remaining
            delta = (delta - (this.years * 1000 * 60 * 60 * 24 * 365));
            this.months = 0; // not used
            // calculate ellapsed days
            this.days = Math.floor(delta / (1000 * 60 * 60 * 24));
            // reduce delta to remaining
            delta = (delta - (this.days * 1000 * 60 * 60 * 24));
            // calculate ellapsed hours
            this.hours = Math.floor(delta / (1000 * 60 * 60));
            // reduce delta to remaining
            delta = (delta - (this.hours * 1000 * 60 * 60));
            // calculate remaining minutes
            this.minutes =  Math.floor(delta / (1000 * 60));
            // reduce delta to remaining
            delta = (delta - (this.minutes * 1000 * 60));
            this.seconds = Math.floor(delta / 1000);
        } else if ('object' === typeof arg) {
            this.years = arg.years;
            this.months = arg.months;
            this.days = arg.days;
            this.hours = arg.hours;
            this.minutes = arg.minutes;
            this.seconds = arg.seconds;
        }
    }
};

window.Interval.between = function (startAt, endAt) {
    // ellapsed milliseconds
    return new window.Interval(endAt.getTime() - startAt.getTime());
};

window.Interval.parseISODurationUnit = function(string, unit) {
    var parts = string.split(unit);
    var result = 0;
    if (parts.length > 1) {
        result = parseInt(parts[0].split(/[A-Z]/).slice(-1)[0], 10);
    }
    return result;
};

window.Interval.parseISODuration = function (string) {
    // PnYnMnDTnHnMnS
    var parts = string.split('T');
    var arg = {};
    arg.years = Interval.parseISODurationUnit(parts[0], 'Y');
    arg.months = Interval.parseISODurationUnit(parts[0], 'M');
    arg.days = Interval.parseISODurationUnit(parts[0], 'D');
    if (parts.length > 1) {
        arg.hours = Interval.parseISODurationUnit(parts[1], 'H');
        arg.minutes = Interval.parseISODurationUnit(parts[1], 'M');
        arg.seconds = Interval.parseISODurationUnit(parts[1], 'S');
    } else {
        arg.hours = 0;
        arg.minutes = 0;
        arg.seconds = 0;
    }
    return new Interval(arg);
};

window.Interval.prototype = {
  
    toISODuration: function () {
        var result = 'P';
        if (this.years) {
            result += this.years + 'Y';
        }
        if (this.months) {
            result += this.months + 'M';
        }
        if (this.days) {
            result += this.days + 'D';
        }
        if (this.hours || this.minutes || this.seconds) {
            result += 'T';
        }
        if (this.hours) {
            result += this.hours + 'H';
        }
        if (this.minutes) {
            result += this.minutes + 'M';
        }
        if (this.seconds) {
            result += this.seconds + 'S';
        }
        return result;
    },
    
    greaterThan: function (interval) {
        var fields = ['years', 'months', 'days', 'hours', 'minutes', 'seconds'];
        var name, length = fields.length;
        for (var i=0; i<length; i++) {
            name = fields[i];
            if (this[name] > interval[name]) {
                return true;
            } else if (interval[name] > this[name]) {
                return false;
            }
        }
        return false;
    },
    
    equal: function (interval) {
        var fields = ['years', 'months', 'days', 'hours', 'minutes', 'seconds'];
        var name, length = fields.length;
        for (var i=0; i<length; i++) {
            name = fields[i];
            if (this[name] != interval[name]) {
                return false;
            }
        }
        return true;
    }
};
});
