// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * Extend datetimepicker to update picker with the value of date set in input field
 * without redrawing the whole picker
 * e.g.
 * @arguments 'updatePicker' function identifier
 * @arguments withDate Date object to be set in picker
 * $('input-field-selector').datetimepicker('updatePicker', withDate)
 *
 */
define(['jquery', 'jqueryUI', 'lib/jquery-ui-timepicker-addon'],function(){
    (function($){
        $.extend($.datepicker, {_updatePickerDatepicker : function(target, date){
            var inst = this._getInst(target);
            if (!inst) {
                return;
            }
    
            //update datepicker
            var dpDate = new Date();
            try {
                dpDate = $.datepicker.parseDate($.datepicker._get(inst, 'dateFormat'),(inst.lastVal? inst.lastVal : null));
                var monthOrYearChanged = (dpDate.getDate()!== date.getDate());
                this._setDateFromField(inst);
                if (monthOrYearChanged) {
                    var updatedDatepicker = $.datepicker._generateHTML(inst);
                    var header = $('<div/>').append(updatedDatepicker).find('.ui-datepicker-header');
                    var calendar = $('<div/>').append(updatedDatepicker).find('.ui-datepicker-calendar');
                    inst.dpDiv.find('.ui-datepicker-header').empty().append(header.html());
                    inst.dpDiv.find('.ui-datepicker-calendar').empty().append(calendar.html());
                    this._attachHandlers(inst);
                }
            }
            catch (err) {
                $.datepicker.log(err);
            }
    
            //update timepicker
            var tp_inst = this._get(inst, 'timepicker');
            if (tp_inst && date) {
                var tp_date;
                tp_date = new Date(date.getTime());
                var defaults = tp_inst._defaults;
    
                // calling _setTime with no date sets time to defaults
                tp_inst.hour = date ? date.getHours() : defaults.hour;
                tp_inst.minute = date ? date.getMinutes() : defaults.minute;
                tp_inst.second = date ? date.getSeconds() : defaults.second;
                tp_inst.millisec = date ? date.getMilliseconds() : defaults.millisec;
    
                //check if within min/max times..
                tp_inst._limitMinMaxDateTime(inst, true);
    
                //update sliders
                if (tp_inst.hour_slider) {
                    tp_inst.control.value(tp_inst, tp_inst.hour_slider, 'hour');
                }
                if (tp_inst.minute_slider) {
                    tp_inst.control.value(tp_inst, tp_inst.minute_slider, 'minute');
                }
    
                //update timeDisplay
                var o = tp_inst._defaults,
                    pickerTimeFormat = o.pickerTimeFormat || o.timeFormat,
                    pickerTimeSuffix = o.pickerTimeSuffix || o.timeSuffix;
                    tp_inst.formattedTime = $.datepicker.formatTime(o.timeFormat, tp_inst, o);
                if (tp_inst.$timeObj) {
                    if(pickerTimeFormat === o.timeFormat){
                        tp_inst.$timeObj.text(tp_inst.formattedTime + pickerTimeSuffix);
                    }else{
                        tp_inst.$timeObj.text($.datepicker.formatTime(pickerTimeFormat, tp_inst, o) + pickerTimeSuffix);
                    }
                }
    
                //set it as false so that change event is not fired on closing the picker
                tp_inst.timeDefined = false;
            }
        }});
    })(jQuery);
});
