// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hp/core/Style', 'hp/core/Router', 'jquery', 'lib/jquery.flot.pie'], function(style, router) {
    (function($) {
        // jQuery plugin definition
        
        $.hpDonut = function(elem, data, extraOptions) {

            var VALUE = '.hp-value';
            var LABEL = '.hp-label';
            var GRAPH = '.hp-graphic';

            var plotObj = null;
            var placeholder = null;

            function openLink(ev, pos, item) {
                if (item && item.series && item.seriesIndex >= 0) {
                    var filteredLocation = data[item.seriesIndex].location ? 
                                      data[item.seriesIndex].location : null;
                    if (filteredLocation) {
                        router.go(filteredLocation, 'hpDonut clicked');
                    }
                }
             }

            function updateLabel(ev, pos, item) {
                var label = '<null>';
                $(GRAPH, elem).css('cursor', 'default');

                if (item) {
                    label = item.series ? item.series.label.text : '<no series>';
                }

                if (item && item.series) {
                    var series = item.series;
                    var location = (item.seriesIndex >= 0 && 
                            data[item.seriesIndex].location) ? 
                            data[item.seriesIndex].location : null;
                    if (location) {
                        $(GRAPH, elem).css('cursor', 'pointer');
                    }
                    if (typeof series.label === 'object') {
                        $(VALUE, elem).text(series.label.value);
                        $(LABEL, elem).text(series.label.text);
                    } else {
                        if ($.isArray(series.data)) {
                            $(VALUE, elem).text(series.data[0][1]);
                        } else {
                            $(VALUE, elem).text(series.data);
                        }
                        $(LABEL, elem).text(series.label);
                    }
                    $('label', elem).css('color', series.color);
                }
            }
          
            // build DOM
            if (! $(elem).hasClass('hp-donut')) {
                $(elem).empty();
                $(elem).append($('<div></div>').addClass('hp-graphic'));
                $(elem).append($('<label></label>'));
                $('label', elem).append($('<span></span>').addClass('hp-value'));
                $('label', elem).append($('<span></span>').addClass('hp-label'));
                $(elem).addClass('hp-donut');
            }

            // set default plot values here
            var pieLabel = { show: false };
            var pieStroke = { width: 3 };
            var gridHoverable = true;
            var gridClickable = true;

            // set plot values when no data is present 
            if(!data || data.length < 1) {
                data[0] = {data: 100, label: {value: ''}, color: style.pieNoDataColor() };
                pieLabel = {
                    show: true,
                    radius: 0,
                    formatter: function (label, series) {
                        return '<div class="hp-pie-label">//////</div>';
                    }
                };
                pieStroke = {
                        width: 1,
                        color: style.unsetColor()
                };
                gridHoverable = false;
                gridClickable = false;
            }

            // initialize plot options
            var options = {
                series: {
                  pie: {
                    // reducing radius from 1 to 0.99 to prevent the thinning 
                    // effect on the donut's outer circle
                    radius: 0.99,
                    innerRadius: 0.6,
                    show: true,
                    label: pieLabel,
                    stroke: pieStroke
                  }
                },
                colors: style.graphColors(),
                legend: {
                  show: false
                },
                grid: {
                    hoverable: gridHoverable,
                    clickable: gridClickable
                }
            };

            $.extend(true, options, extraOptions);
            var lastData = data[data.length - 1];
            if (! lastData.hasOwnProperty('color')) {
                lastData.color = style.summaryBaseColor();
            }

            // plot
            plotObj = $.plot($(GRAPH, elem), data, options);
            $(GRAPH, elem).removeAttr('style');

            // placeholder which holds the donut
            placeholder = $(GRAPH, elem);

            // events
            placeholder.off('.hpDonut');
            placeholder.on('plothover.hpDonut', updateLabel);
            placeholder.on('plotclick.hpDonut', openLink);
            
            var firstIndex = data.length - 1;
            for (var i = 0; i < data.length - 1; i++) {
                if (data[i].data) {
                    firstIndex = i;
                    break;
                }
            }
            updateLabel(null, null, {series: data[firstIndex]});
        };
    }(jQuery));
});
