// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['jquery'], function() {"use strict";
    (function($) {
        // jQuery plugin definition
        $.fn.hpStatus = function (statusArg, changingArg) {
          
            var ret;

            this.each(function() {
                var elem = $(this);
                var status = statusArg;
                var changing = changingArg;
                var statusContent;
                var classAttribute;
                var classes = [];
                var statusClasses = ['hp-status']; // used if not changing
                var containerClasses = ['hp-status']; // used if changing
                var contentClasses = ['hp-status-value']; // used if changing
                var value;
                
                // figure out what status to use, and whether it's changing
                if (! status) {
                    // no status given, use element contents
                    // see if we've already built this before
                    status = $('.hp-value', elem).text();
                    if (status) {
                        changing = ($('.hp-status-changing', elem).length > 0);
                    } else {
                        statusContent = elem.contents().eq(0);
                        if (statusContent) {
                            // e.g. 'warning' or 'warning *' or '*'
                            var array = statusContent.text().split(' ');
                            if (array[0] === '*') {
                                changing = true;
                            } else {
                                status = array[0];
                                if (array[1] && array[1] === '*') {
                                    changing = true;
                                }
                            }
                        }
                    }
                }
                
                if ('changing' === status) {
                    status = undefined;
                    changing = true;
                }
                
                // preserve non-status classes
                classAttribute = $(elem).attr('class');
                if (classAttribute) {
                    classes = $.grep(classAttribute.split(' '), function (name) {
                        return (! name.match("^hp-status") &&
                            ! name.match("^hp-changing"));
                    });
                }
                
                // Determine what the current content is.
                // Avoid modifying in case we aren't changing anything
                if (status) {
                    value = $('<span></span>').addClass('hp-value').text(status);
                    
                    if (changing) {
                    
                        contentClasses.push('hp-status-' + status);
                        
                        if ($('> .hp-status-value', elem).attr('class') !==
                            contentClasses.join(' ')) {
                            
                            value = value.wrap($('<div></div>').
                                addClass(contentClasses.join(' '))).parent();
                            elem.empty();
                            containerClasses.push('hp-changing');
                            classAttribute = classes.concat(containerClasses).join(' ');
                            elem.attr('class', classAttribute).append(value).
                                append('<div class="hp-status-changing"></div>');
                        }
                        
                    } else {
                    
                        statusClasses.push('hp-status-' + status);
                        classAttribute = classes.concat(statusClasses).join(' ');
                        
                        if (elem.attr('class') !== classAttribute) {
                            elem.empty();
                            elem.attr('class', classAttribute).append(value);
                        }
                    }
                } else if (changing) {
                    // just changing, no status label/icon
                    value = $('<span></span>').addClass('hp-value').text('changing');
                    containerClasses.push('hp-status-changing');
                    classAttribute = classes.concat(containerClasses).join(' ');
                    
                    if (elem.attr('class') !== classAttribute) {
                        elem.empty();
                        elem.attr('class', classAttribute).append(value);
                    }
                } else {
                    classAttribute = classes.concat(statusClasses).join(' ');
                    if (elem.attr('class') !== classAttribute) {
                        elem.empty();
                        elem.attr('class', classAttribute);
                    }
                }
                
                ret = ret ? ret.add(elem) : elem;
            });
            return ret;
        };
    }(jQuery));
});
