// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['jquery'], function() {
    (function($) {
        // jQuery plugin definition
        $.fn.hpToggle = function(options) {
          
            function hpToggle(elem) {
              
                var control;
                var maxWidth = 0;
                var enabled = true;
                
                // we only adjust the left position so that CSS transitions work
                function check() {
                    $(control).addClass('hp-checked');
                    $('ol', control).css('left', 0);
                    $('.hp-toggle-thumb', control).css('left', maxWidth - 10);
                    if (!$(elem).attr('checked')) {
                        $(elem).attr('checked', true).trigger('change');
                    }
                }
                
                function uncheck() {
                    $(control).removeClass('hp-checked');
                    $('ol', control).css('left', -maxWidth);
                    $('.hp-toggle-thumb', control).css('left', 3);
                    if ($(elem).attr('checked')) {
                        $(elem).removeAttr('checked');
                        $(elem).trigger('change');
                    }
                }
                
                function enable() {
                    $(control).removeAttr('disabled');
                    $(elem).removeAttr('disabled');
                    enabled = true;
                }
                
                function disable() {
                    $(control).attr('disabled', 'disabled');
                    $(elem).attr('disabled', 'disabled');
                    enabled = false;
                }
                
                function align() {
                    if ($(elem).attr('checked')) {
                        check();
                    } else {
                        uncheck();
                    }
                    if ($(elem).is(':disabled')) {
                        disable();
                    } else {
                        enable();
                    }
                }
                
                /*
                function clickOff() {
                    if (enabled) {
                        uncheck();
                    }
                }
                */
                
                /*
                function clickOn() {
                    if (enabled) {
                        check();
                    }
                }
                */
                
                function toggle() {
                    if (enabled) {
                        if ($(elem).attr('checked')) {
                            uncheck();
                        } else {
                            check();
                        }
                    }
                }
                
                function onKeyDown() {
                    if (enabled) {
                        if ($(elem).attr('checked')) {
                            uncheck();
                        } else {
                            check();
                        }
                    }
                }

                function initialize(elem) {
                    // Disable for iOS devices (their native controls are more suitable for a touch device)
                    if (navigator.userAgent.match(/iPad|iPhone|Android/i)) {
                        return false;
                    }

                    // Element must be an input control
                    if (elem.tagName.toLowerCase() !== 'input') {
                        return false;
                    }

                    // add our own elements
                    control = $('<a id="' + $(elem).attr('id') +
                      '-hpToggle" class="hp-toggle" tabindex="0"><ol>'+
                      '<li class="hp-on">'+options.checked+'</li>'+
                      '<li class="hp-off">'+options.unchecked+'</li>'+
                      '</ol><div class="hp-toggle-thumb"></div></a>');
                    control.insertBefore(elem);
                    
                    // make choices the same size so the thumb looks right
                    $('li', control).each(function(index, li) {
                        var width = $(li).outerWidth();
                        if (0 === $(li).width()) {
                            // mustn't be visible yet, approximate based on content
                            width += 8 * $(li).text().length;
                        }
                        if (width > maxWidth) {
                            maxWidth = width;
                        }
                    });
                    $('li', control).css('width', maxWidth);
                    $(control).css('width', maxWidth);
                    var thumb = $('.hp-toggle-thumb', control);
                    thumb.addClass('hp-checked');///.css({left:
                        ///(maxWidth - (thumb.outerWidth(true) / 2)) + 'px'});
                    
                    // align state with initial checkbox state
                    align();
                    
                    // hide the original checkbox
                    $(elem).addClass('hp-toggle-checkbox').hide();
                    
                    ///$('.hp-on', control).click(clickOn);
                    ///$('.hp-off', control).click(clickOff);
                    $(control).click(toggle);
                    
                    control.keydown(function (ev) {
                        var key = String.fromCharCode(ev.which);
                        if (/[a-zA-Z0-9-_ ]/.test(key)) {
                            onKeyDown();
                        }
                    });

                    // track changes to the real checkbox
                    $(elem).change(align);
                }

                initialize(elem);
            }

            // pluginify
            var instance, ret;
            this.each(function() {
                var $elem = $(this);
                instance = new hpToggle($elem[0]);
                ret = ret ? ret.add($elem) : $elem;
            });
            return ret;

        };
    }(jQuery));
});
