// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['jquery'], function() {
    (function($) {
        $.extend({
            inArrayCaseInsensitive: function (value, array, index) {
                var caseInsensitiveValue = value.toLowerCase();
                var length = array.length;
                var result = -1;
                var start = 0;
                if (index) {
                    if (index >= length) {
                        start = length - 1;
                    } else {
                        start = Math.max(0, index);
                    }
                }
                for (var i=start; i<length; i++) {
                    if (caseInsensitiveValue === array[i].toLowerCase()) {
                        result = i;
                        break;
                    }
                }
                return result;
            }
        });
    }(jQuery));
});
