// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['jquery', 'lib/jquery.cookie'], function() {"use strict";

    var DevelopmentSettings = ( function() {

        var WRITE_OPTIONS = {
            path : '/',
            secure : false,
            expires : 30
        };
        var REMOVE_OPTIONS = {
                path : '/'
            };
        var EXPERIMENTAL = "experimental";
        var ROUTING_LOG_LEVEL = "routing_log_level";
        var LABEL_LENGTH_FACTOR = "label_length_factor";
        var REFRESH_INTERVAL = "refresh_interval";
        var ACTIVITY_REFRESH_INTERVAL = "activity_refresh_interval";
        var DISABLE_AUDIO = "disable_audio";
        var HIGH_CONTRAST = "high_contrast";
        var TRACK_TIMING = "track_timing";
        var DISABLE_IPV6 = "hp-settings-edit-ipv6-disable";
        var DISABLE_FACTORY_RESET ="disable_factory_reset";
        var LOCALE = "locale";
        var DEFAULT_REFRESH_INTERVAL = 15000;//ms
        var DEFAULT_ACTIVITY_REFRESH_INTERVAL = 5000;//ms
        var DEFAULT_ROUTING_LOG_LEVEL = 0;
        //an English term might get much longer in other languages.
        //To test localization, make the string longer based on the LABEL_LENGTH_FACTOR, default to 0
        var DEFAULT_LABEL_LENGTH_FACTOR = 0;
        var DEFAULT_MAX_INDEX_ITEMS = 100;
        var SLOW = false; // for debugging


        var DEFAULTS = {
            refreshInterval: (SLOW ? 88888888 : DEFAULT_REFRESH_INTERVAL),
            activityRefreshInterval: (SLOW ? 88888888 : DEFAULT_ACTIVITY_REFRESH_INTERVAL),
            maxIndexItems: DEFAULT_MAX_INDEX_ITEMS,
            experimentalFeatures: false,
            routeLogLevel: DEFAULT_ROUTING_LOG_LEVEL,
            labelLengthFactor: DEFAULT_LABEL_LENGTH_FACTOR,
            disableAudio: false,
            disableIPv6: false,
            disableFactoryReset: false,
            highContrast: false,
            trackTiming: false,
            locale: null
        };

        /**
         * @class Model class to retain values of configuration variables used
         *     by developers.
         * @type {DevelopmentSettings}
         */
        function DevelopmentSettings() {

            var maxIndexItems = DEFAULT_MAX_INDEX_ITEMS;


            this.getMaxIndexItems = function() {
                return maxIndexItems;
            };

            this.getRefreshInterval = function() {
                var refresh = $.cookie(REFRESH_INTERVAL);
                return refresh ? parseInt(refresh, 10) : DEFAULTS.refreshInterval;
            };

            this.getActivityRefreshInterval = function() {
                var refresh = $.cookie(ACTIVITY_REFRESH_INTERVAL);
                return refresh ? parseInt(refresh, 10) : DEFAULTS.activityRefreshInterval;
            };

            this.useExperimentalFeatures = function() {
                return $.cookie(EXPERIMENTAL) === "true" ? true : false;
            };

            this.routingLogLevel = function() {
                var logLevel = $.cookie(ROUTING_LOG_LEVEL);
                return logLevel ? parseInt(logLevel, 10) : DEFAULTS.routeLogLevel;
            };

            this.getLabelLengthFactor = function() {
            	var lengthFactor = $.cookie(LABEL_LENGTH_FACTOR);
            	return lengthFactor ? parseInt(lengthFactor, 10) : DEFAULTS.labelLengthFactor;
            }

            this.disableAudio = function () {
                return $.cookie(DISABLE_AUDIO) === "true" ? true : false;
            };

            this.highContrast = function () {
                return $.cookie(HIGH_CONTRAST) === "true" ? true : false;
            };

            this.trackTiming = function () {
                return $.cookie(TRACK_TIMING) === "true" ? true : false;
            };

            this.disableIPv6 = function () {
                return $.cookie(DISABLE_IPV6) === "true" ? true : false;
            };

            this.disableFactoryReset = function () {
                return $.cookie(DISABLE_FACTORY_RESET) === "true" ? true : false;
            };

            this.locale = function () {
                return $.cookie(LOCALE);
            };

            this.save = function(attrs) {
                $.cookie(REFRESH_INTERVAL, attrs.refreshInterval, WRITE_OPTIONS);
                $.cookie(ACTIVITY_REFRESH_INTERVAL, attrs.activityRefreshInterval, WRITE_OPTIONS);
                maxIndexItems = attrs.maxIndexItems;
                $.cookie(EXPERIMENTAL, attrs.experimentalFeatures, WRITE_OPTIONS);
                $.cookie(ROUTING_LOG_LEVEL, attrs.routingLogLevel, WRITE_OPTIONS);
                $.cookie(LABEL_LENGTH_FACTOR, attrs.labelLengthFactor, WRITE_OPTIONS);
                $.cookie(DISABLE_AUDIO, attrs.disableAudio, WRITE_OPTIONS);
                $.cookie(DISABLE_IPV6, attrs.disableIPv6, WRITE_OPTIONS);
                $.cookie(DISABLE_FACTORY_RESET, attrs.disableFactoryReset, WRITE_OPTIONS);
                $.cookie(HIGH_CONTRAST, attrs.highContrast, WRITE_OPTIONS);
                $.cookie(TRACK_TIMING, attrs.trackTiming, WRITE_OPTIONS);
                if (attrs.locale) {
                    $.cookie(LOCALE, attrs.locale, WRITE_OPTIONS);
                }
                else {
                    $.removeCookie(LOCALE, REMOVE_OPTIONS)
                }
            };

            this.setDefaults = function() {
                this.save(DEFAULTS);
            };
        }

        return new DevelopmentSettings();

    }());

    return DevelopmentSettings;

});
