// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {SessionRoutes}
 */
define(['hp/core/Router', 'hp/core/Localizer'],
function (router, localizer) { "use strict";

    var SearchRoutes = ( function() {

        var CONTAINER = '#hp-page-container';

        function SearchRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('search', '^/search?.*', {
                    menu: {
                        label: localizer.getString('core.menu.search'),
                        location: '/search'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/search/index.html',
                            'hp/view/SearchView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
            };
        }

        return new SearchRoutes();
    }());

    return SearchRoutes;
});
