// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/model/Resource', 'jquery'], function(Resource) {"use strict";
    var UploaderModel = ( function() {
        function UploaderModel() {

            // derive from Resource
            Resource.call(this, 'appliance');

            var PROGRESS_DEFAULT = {
                value : 0,
                max : 0
            };

            var uploading = false;
            var results = {};
            var error = {};
            var aborted = false;
            var progress = {
                value:PROGRESS_DEFAULT.value,
                max:PROGRESS_DEFAULT.max
            };
            var options = {};
            var pending = false;
            var files = [];
            var startTime = 0;
            var stopTime = 0;
            
            this.isUploading = function() {
                return uploading;
            };
            this.setUploading = function() {
                uploading = true;
            };
            this.setUploadDone = function() {
                uploading = false;
            };

            this.setResults = function(serverResults) {
                results = serverResults;
            };

            this.getResults = function() {
                return results;
            };
            
            this.setStartTime = function(t) {
                startTime = t;
            };

            this.getStartTime = function() {
                return startTime;
            };
            
            this.setStopTime = function(t) {
                stopTime = t;
            };

            this.getStopTime = function() {
                return stopTime;
            };
            
            this.setError = function(errorInfo) {
                error = errorInfo;
            };
            this.getError = function() {
                return error;
            };
            this.setAborted = function() {
                aborted = true;
            };
            this.getAborted = function() {
                return aborted;
            };
            
            this.getPending = function(){
                return pending;
            };
            this.setPending = function(isPending){
                pending = isPending;
            };
            
            this.setOptions = function(opts){
                options = opts;
            };
            this.getOptions = function(){
                return options;
            };

            this.updateProgress = function(e) {
                if(e.lengthComputable) {
                    progress.value = e.loaded;
                    progress.max = e.total;
                }
            };
            this.getProgress = function() {
                return progress;
            };
            
            this.setFiles = function(f){
                files = f;
            };
            this.getFiles = function(){
                return files;
            };
       
            this.clear = function() {
                uploading = false;
                error = {};
                results = {};
                progress = {
                    value : PROGRESS_DEFAULT.value,
                    max : PROGRESS_DEFAULT.max
                };
                aborted = false;
                options = {};
                pending = false;
                files = [];
            };


        }

        return UploaderModel;

    }());

    return UploaderModel;

});
