// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Router'],
function (router) { "use strict";

    var SettingsShowRoutes = ( function() {

        var CONTAINER = '#hp-settings-show .hp-details-show-view';

        function SettingsShowRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                
                registered = true;

                router.filter('settings show default redirector', '/settings/show($|/$)', {
                    check: function (location, result) {
                        result.replaceWith('/settings/show/overview');
                    }
                });

                router.map('settings show no route', '/settings/show/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_page.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            };
        }

        return new SettingsShowRoutes();
    }());

    return SettingsShowRoutes;
});
