// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/services/settings/SupportDumpService',
        'hp/core/EventDispatcher',
        'jquery'],
function(service, EventDispatcher) {"use strict";
    var SupportDumpResource = ( function() {
        function SupportDumpResource() {

            var dispatcher = new EventDispatcher();

            function onCreateDumpSuccess(data){
                dispatcher.fire("onCreateDumpSuccess",data.uri);
            }

            function onCreateDumpError(errorInfo){
                dispatcher.fire("onCreateDumpError",errorInfo);
            }

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };

            this.clear = function() {
            };

            this.createDump = function(value){
                service.createDump(value, {
                    success: onCreateDumpSuccess,
                    error: onCreateDumpError
                });
            };

        }

        return new SupportDumpResource();

    }());

    return SupportDumpResource;

});
